%define destdir %buildroot
%global myhome /usr/local
%global category mail
BuildRoot: %_builddir/%{name}-%version-root
Group: Utilities/System
License: BSD
Name: qconfirm
Packager: mw@csi.hu
Release: 1memphis
Requires: qmail daemontools
Source0: http://smarden.org/qconfirm/%{name}-%{version}.tar.gz
Summary: Implementation of a mail delivery confirmation process
URL: http://smarden.org/qconfirm/
Version: 0.14.3

%description 

qconfirm is an implementation of a delivery confirmation process for a
mail address. It is invoked by qmail-local through a .qmail file.

qconfirm performs this delivery confirmation process either
sender-based or message based.

If qconfirm-check runs in sender mode, messages from known envelope
senders are accepted without a confirmation, and immediately allowed
to be processed further in the .qmail file.

If qconfirm-check runs in message mode, each single message needs to
be confirmed to be allowed to be processed further in the .qmail file.

%prep
%setup -qcn %destdir/package

%build
mkdir -p %destdir%myhome/bin
cd %category/%name-%version
sed -e 's}^parent.*}parent=/package/%category}' \
    -e 's} /command/} %destdir/command/}g' \
    -e 's}-p /command}-p %destdir/command}' \
    -e 's}ln -s %destdir/command/}ln -s /command/}' \
    -e 's} /usr/local/bin/} %destdir/usr/local/bin/}g' \
    -e 's}/usr/local}%myhome}g' \
    package/upgrade > package/upgrade'{new}' 

if [ "$?" != 0 ]; then
    exit 1
else
    mv package/upgrade'{new}' package/upgrade
    chmod 755 package/upgrade
fi


package/compile

COMPILER="Compiler: $(gcc -v 2>&1 | tail -1)"
HARDWARE="Hardware: $(uname -m)"
LIBRARY="Library: $(rpm -q glibc)"
OSVERSION="OSversion: $(uname -sr)"
PACKAGER="Packager: %packager"
REDHATRELEASE="RedHat release: $(cat /etc/redhat-release)"
RPMVERSION="rpm version: $(rpm -q rpm)"

echo "The %name rpm was created in the following environment:
" > README_rpm

echo "$COMPILER
$HARDWARE
$LIBRARY
$OSVERSION
$PACKAGER
$REDHATRELEASE
$RPMVERSION

The packager above has made an honest attempt to make sure
the package behaves correctly.
" >> README_rpm

%install
cd %category/%name-%version
package/upgrade

cp package/{README,COPYING,CHANGES} README_rpm doc/* %destdir/package

%clean
rm -rf %destdir

%files
%defattr(-,root,root)

%dir /package/%category/%name-%version
%doc CHANGES  COPYING README* *.html
%myhome/bin/*
/command/*
/package/%category/%name
/package/%category/%name-%version/command
/package/%category/%name-%version/doc
/package/%category/%name-%version/man
/package/%category/%name-%version/package
/package/%category/%name-%version/src


%changelog
* Sat Jul  6 2002 Mate Wierdl <mw@csi.hu>
- Initial build.


