#ifdef LUACONSOLE
// socket.lua from luasocket compiled into a cpp file
#include "../LuaCompat.h"
void luaopen_socket(lua_State *l){
	int socket_luac_sz=4061;
	const char* socket_luac="-----------------------------------------------------------------------------\012-- LuaSocket helper module\012-- Author: Diego Nehab\012-- RCS ID: $Id: socket.lua,v 1.22 2005/11/22 08:33:29 diego Exp $\012-----------------------------------------------------------------------------\012\012-----------------------------------------------------------------------------\012-- Declare module and import dependencies\012-----------------------------------------------------------------------------\012local base = _G\012local string = require(\042string\042)\012local math = require(\042math\042)\012local socket = require(\042socket.core\042)\012module(\042socket\042)\012\012-----------------------------------------------------------------------------\012-- Exported auxiliar functions\012-----------------------------------------------------------------------------\012function connect(address, port, laddress, lport)\012    local sock, err = socket.tcp()\012    if not sock then return nil, err end\012    if laddress then\012        local res, err = sock:bind(laddress, lport, -1)\012        if not res then return nil, err end\012    end\012    local res, err = sock:connect(address, port)\012    if not res then return nil, err end\012    return sock\012end\012\012function bind(host, port, backlog)\012    local sock, err = socket.tcp()\012    if not sock then return nil, err end\012    sock:setoption(\042reuseaddr\042, true)\012    local res, err = sock:bind(host, port)\012    if not res then return nil, err end\012    res, err = sock:listen(backlog)\012    if not res then return nil, err end\012    return sock\012end\012\012try = newtry()\012\012function choose(table)\012    return function(name, opt1, opt2)\012        if base.type(name) ~= \042string\042 then\012            name, opt1, opt2 = \042default\042, name, opt1\012        end\012        local f = table[name or \042nil\042]\012        if not f then base.error(\042unknown key (\042.. base.tostring(name) ..\042)\042, 3)\012        else return f(opt1, opt2) end\012    end\012end\012\012-----------------------------------------------------------------------------\012-- Socket sources and sinks, conforming to LTN12\012-----------------------------------------------------------------------------\012-- create namespaces inside LuaSocket namespace\012sourcet = {}\012sinkt = {}\012\012BLOCKSIZE = 2048\012\012sinkt[\042close-when-done\042] = function(sock)\012    return base.setmetatable({\012        getfd = function() return sock:getfd() end,\012        dirty = function() return sock:dirty() end\012    }, {\012        __call = function(self, chunk, err)\012            if not chunk then\012                sock:close()\012                return 1\012            else return sock:send(chunk) end\012        end\012    })\012end\012\012sinkt[\042keep-open\042] = function(sock)\012    return base.setmetatable({\012        getfd = function() return sock:getfd() end,\012        dirty = function() return sock:dirty() end\012    }, {\012        __call = function(self, chunk, err)\012            if chunk then return sock:send(chunk)\012            else return 1 end\012        end\012    })\012end\012\012sinkt[\042default\042] = sinkt[\042keep-open\042]\012\012sink = choose(sinkt)\012\012sourcet[\042by-length\042] = function(sock, length)\012    return base.setmetatable({\012        getfd = function() return sock:getfd() end,\012        dirty = function() return sock:dirty() end\012    }, {\012        __call = function()\012            if length <= 0 then return nil end\012            local size = math.min(socket.BLOCKSIZE, length)\012            local chunk, err = sock:receive(size)\012            if err then return nil, err end\012            length = length - string.len(chunk)\012            return chunk\012        end\012    })\012end\012\012sourcet[\042until-closed\042] = function(sock)\012    local done\012    return base.setmetatable({\012        getfd = function() return sock:getfd() end,\012        dirty = function() return sock:dirty() end\012    }, {\012        __call = function()\012            if done then return nil end\012            local chunk, err, partial = sock:receive(socket.BLOCKSIZE)\012            if not err then return chunk\012            elseif err == \042closed\042 then\012                sock:close()\012                done = 1\012                return partial\012            else return nil, err end\012        end\012    })\012end\012\012\012sourcet[\042default\042] = sourcet[\042until-closed\042]\012\012source = choose(sourcet)\012\012";
	luaL_loadbuffer(l, socket_luac, socket_luac_sz, "@builtin socket.lua");
	lua_call(l, 0, 0);
}
#endif
