/*
 * Log:    pagetty.c,v 
 * Revision 1.1	 85/10/28  17:38:31  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"
#ifndef lint
#if 0
static char __unused RCSid[] = "Header: pagetty.c,v 1.1 85/10/28 17:38:31 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: pagetty.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif



/*
 *  Page a local user to his terminal. 
 *  We compose the message, then send it 
 *  in one big block so as to minimise messing
 *  him up if he's in vi or the like.
 */

void
pagetty(INV *inv, const char *tty)
{
    struct  tm	 *tm;
    time_t    now;
    char    buf[100], mesg[300];
    int	    fd;	    /* tty file descriptor */

    time(&now);
    tm = localtime(&now);

    /*	Now to compose the message  */
#ifdef notdef
    len = snprintf(buf, sizeof(buf), "\r\n\7Message from Phone_Daemon@%s at %d:%02d ...\r\n", 
		host, tm->tm_hour, tm->tm_min);
#endif
    snprintf(buf, sizeof(buf), "\r\n\7Message from the Telephone_Operator@%s at %d:%02d ...\r\n", 
		host, tm->tm_hour, tm->tm_min);
    strlcpy(mesg, buf, sizeof(mesg));

    snprintf(buf, sizeof(buf), "phone: connection requested by %s@%s\r\n", 
		inv->caller, inv->host);
    strlcat(mesg, buf, sizeof(mesg));

    snprintf(buf, sizeof(buf), "phone: respond with \"phone %s", inv->caller);
    strlcat(mesg, buf, sizeof(mesg));

    /* only list host if it differs from our own */
    if (strcmp(inv->host, host)) {
	strlcat(mesg, "@", sizeof(mesg));
	strlcat(mesg, inv->host, sizeof(mesg));
    }

    strlcat(mesg, "\"\r\n\r\n\7", sizeof(mesg));

    /*	And send it  */
    if ((fd = open(tty, O_WRONLY, 0444)) < 0) {	  /* shouldn't happen */
	syslog(LOG_ERR, "phoned: can't open %s: %m", tty);
	_exit(-99);
    }
    
   (void) write(fd, mesg, strlen(mesg));
   (void) close(fd);

    _exit(0);
}
