/*
 * Log:    main.c,v 
 * Revision 1.1	 85/10/28  17:38:28  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"

#ifndef lint
#if 0
static char __unused RCSid[] = "Header: main.c,v 1.1 85/10/28 17:38:28 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: main.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif

char	myaddr[MAXHOSTNAMELEN];	 /* internet host address in ascii dot notation */

/*
 *   Master phone daemon, sits on known socket address and
 *   listens for requests...  Handles invitations, acts as
 *   central clearinghouse for conversations.
 */

int
main(int argc, char *argv[])
{
#if defined(SERVICES) && !defined(INETD)
    struct   servent *sp;
#endif
    struct   sockaddr_in  sin;
    struct   hostent *hp;
    int	     sock;
#ifndef INETD
    int	     port = PORT;
#endif

    invitations = NULL;
    freelist	= NULL;

#ifdef INETD
    if (argc != 1) {
	fprintf(stderr, "%s takes no options!\n", argv[0]);
	exit(1);
    }
#else /*  !INETD */
    if (argc > 2) {
	fprintf(stderr, "Usage: %s [ port# ]\n", argv[0]);
	exit(1);
    }
#endif /* INETD */

#ifndef INETD
    if (argc == 2) {
	if ((port = atoi(argv[1])) == 0)
	    errx(1, "Bad port number: %s\n", argv[1]);
    }
#endif /* INETD */
#if defined(SERVICES) && !defined(INETD)
    else {
	if ((sp = getservbyname(SERVICE, "udp")) ==NULL)
	    errx(1, "%s/udp: unknown service.\n", SERVICE);
	/* BZS - suggested fix from escott@ics.uci.edu, 8/20/86 */
	port = htons(sp->s_port);
	/**/
    }
#endif /* SERVICES */

#ifndef INETD
    /*	Open and initialize the socket we will take requests on	 */
    if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	err(1, "Cannot create datagram socket");
    memset(&sin, 0, sizeof(sin));
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = htons(port);
    sin.sin_family = AF_INET;

    if (bind(sock, (void *)&sin, sizeof(sin)))
	err(1, "Cannot bind datagram socket");
#else /* INETD */
    sock = 0;		/* inetd hands us the first packet on stdin */
#endif /* INETD */

    /*	Initialize the work socket as well  */
    if ((misc = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	err(1, "Cannot create datagram work socket");
    memset(&sin, 0, sizeof(sin));
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = 0;
    sin.sin_family = AF_INET;
    if (bind(misc, (void *)&sin, sizeof(sin)))
	err(1, "Cannot bind datagram work socket");

    signal(SIGCHLD, sigchld);
    signal(SIGALRM, ring);
    gethostname(host, sizeof(host));

    if ((hp = gethostbyname(host)) == NULL)
	errx(1, "cannot find my own address!!!\n");
    memcpy(&sin.sin_addr, hp->h_addr, sizeof(sin.sin_addr));
    strlcpy(myaddr, inet_ntoa(sin.sin_addr), sizeof(myaddr));

#if defined(FORK) && !defined(INETD)
    if (fork())
	exit(0);

    if (sock != 0)
	close(0);
    int fd = open("/dev/null", 0);
    if (sock != 1)
	dup2(fd, 1);
    if (sock != 2)
	dup2(fd, 2);

    setsid();
    if ((fd = open("/dev/tty", 0)) != -1) {
	ioctl(fd, TIOCNOTTY);
	close(fd);
    } else 
	setpgid(0, getpid());
#endif /* FORK && !INETD */

#ifdef LOG_ODELAY
    openlog("phoned", LOG_PID | LOG_ODELAY, 0);
#else
    openlog("phoned", LOG_PID, 0);
#endif

    service(sock);
    exit(0);
}


/*
 *  Main service routine.
 *  Listen on the socket, process requests.
 */

void
service(int sock)
{
    socklen_t len;
    int	 rval;
    char *av[10];
    char buf[1024];
    struct sockaddr_in sin;
    struct pollfd pfd;

    pfd.fd = sock;
    pfd.events = POLLIN;
    for ( ;; ) {
	if (poll(&pfd, 1, INFTIM) <= 0)
	    continue;
	len = sizeof(sin);
	if ((rval = recvfrom(sock, buf, sizeof(buf), 0, (void *)&sin, &len)) <= 0) {
	    syslog(LOG_ERR, "recvfrom: %m");
	    continue;
	}
	if (*buf != ESC)
	    continue;
	buf[rval] = '\0';
	parse(buf+2, av);
	switch (buf[1]) {	/* figure out command */
	case PAGE:	page(av, &sin);	    break;
	case REINVITE:	reinvite(av, &sin); break;
	case INQUIRE:	inquire(av, &sin);  break;
	case ANSWER:	answer(av);	    break;
	case DAEMON:	xdaemon(&sin);	    break;
	case WHO:	who(&sin);	    break;
	case KILL:	exit(0);	    break;
	}
    }
}


/*
 *  Parse the buffer into an argument vector.
 */

int
parse(char *buf, char **argv)
{
    char **ap;
    char *b;

    ap = argv;

    for (b = buf; b && *b && *b != '\n'; ) {
	*ap++ = b;
	for ( ; b && *b && *b != ':' && *b != '\n'; b++)
	    ;
	*b++ = '\0';
    }
    *ap = NULL;
    return ap - argv;
}
