/*
 * Log:    child.c,v 
 * Revision 1.1	 85/10/28  17:38:11  broome
 * Initial revision
 */
#include "../common.h"
#include "defs.h"

#ifndef lint
#if 0
char RCSid[] = "Header: child.c,v 1.1 85/10/28 17:38:11 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: child.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif

/*
 *   A more complicated sigchld handler -
 *   looks for the pid in the list of invitations
 *   and sends appropriate status messages to the callers.
 */

void
sigchld(int s __unused)
{
    INV	    *inv;
    int	     status;
    pid_t    pid;
    int	     exitstat;
    char     buf[1024];

    while ((pid = wait3(&status, WNOHANG, 0)) > 0) {   /* any children? */
	if (WIFSTOPPED(status)) {      /* shouldn't happen */
	    kill(pid, 9);
	    exitstat = 1;
	} else
	    exitstat = WEXITSTATUS(status);

	for (inv = invitations; inv; inv = inv->next)
	    if (inv->pid == pid) /* does pid match? */
		break;

	if (inv == NULL ||  /* budd */
	    inv->pid != pid)	/* didn't find child - continue */
	    continue;

	if (exitstat &&(inv->flags & PROG))
	    inv->flags |= DONTFORWARD; /* their program has problems */
	
	/*
	 *  Now send a message to the user.
	 *  The multiple sprintf()'s aren't very pretty ...
	 */
	
	if (exitstat == 0) {	/* good exit status - ok */
	    snprintf(buf, sizeof(buf), "%s%sing user %s@%s",
		 inv->id,(inv->flags & PROG) ? "Forward" :
		    "Ring", 
		 inv->callee, host);
	    if ((inv->flags & PROG) == 0) {
		strlcat(buf, " on ", sizeof(buf));
		strlcat(buf, inv->ptty, sizeof(buf));
	    }
	} else {
	    snprintf(buf, sizeof(buf), "%sCannot ring %s@%s - Unknown error", 
			inv->id, inv->callee, host);
	}
	if (sendit(misc, (void *)&inv->ctladdr,
	    "%c%c%c%s", ESC, CALLING, exitstat ? NAK : ACK, buf) < 0)
	    warn("child: sendto");
    }
}
