#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: kb.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif

/*
 *  Handle keyboard input.
 *
 *  Need to handle edit character mapping --- see if char is one
 *  of his edit characters, swap to standard character.
 */

static struct key {
    int	    his;	/* his key */
    int	    std;	/* what we'll map it to */
} keys [] = {
    { CTRL('M'), CTRL('J') },	   /* <cr> -> newline */
    { 0,	 CTRL('H') },	   /* backspace */
    { 0,	 CTRL('W') },	   /* word erase */
    { 0,	 CTRL('X') },	   /* line kill */
    { 0,	 0	   }
};


void
keyboard(void)
{
    static   char   c;		    /* character read in    */
	     int    k;		    /* for doing key maps   */
    static   int    command = 0;    /* on bottom line?	    */
    static   int    cpos = 0;	    /* position in buffer   */
    static   char   cbuf[80];	    /* and command buffer   */
    static   int y, x;

    if (read(0, &c, 1) != 1)
	return;
    
    /*
     *	We remap the basic editing characters here to make life easier later.
     */

    for (k = 0; k < 4; k++) {
	if (keys[k].his == c) {
	    c = keys[k].std;
	    break;
	}
    }

    if (c == CTRL('L') || c == CTRL('R')) {
	wrefresh(curscr);
	return;
    }

    if (c == ESC) {		/* toggle command mode */
	getyx(stdscr, y, x);   /* save the current cursor position */
	move(maxy, 0);	       /* jump to bottom line */
	clrtoeol();
	command = !command;	/* toggle mode */
	if (command)		/* entering command mode  */
	    addstr(PROMPT);
	cpos = 0;		/* and reset buffer strchr */
	move(y, x);	       /* restore cursor position */
	refresh();
	return;
    } 

    if (command == 0) {			    /* not in command mode */
	if ((c == CTRL('D')) && childpid)     /* send eof to child */
	    close(tochild);
	if (childpid == 0 || Echo) {	    /* send char to the socket */
#ifdef LOCAL_ECHO
	    int old = selwin(-1);
	    showch(c);
	    selwin(old);
	    refresh();
#endif /* LOCAL_ECHO */
	   (void) write(stream, &c, 1);
	}
	if (childpid && !Hold)		    /* and to child process */
	   (void) write(tochild, &c, 1);
	return;
    } else {

	/* 
	 *    The rest is command-mode processing where 
	 *    we fiddle with the command buffer. This 
	 *    should move to a separate routine somewhere.
	 */

	getyx(stdscr, y, x);	   /* save the current cursor position */
	if (c == CTRL('J')) {	      /* execute the buffer */
	    cbuf[cpos] = '\0';	    /* null-terminate it  */
	    move(maxy, 0);	   /* go to beginning of line */
	    clrtoeol();		   /* clear line to end	 */
	    refresh();		   /* update the screen	 */
	    if (cpos)
		execute(cbuf);	   /* and execute it !!! */
	    command = cpos = 0;	    /* turn off command mode */
	    move(y, x);		   /* restore cursor position */
	    refresh();
	    return;		    /* and we're done */
	}

	/*
	 *  The message() routine modified the bottom line,
	 *  so reprint whatever should be down there.
	 */

	if (touched25) {
	    move(maxy, 0);	   /* go to beginning of line */
	    addstr(PROMPT);	   /* print prompt */
	    cbuf[cpos] = '\0';
	    addstr(cbuf);	   /* and print buffer */
	    clrtoeol();
	    touched25 = 0; 
	}

	move(maxy, strlen(PROMPT) + cpos);

	/*
	 *  If we're here, then we want to add the character to
	 *  the pending command buffer.
	 */

	switch(c) {
	case CTRL('H'):	  /* backspace */
			if (cpos) {
			    cpos--;
			    addstr("\b \b");
			}
			break;

	case CTRL('W'):	  /* word erase */
			while (--cpos >= 0) {
			    if (cbuf[cpos] != ' ') {
				cpos++;
				break;
			    }
			    addstr("\b \b");
			}
			while (--cpos >= 0) {
			    if (cbuf[cpos] == ' ') {
				cpos++;
				break;
			    }
			    addstr("\b \b");
			}
			break;

	case CTRL('U'):	  /* line kill */
	case CTRL('X'):	  move(maxy, strlen(PROMPT));
			clrtoeol();
			cpos = 0;
			break;

	case CTRL('I'):	  /* tab */
			c = ' ';     /* fall through ... */
	default:	cbuf[cpos++] = c;
			addch(c);
			break;
	}
	cbuf[cpos] = '\0';
	move(y, x);	       /* restore cursor position */
	refresh();
	return;
    }
}


/*
 *   Get our editing characters. Called by setup().
 */

void
geteditchars(void)
{
    struct termios ts;

    if (tcgetattr(0, &ts) == -1) {
	error(0, "tcgetattr failed");
	return;
    }
    keys[1].his = ts.c_cc[VERASE];
    keys[2].his = ts.c_cc[VWERASE];
    keys[3].his = ts.c_cc[VKILL];
}
