#include "../common.h"
#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: getdaemon.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif

/*
 *  Ask the master daemon to give us its first-born child ...
 *  Returns the string that it gave us ...
 */

char *
getdaemon(void)
{
    int	   r;			/* number of chars read */
    char   buf[80];

    if (connected) {
	error(0, "getdaemon(): already connected!");
	return NULL;
    }
    connected = 0;

    if (Debug)
	message("Asking for a conversation daemon ...");

    for ( ;; ) {
	if ((r = sendit(buf, sizeof(buf), &locaddr, "%c%c", ESC, DAEMON)) < 0) {
	    error(0, "could not get conversation daemon from local daemon");
	    return(NULL);
	}
	buf[r] = '\0';
	if (buf[2] == NAK) {
	    putmessage("Daemon failed to fork: %s", buf + 3);
	} else
	    break;
	putmessage("Trying to connect to conversation daemon.");
    }

    if (Debug)
	message("Daemon address is %s", buf + 3);

    return strsave(buf + 3);   /* skip ESC D y */
}
