#!/usr/bin/perl -w
#
# $Id: verify.t,v 1.1 2001/05/07 23:38:48 ftobin Exp $
#

use lib 't';

use strict;
use English;
use IPC::Open3;

use MyTest;
use MyTestSpecific;

my @signed = readfile( $signed_fn );
my $in  = IO::Handle->new();
my $out = IO::Handle->new();
my $err = IO::Handle->new();

my $pid;
TEST
{
    $pid = open3( $in, $out, ">&STDERR", @pgpenvelope_decrypt );

    $in->print( @signed );
    $in->close();

    while ( <$out> )
    {
	return 1 if /^gpg: Good signature/i;
    }
    
    return 0;
};


TEST
{
    waitpid $pid, 0;
    return $CHILD_ERROR == 0;
};
