#  MyTestSpecific.pm
#    - module for use with test scripts
#
#  Copyright (C) 2001 Frank J. Tobin <ftobin@uiuc.edu>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, visit the following URL:
#  http://www.gnu.org
#
#  $Id: MyTestSpecific.pm,v 1.1 2001/05/07 23:38:48 ftobin Exp $
#

use strict;
use English;
use IO::File;
use Exporter;
use File::Spec;
use Exporter;
use vars qw( @ISA  @EXPORT
	     @pgpenvelope_decrypt @pgpenvelope_encrypt
	     $signed_fn 
	   );

push @ISA, qw( Exporter );
@EXPORT = qw( readfile @pgpenvelope_decrypt @pgpenvelope_encrypt );

my $decrypt = File::Spec->catfile( 'blib', 'script', 'pgpenvelope_decrypt' ),
my $homedir = File::Spec->catdir( 't', 'pgpenvelope' );

@pgpenvelope_decrypt = ( $decrypt, '--filter', '--homedir', $homedir );

$signed_fn = File::Spec->catfile( 't', 'test-data', 'plain.signed.asc' );

my $libdir = File::Spec->catdir( 'blib', 'lib' );

if ( $ENV{PERL5LIB} )
{
    $ENV{PERL5LIB} .= ":$libdir";
}
else
{
    $ENV{PERL5LIB} = $libdir;
}


sub readfile
{
    my ( $fn ) = @_;
    my $f = IO::File->new( $fn )
      or die "error opening $fn: $ERRNO";
    return <$f>;
}


1;
