#  EncryptionKey.pm
#    - encompass some encryption information for GnuPG::Keys
#
#  Copyright (C) 2000 Frank J. Tobin <ftobin@uiuc.edu>
#
#  This file is part of pgpenvelope
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, visit the following URL:
#  http://www.gnu.org/copyleft/gpl.html
#
#  $Id: EncryptionKey.pm,v 1.1 2001/04/30 02:15:11 ftobin Exp $
#

package PGPEnvelope::EncryptionKey;

push @ISA, 'GnuPG::PublicKey', 'PGPEnvelope::Key';

use strict;

use GnuPG::PublicKey;
use PGPEnvelope::Key;

use Class::MethodMaker
  get_set   => [ qw( preferred_subkey_hex_id ) ];


sub pgpenvelope_init
{
    my ( $self ) = @_;
    $self->short_key_type( 'pub' );
}



sub info
{
    my ( $self, %args ) = @_;
    my $short_only = $args{short} || 0;
    
    my @user_id_strings;
    foreach my $user_id ( $self->user_ids() )
    {
	push @user_id_strings, $user_id->as_string();
    }
    
    
    my @info = ( join( ' ', ( $self->short_key_type()  . ' ' ),
		       $self->short_hex_id(),
		       $self->creation_date_string(),
		       shift @user_id_strings,
		     )
		 . "\n"
	       );
    
    unless ( $short_only )
    {
	foreach my $user_id ( @user_id_strings )
	{
	    push @info, "uid                      $user_id\n";
	}
    }
    
    
    my $preferred_subkey_hex_id = $self->preferred_subkey_hex_id();
    
    foreach my $subkey ( $self->subkeys() )
    {
	my $info = join( ' ', 'sub ', $subkey->short_hex_id(),
			 $subkey->creation_date_string(),
		       );
	
	$info .= " *** subkey selected for encryption ***"
	  if $preferred_subkey_hex_id
	    and $subkey->hex_id() eq $preferred_subkey_hex_id;
	
	push @info, $info . "\n";
    }
    
    return @info;
}
