/*
 * $Header: /home/vikas/src/nocol/utility/RCS/show_nocol_struct_sizes.c,v 1.6 1999/02/02 19:37:00 vikas Exp $
 *
 * Small utility program to show the size of the various fields of the EVENT
 * structure in NOCOL.
 *
 * Required to show additional padding and the corresponding PERL format
 * string for nocollib.pl. Especially motivated by DEC-OS (64bit was
 * causing all kinds of alignment problems). The perl program 'pstruct'
 * should have worked but some versions gave wierd errors.
 *
 * On Dec Alpha, this program generates:
 *	a11 x a15 x a127 x x4 a15 x L L a7 x CCCC C C C x1
 *
 *
 * SPECIFIC TO THE event STRUCTURE. WILL NEED TO UPDATE CODE IF THE STRUCTURE
 * CHANGES.
 *
 * ALSO, USED BY Makefile TO INSERT THE $event_t STRING IN nocollib.pl
 * SO DO NOT CHANGE THE LAST LINE WHICH IS PRINTED.
 *
 *	Author: Vikas Aggarwal, vikas@navya.com
 *
 * $Log: show_nocol_struct_sizes.c,v $
 * Revision 1.6  1999/02/02 19:37:00  vikas
 * Forgot to change 2 void's to char.
 *
 * Revision 1.5  1999/02/02 19:15:33  vikas
 * Changed the 'void' to a 'char' to help picky compilers.
 *
 * Revision 1.4  1999/02/02 15:15:39  vikas
 * Tediously calculating the address and size of each element in
 * the nocol structure.
 *
 * Revision 1.3  1998/10/02 20:32:22  vikas
 * Only the format is printed on the last line.
 *
 * Revision 1.2  1998/10/02 18:48:34  vikas
 * Updated.. now prints out the actual Perl format string.
 *
 *
 */
#include "../include/nocol.h"

/*
{
    char        name[MAXNMLEN];  
    char        addr[MAXADDRLEN];
} SITE;

{
    char        name[MAXNMLEN]; 
    u_long      value;          
    u_long      threshold;      
    char        units[8];       
} VAR;

{
    char        sender[MAXPROGNM];
    SITE                site;     
    VAR                 var;      
    unsigned char       mon;      
    unsigned char       day;      
    unsigned char       hour;     
    unsigned char       min;      
    unsigned char       severity; 
    unsigned char       loglevel;   
    unsigned char       nocop;
} EVENT;

*/ 

#define S(x)	sizeof(x)
#define calcPad(a,b,c)	  pad = (char *)&(b) - ((char *)&(a)) - c; \
  if (pad > 0) { \
    printf("pad= %ld\n", pad); \
    sprintf(tstr, "x%ld ", pad); \
    strcat(str, tstr); \
  }

/* Needed to keep compiler happy */
int debug;
char *prognm;

main()
{
  long  pad;
  char str[1024], tstr[64];
  EVENT v;

  str[0] = '\0';

  sprintf(tstr, "a%d x ", S(v.sender) - 1);
  strcat(str, tstr);

  calcPad(v.sender[0], v.site.name[0], sizeof(v.sender));
  sprintf(tstr, "a%d x ", S(v.site.name) - 1); strcat(str, tstr);

  calcPad(v.site.name[0], v.site.addr[0], sizeof(v.site.name));
  sprintf(tstr, "a%d x ", S(v.site.addr) - 1); strcat(str, tstr);

  calcPad(v.site.addr[0], v.var.name[0], sizeof(v.site.addr));
  sprintf(tstr, "a%d x ", S(v.var.name) - 1); strcat(str, tstr);

  calcPad(v.var.name[0], v.var.value, sizeof(v.var.name));
  strcat(str, "L ");

  calcPad(v.var.value, v.var.threshold, sizeof(v.var.value));
  strcat(str, "L ");

  calcPad(v.var.threshold, v.var.units[0], sizeof(v.var.threshold));
  sprintf(tstr, "a%d x ", S(v.var.units) - 1);  strcat(str, tstr);

  calcPad(v.var.units[0], v.mon, S(v.var.units)); strcat(str, "C");
  calcPad(v.mon, v.day, S(v.mon)); strcat(str, "C");
  calcPad(v.day, v.hour, S(v.day)); strcat(str, "C");
  calcPad(v.hour, v.min, S(v.hour)); strcat(str, "C ");
  calcPad(v.min, v.severity, S(v.min)); strcat(str, "C ");

  calcPad(v.severity, v.loglevel, S(v.severity)); strcat(str, "C ");
  calcPad(v.loglevel, v.nocop, S(v.loglevel)); strcat(str, "C ");

  /* final padding for entire structure */
  pad = sizeof(v) - ((char *)(&v.nocop) - (char *)(&v) + sizeof(v.nocop));
  if (pad > 0) printf("(Extra structure padding = %ld bytes)\n", pad);
  sprintf(tstr, "x%ld", pad); strcat(str, tstr);
  printf ("Perl format string: $event_t = \n");
  printf ("%s\n", str);
}
