/* $Header: /home/vikas/src/nocol/include/RCS/noclogd.h,v 2.3 1999/10/19 05:36:16 vikas Exp $ */


#ifndef __noclogd_h
# define __noclogd_h

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "nocol.h"

/* This dir definition is needed since program does a 'chdir' to it */
#ifndef ETCDIR
# define ETCDIR 	"../../etc"
#endif

#ifndef PIDDIR
# define PIDDIR		"../../run"
#endif

/* File for daemon error messages  */
#define NLOG_ERRORFILE(s)  *s= '\0'; strcat(strcat(s, PIDDIR),"/noclogd.error")

/*
 * Host where the NOCOL logging daemon runs. Needed by clients.
 * Can give an IP address instead of a name
 */
#ifndef NLOG_HOST
# define NLOG_HOST		"noclog.navya.com"	/* as a hostname */
/*  # define NLOG_HOST		"128.121.50.2" 		/* as IP addr */
#endif

/* For extracting the port from /etc/services */
#ifndef NLOG_SERVICE
# define NLOG_SERVICE		"noclog"
#endif

/* Port in case not available from /etc/services */
#ifndef NLOG_PORT
# define NLOG_PORT		5354
#endif

#endif  /* !__noclogd_h  */
