.SH NAME
snmpstatus - Fetch status of an SNMP agent
.SH SYNOPSIS
snmpstatus [ -d ] [ -V ] [ -p Port ] [ -r Retries ] [ -t Timeout ] [
-1 ] [ -2 ] host [ community ]
.SH "DESCRIPTION"
.I snmpstatus
is a small program that will fetch some basic information from a
network SNMP entity.
.PP
The
.I host
specification may be either a host name or an internet address
specified in "dot notation"
.PP
.I community
specifies the community name for the transaction with the remote system.
If this argument is not given, the community name will default to
.I "public".
.PP
Adding a "-d" to the argument list will cause the application to dump
input and output packets.
.PP
The "-V" flag returns the version of the app, and the version of the
SNMP library used.
.PP
The "-p" flag allows an alternate port to be used for SNMP
transactions.
.PP
The "-r" flag sets the number of retries.  The default is 4.
.PP
The "-t" flag sets the timeout in microseconds.  The default is
1000000.
.PP
The "-1" and "-2" flags set the SNMP version of the outgoing request.
.SS "SNMP Information Fetched"
The information fetched is:
.br
.nf
System Description        .1.3.6.1.2.1.1.1.0
System Uptime             .1.3.6.1.2.1.1.3.0
Interface information     .1.3.6.1.2.1.2.2.1.[8,11,12,17,18]
IP Packets received       .1.3.6.1.2.1.4.3.0
IP Packets sent           .1.3.6.1.2.1.4.10.0
.SH EXAMPLES
% snmpstatus snmp-example.net.cmu.edu
.PP
returns
.PP
[128.2.6.6]=>[Unix 4.3BSD] Up: 40 days, 1:02:35
.br
Recv/Trans packets: Interfaces: 13773753/6762074 | IP: 7282596/0
