.SH NAME
snmp_pdu_create, snmp_pdu_clone, snmp_pdu_fix, snmp_pdu_free,
snmp_pdu_encode, snmp_pdu_decode, snmp_pdu_type, snmp_add_null_var \-
SNMP PDU Operations
.SH SYNOPSIS
.B cc
.RI "[ " "flag" " \|.\|.\|. ] " "file" " \|.\|.\|."
.B \-lsnmp
.RI "[ " "library" " \|.\|.\|. ]"
.LP
.B #include <sys/types.h>
.br
.B #include <snmp/snmp.h>
.LP
.BI "struct snmp_pdu *snmp_pdu_new(int " "Command" );
.LP
.BI "struct snmp_pdu *snmp_pdu_clone(struct snmp_pdu * " "Src" );
.LP
.BI "struct snmp_pdu *snmp_pdu_fix(struct snmp_pdu * " "Src"
.BI "int" "command" );
.LP
.BI "void snmp_pdu_free(struct snmp_pdu * " "Ptr" );
.LP
.BI "u_char *snmp_pdu_encode(u_char * " "Buf" ,
.BI "int * " "BufLenP" ,
.BI "struct snmp_pdu * " "PDU" );
.LP
.BI "u_char *snmp_pdu_decode(u_char * " "Buf" ,
.BI "int * " "BufLenP" ,
.BI "struct snmp_pdu ** " "PDUP" );
.LP
.BI "void snmp_add_null_var(struct snmp_pdu * " "PDU" ,
.BI "oid * " "OID" ,
.BI "int " "OIDLen" );
.SH STRUCTURE
The 
.B snmp_pdu
structure is:
.RS
.nf
.ft 3
.ta 12n 22n
int	command;		/\(** Type of this PDU \(**/
ipaddr	address;		/\(** Address of peer \(**/

int	reqid;			/\(** Request id \(**/
int	errstat;		/\(** Error status \(**/
int	errindex;		/\(** Error index \(**/

struct variable_list *variables;	/\(** Variable Bindings \(**/

/\(** SNMPv2 Bulk Request information \(**/
int	non_repeaters;
int	max_repetitions;

/\(** SNMPv1 Trap Information \(**/
oid	*enterprise;		/\(** System OID \(**/
int	enterprise_length;	/\(** System OID Length \(**/
ipaddr	agent_addr;		/\(** address of object generating trap \(**/
int	trap_type;		/\(** generic trap type \(**/
int	specific_type;		/\(** specific type \(**/
u_int	time;			/\(** Uptime \(**/
.ft 1
.fi
.RE
.SH DESCRIPTION
.B snmp_pdu_new(\|)
creates a new
.I snmp_pdu
structure representing the SNMP command
.IR command .
.LP
.B snmp_pdu_clone(\|)
copies the 
.I snmp_pdu 
structure pointed to by
.IR Src .
If the 
.I variable_list
pointer is filled in, it is copied as well, so both the original and
the clone point to the same 
.IR variable_list .
.LP
.B snmp_pdu_free(\|)
frees the 
.I snmp_pdu
pointed to by
.I Ptr,
as well as all variables associated with it.  This function is
identical to
.BR snmp_free_pdu(\|) , which is included for backwards compatibility.
.LP
.B snmp_pdu_encode(\|)
and
.B snmp_pdu_decode(\|)
encode and decode the 
.I snmp_pdu
structure into/out of the buffer pointed to by
.IR Buf .
.I BufLenP
points to the length of space remaining in
.IR Buf .
Upon successful completion, these functions return a pointer to the
next available byte in
.I Buf
and adjusts
.I BufLenP
to reflect the amount of space left in the buffer after the encoding /
decoding.
.LP
.B snmp_pdu_fix(\|)
This functions fixes a
.IR PDU
by removing the variable binding that was incorrect, according to the
error index.  This function is identical to 
.BR snmp_fix_pdu(\|) , which is included for backwards compatibility.
.LP
.B snmp_pdu_type(\|)
This function returns a string describing the type of PDU pointed to
by
.IR PDU .
.LP
.B snmp_add_null_var(\|)
Adds a NULL variable with object identifier
.I OID
to the specified PDU.
.SH "RETURN VALUES"
Upon error, all functions (except
.B snmp_pdu_free(\|)
and
.BR snmp_add_null_var(\|) )
return
.BR NULL .
Otherwise, the return value is as describe above.
.SH ERRORS
If any of these return unsuccessfully, 
.B snmp_api_error(\|)
will be set.
.SH NOTES
ASN parsing errors are counted and available via
.BR snmpInASNParseErrs(3) .
