.SH NAME
snmp_oid \- Format of specifying variable names to SNMP tools.
.SH SYNOPSIS
system.sysdescr.0
.SH DESCRIPTION
Variable names are in the format of Object Identifiers (ASN.1).  There
are several methods of representation. Each variable name is given in
the format of A.B.C.D..., where A, B, C, and D are subidentifiers in
one of two forms of notation.  Each subidentifier may be encoded as a
decimal integer, or a symbol as found in the RFC1066 MIB.  The case of
the symbols is not significant.
.br
If there is no leading "." in the variable name, the name will be formed
as if having been preceded with "iso.org.dod.internet.mgmt.mib.".  A "." must
be placed before the first variable if the user is to fully specify the name.
For example:
.PP
.I 1.1.0  system.sysDescr.0 and 1.sysDescr.0
.PP
all refer to the same variable name.  Likewise:
.PP
.I .1.3.6.1.2.1.1.1.0 .iso.org.dod.internet.mgmt.mib.system.sysdescr.0 .1.3.6.1.2.1.1.sysdescr.0
.PP
All refer to the same variable name.
.PP
The description of the variables in the MIB is given in a file named
.I "mib.txt"
in the current directory or in a file named in the environment variable
.I "MIBFILE" or in
.I "/etc/mib.txt".
These files are searched in the above order.  The files are in the
ASN.1 notation and use the OBJECT TYPE macro defined in RFC 1065.
Most of the file describing the RFC 1066 MIB is pulled out of RFC 1066
without change.
.SH BUGS
The mibfile parser is not expected to handle bizarre (although
correct) interpretations of the ASN.1 notation.
