/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;

public class ConstructorLocator
extends PatternLocator {
    protected ConstructorPattern pattern;

    public ConstructorLocator(ConstructorPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(node instanceof ExplicitConstructorCall)) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = ((ExplicitConstructorCall)node).arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(ConstructorDeclaration node, MatchingNodeSet nodeSet) {
        int referencesLevel = this.pattern.findReferences ? this.matchLevelForReferences(node) : 0;
        int declarationsLevel = this.pattern.findDeclarations ? this.matchLevelForDeclarations(node) : 0;
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    public int match(Expression node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(node instanceof AllocationExpression)) {
            return 0;
        }
        AllocationExpression allocation = (AllocationExpression)node;
        char[][] typeName = allocation.type.getTypeName();
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, typeName[typeName.length - 1])) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = allocation.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 2;
    }

    protected int matchLevelForReferences(ConstructorDeclaration constructor) {
        ExplicitConstructorCall constructorCall = constructor.constructorCall;
        if (constructorCall == null || constructorCall.accessMode != 1) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = constructorCall.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return this.pattern.mustResolve ? 2 : 3;
    }

    protected int matchLevelForDeclarations(ConstructorDeclaration constructor) {
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, constructor.selector)) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = constructor.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < length) {
                if (!this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    return 0;
                }
                ++i;
            }
        }
        return this.pattern.mustResolve ? 2 : 3;
    }

    public int resolveLevel(ASTNode node) {
        if (this.pattern.findReferences) {
            if (node instanceof AllocationExpression) {
                return this.resolveLevel((AllocationExpression)node);
            }
            if (node instanceof ExplicitConstructorCall) {
                return this.resolveLevel(((ExplicitConstructorCall)node).binding);
            }
            if (node instanceof TypeDeclaration) {
                return this.resolveLevel((TypeDeclaration)node);
            }
        }
        if (node instanceof ConstructorDeclaration) {
            return this.resolveLevel((ConstructorDeclaration)node, true);
        }
        return 0;
    }

    protected int resolveLevel(AllocationExpression allocation) {
        char[][] typeName = allocation.type.getTypeName();
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, typeName[typeName.length - 1])) {
            return 0;
        }
        return this.resolveLevel(allocation.binding);
    }

    public int resolveLevel(Binding binding) {
        int parameterCount;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        if (!method.isConstructor()) {
            return 0;
        }
        int level = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, method.declaringClass);
        if (level == 0) {
            return 0;
        }
        int n = parameterCount = this.pattern.parameterSimpleNames == null ? -1 : this.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.parameters == null) {
                return 1;
            }
            if (parameterCount != method.parameters.length) {
                return 0;
            }
            int i = 0;
            while (i < parameterCount) {
                int newLevel = this.resolveLevelForType(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i], method.parameters[i]);
                if (level > newLevel) {
                    if (newLevel == 0) {
                        return 0;
                    }
                    level = newLevel;
                }
                ++i;
            }
        }
        return level;
    }

    protected int resolveLevel(ConstructorDeclaration constructor, boolean checkDeclarations) {
        ExplicitConstructorCall constructorCall;
        int referencesLevel = 0;
        if (this.pattern.findReferences && (constructorCall = constructor.constructorCall) != null && constructorCall.accessMode == 1 && (referencesLevel = this.resolveLevel(constructorCall.binding)) == 3) {
            return 3;
        }
        if (!checkDeclarations) {
            return referencesLevel;
        }
        int declarationsLevel = this.pattern.findDeclarations ? this.resolveLevel(constructor.binding) : 0;
        return referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel;
    }

    protected int resolveLevel(TypeDeclaration type) {
        AbstractMethodDeclaration[] methods = type.methods;
        if (methods != null) {
            int i = 0;
            int length = methods.length;
            while (i < length) {
                AbstractMethodDeclaration method = methods[i];
                if (method.isDefaultConstructor() && method.sourceStart < type.bodyStart) {
                    return this.resolveLevel((ConstructorDeclaration)method, false);
                }
                ++i;
            }
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

