.\"
.\" @(#)mstream-play.man,v 1.1 2004/04/25 00:15:38 kim Exp
.\"
.\"
.\" Copyright (c) 2004 Kimmo Suominen
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer
.\"    in the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.\"
.\" Stream player for mserv
.\" 20040424  Kimmo Suominen
.\"
.Dd April 24, 2004
.Dt MSTREAM-PLAY 1
.Os
.Sh NAME
.Nm mstream-play
.Nd queue a track for streaming
.Sh SYNOPSIS
.Nm
.Ar file
.Sh DESCRIPTION
.Nm
checks that the
.Ar file
is readable and then sends the pathname to
.Nm IceS
using the
.Nm mstream.pm
playlist module.
It will then sleep for the duration of the song (less a couple of
seconds) to simulate playing the file.
.Pp
A named pipe is used for the inter-process communication to synchronize
.Nm IceS
and
.Nm mserv .
.Pp
If
.Nm
is signaled to terminate (SIGTERM), it will send
.Nm IceS
SIGUSR1 causing it to skip to the next song immediately.
.Pp
In the
.Ar Playlist
section of
.Pa ices.conf
you should specify
.Ar Type
as
.Ic perl
and
.Ar Module
as
.Ic mstream .
.Sh FILES
.Bl -tag -width .ices.pid
.It Pa .ices.pid
The PID of the process that will be signaled if the script is terminated,
presumably due to a NEXT or STOP command.
.It Pa .icesgw
A named pipe for communicating with
.Nm mstream.pm .
.It Pa @MODDIR@/mstream.pm
The IceS playlist module that listens to requests from
.Nm .
.El
.Sh SEE ALSO
.Xr ices 1 ,
.Xr ices-mp3 1 ,
.Xr mserv 1
.Sh AUTHORS
Kimmo Suominen
