/**
 * Javascript to load and render the list of calendar events for a
 * given day range.
 *
 * @module     block_timeline/event_list
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_timeline/event_list",["jquery","core/notification","core/templates","core/str","core/user_date","block_timeline/calendar_events_repository","core/pending"],(function($,Notification,Templates,Str,UserDate,CalendarEventsRepository,Pending){var courseview=!1,SELECTORS_EMPTY_MESSAGE='[data-region="no-events-empty-message"]',SELECTORS_EVENT_LIST_CONTENT='[data-region="event-list-content"]',SELECTORS_EVENT_LIST_WRAPPER='[data-region="event-list-wrapper"]',SELECTORS_EVENT_LIST_LOADING_PLACEHOLDER='[data-region="event-list-loading-placeholder"]',SELECTORS_TIMELINE_BLOCK='[data-region="timeline"]',SELECTORS_TIMELINE_SEARCH='[data-action="search"]',SELECTORS_MORE_ACTIVITIES_BUTTON='[data-action="more-events"]',SELECTORS_MORE_ACTIVITIES_BUTTON_CONTAINER='[data-region="more-events-button-container"]',TEMPLATES_EVENT_LIST_CONTENT="block_timeline/event-list-content",TEMPLATES_MORE_ACTIVITIES_BUTTON="block_timeline/event-list-loadmore",TEMPLATES_LOADING_ICON="core/loading";var hideContent=function(root){root.find(SELECTORS_EVENT_LIST_CONTENT).addClass("hidden"),root.find(SELECTORS_EMPTY_MESSAGE).removeClass("hidden")},showContent=function(root){root.find(SELECTORS_EVENT_LIST_CONTENT).removeClass("hidden"),root.find(SELECTORS_EMPTY_MESSAGE).addClass("hidden")},emptyContent=function(root){root.find(SELECTORS_EVENT_LIST_CONTENT).empty()},render=function(calendarEvents){var templateContext=function(calendarEvents){var eventsByDay={},templateContext={courseview:courseview,eventsbyday:[]};return calendarEvents.forEach((function(calendarEvent){var dayTimestamp=calendarEvent.timeusermidnight;eventsByDay[dayTimestamp]?eventsByDay[dayTimestamp].push(calendarEvent):eventsByDay[dayTimestamp]=[calendarEvent]})),Object.keys(eventsByDay).forEach((function(dayTimestamp){var events=eventsByDay[dayTimestamp];templateContext.eventsbyday.push({dayTimestamp:dayTimestamp,events:events})})),templateContext}(calendarEvents),templateName=TEMPLATES_EVENT_LIST_CONTENT;return Templates.render(templateName,templateContext)};const createLazyLoadingContent=(root,firstLoad,itemLimit,midnight,lastId,courseId,daysOffset,daysLimit,searchValue)=>loadEventsForLazyLoading(root,itemLimit,midnight,lastId,courseId,daysOffset,daysLimit,searchValue).then((data=>{if(data.calendarEvents.length){const lastEventId=data.calendarEvents.at(-1).id,lastTimeStamp=data.calendarEvents.at(-1).timeusermidnight;return firstLoad.resolve({hasContent:!0,lastId:lastEventId,lastTimeStamp:lastTimeStamp,loadedAll:data.loadedAll}),render(data.calendarEvents)}return firstLoad.resolve({hasContent:!1,lastId:0,lastTimeStamp:0,loadedAll:!0}),data.calendarEvents})).catch(Notification.exception),loadEventsForLazyLoading=(root,itemLimit,midnight,lastId,courseId,daysOffset,daysLimit,searchValue)=>{const eventsPromise=function(midnight,limit,daysOffset,daysLimit,lastId,courseId,searchValue){var endTime=null!=daysLimit&&midnight+86400*daysLimit,args={starttime:midnight+86400*daysOffset,limit:limit};return lastId&&(args.aftereventid=lastId),endTime&&(args.endtime=endTime),searchValue&&(args.searchvalue=searchValue),courseId?(args.courseid=courseId,CalendarEventsRepository.queryByCourse(args)):CalendarEventsRepository.queryByTime(args)}(midnight,itemLimit+1,daysOffset,daysLimit,lastId,courseId,searchValue);let calendarEvents=[],loadedAll=!0;return eventsPromise.then((result=>{if(!result.events.length)return{calendarEvents:calendarEvents,loadedAll:loadedAll};const overdueFilter=document.querySelector("[data-filtername='overdue']"),filterByOverdue=overdueFilter&&overdueFilter.getAttribute("aria-current");if(calendarEvents=result.events.filter((event=>{if("open"==event.eventtype||"opensubmission"==event.eventtype){return UserDate.getUserMidnightForTimestamp(event.timesort,midnight)>midnight}return!filterByOverdue||event.overdue})),loadedAll=calendarEvents.length<=itemLimit,loadedAll||calendarEvents.pop(),calendarEvents.length){const lastEventId=calendarEvents.at(-1).id;setOffset(root,lastEventId)}return{calendarEvents:calendarEvents,loadedAll:loadedAll}}))},getOffset=element=>parseInt(element.attr("data-lazyload-offset"),10),setOffset=(element,offset)=>{element.attr("data-lazyload-offset",offset)},getLastTimestamp=element=>parseInt(element.attr("data-timestamp"),10),setLastTimestamp=(element,timestamp)=>{element.attr("data-timestamp",timestamp)},disableMoreActivitiesButtonLoading=root=>{root.find(SELECTORS_MORE_ACTIVITIES_BUTTON_CONTAINER).remove()},initEventListener=root=>{root.find(SELECTORS_MORE_ACTIVITIES_BUTTON).on("click",(()=>{(root=>{const loadMoreButton=root.find(SELECTORS_MORE_ACTIVITIES_BUTTON);loadMoreButton.prop("disabled",!0),Templates.render(TEMPLATES_LOADING_ICON,{}).then((html=>(loadMoreButton.append(html),html))).catch((()=>!1))})(root),(root=>{const midnight=parseInt(root.attr("data-midnight"),10),courseId=root.attr("data-course-id"),daysOffset=parseInt(root.attr("data-days-offset"),10),daysLimit=root.attr("data-days-limit"),lastId=getOffset(root),eventListWrapper=root.find(SELECTORS_EVENT_LIST_WRAPPER),searchValue=root.closest(SELECTORS_TIMELINE_BLOCK).find(SELECTORS_TIMELINE_SEARCH).val();loadEventsForLazyLoading(root,10,midnight,lastId,courseId,daysOffset,daysLimit,searchValue).then((data=>{if(data.calendarEvents.length){const renderPromise=render(data.calendarEvents),lastTimestamp=getLastTimestamp(root);renderPromise.then(((html,js)=>((html=$(html)).find('[data-timestamp="'.concat(lastTimestamp,'"]')).remove(),Templates.appendNodeContents(eventListWrapper,html.html(),js),data.loadedAll||Templates.render(TEMPLATES_MORE_ACTIVITIES_BUTTON,{}).then((html=>(eventListWrapper.append(html),setLastTimestamp(root,data.calendarEvents.at(-1).timeusermidnight),initEventListener(root),html))).catch((()=>!1)),html))).catch(Notification.exception)}return data})).then((()=>disableMoreActivitiesButtonLoading(root))).catch(Notification.exception)})(root)}))};return{init:function(root){let additionalConfig=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const pendingPromise=new Pending("block/timeline:event-init");root=$(root),courseview=!!additionalConfig.courseview;var firstLoad=$.Deferred(),eventListContent=root.find(SELECTORS_EVENT_LIST_CONTENT),loadingPlaceholder=root.find(SELECTORS_EVENT_LIST_LOADING_PLACEHOLDER),courseId=root.attr("data-course-id"),daysOffset=parseInt(root.attr("data-days-offset"),10),daysLimit=root.attr("data-days-limit"),midnight=parseInt(root.attr("data-midnight"),10);const searchValue=root.closest(SELECTORS_TIMELINE_BLOCK).find(SELECTORS_TIMELINE_SEARCH).val();return emptyContent(root),showContent(root),loadingPlaceholder.removeClass("hidden"),null!=daysLimit&&(daysLimit=parseInt(daysLimit,10)),createLazyLoadingContent(root,firstLoad,5,midnight,0,courseId,daysOffset,daysLimit,searchValue).then((function(html,js){return firstLoad.then((function(data){return data.hasContent?((html=$(html)).addClass("hidden"),Templates.replaceNodeContents(eventListContent,html,js),html.removeClass("hidden"),loadingPlaceholder.addClass("hidden"),data.loadedAll||Templates.render(TEMPLATES_MORE_ACTIVITIES_BUTTON,{courseview:courseview}).then((function(html){return eventListContent.append(html),setLastTimestamp(root,data.lastTimeStamp),initEventListener(root),html})).catch((function(){return!1})),data):(loadingPlaceholder.addClass("hidden"),hideContent(root))})).catch((function(){return!1})),html})).then((()=>pendingPromise.resolve())).catch(Notification.exception)},rootSelector:'[data-region="event-list-container"]'}}));

//# sourceMappingURL=event_list.min.js.map