/*
 * NINE -- the alternative keyboard function using mouse or touchpad
 *    (keycode is determined by the order passing unvisible NINE buttons)
 *
 * Copyright (C) 2000, 2001
 *	Kazuma Arino (kazuma@sola.c.u-tokyo.ac.jp)
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KAZUMA ARINO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/* Version 12171230 */

#include "mgl2.h"
#include "mglcol.h"
#include "mtostr.h"

#define MK_MOUSE_DOWN		MK_V1
#define MK_MOUSE_MOVE		MK_V2
#define MK_MOUSE_UP		MK_V3
#define MK_DUMP_SCREEN		'\r'

#ifndef NULL
#define NULL	(void *)0
#endif

#define ABS(a) (((a)<0) ? -(a) : (a))

#undef MABIKI

/* ߤ */
void draw_circle(int x1, int y1, int x2, int y2);

draw_area() {
	int l[10];
	int i;
	int x,y,xs,ys;
	int cx,cy;
	int rx,ry;
	mtostr_button_type(l);

	for (i=1; i<=9 ; i++) {
		mtostr_area(i,&cx,&cy,&rx,&ry);
		switch(l[i]) {
		case BUTTON_ALL:
	   		draw_rect((cx-rx*2),(cy-ry*2)
				,(rx*4+1),(ry*4+1));
			break;
		case BUTTON_LARGE:
	   		draw_circle((cx-rx*2),(cy-ry*2)
				,(cx+rx*2),(cy+ry*2));
			break;
		case BUTTON_MEDIUM:
	   		draw_circle((cx-rx*3/2),(cy-ry*3/2)
				,(cx+rx*3/2),(cy+ry*3/2));
			break;
		case BUTTON_SMALL:
	   		draw_circle((cx-rx),(cy-ry)
				,(cx+rx),(cy+ry));
			break;
		}
	}
}

int draw_lines(int *buf,int cnt) {
	int oldx,oldy;
	int x,y;

	oldx = *buf++;
	oldy = *buf++;
	cnt -= 2;
	fill_rect(oldx-2,oldy-2,5,5);
	while (cnt > 0) {
		x = *buf++;
		y = *buf++;
		cnt -= 2;
		if (x > SCREEN_WIDTH || x < 0 || y < 0 || y > SCREEN_HEIGHT) 
			continue;
		draw_pixel(x,y);
	}
}

extern char *match_gesture(char *p);

main() {
	struct virtual_key *vk;
	int c,oldx,oldy;
	int fs = 0;
	int count=0;
	int color;
	int seq = 1;
	char fname[64];
	int buf[1024];
	int buf_cnt;
	int draw_direct = 1;
	char *p;
	long long s,e;
	char msgbuf[64];

	SCREEN_WIDTH= 480;
	SCREEN_HEIGHT= 320;
	open_graph();

	fs = 12;

	vk = create_virtual_key3(0,0,SCREEN_WIDTH,SCREEN_HEIGHT,
				MK_MOUSE_DOWN,MK_MOUSE_MOVE,MK_MOUSE_UP);
	vk_attach(NULL, vk);

	color = COLOR_BLACK;
	set_color(color);
        draw_string(20, 2 , "ΣĢ" ,DIR_NORTH);

	while (c = get_key(-1)) {
		if (c == 033) break;
		switch (c) {
		case MK_MOUSE_DOWN:
			s = mgl_millitime();
			switch (mgl_button_shift) {
			case 0: color = COLOR_BLACK;	break;
			case 1: color = COLOR_BLUE;	break;
			case 2: color = COLOR_RED;	break;
			}
			set_color(color);
			if (draw_direct) {
				draw_rect(vk_x-1,vk_y-1,3,3);
			}
			mtostr_init(vk_x,vk_y);
			oldx = vk_x;
			oldy = vk_y;
			break;
		case MK_MOUSE_MOVE:
#ifdef MABIKI
			count++;
			if (count < 5) break;
			count = 0;
#endif
			if (draw_direct) {
				draw_rect(vk_x-1,vk_y-1,3,3);
				draw_line(oldx,oldy,vk_x,vk_y);
			}
			mtostr_record(vk_x,vk_y);
			oldx = vk_x;
			oldy = vk_y;
			break;
		case MK_MOUSE_UP:
			e = mgl_millitime();
			mtostr_finish();
			if (draw_direct) {
				draw_rect(vk_x-1,vk_y-1,3,3);
			} else {
				buf_cnt = mtostr_buf(buf,1024);
				draw_lines(buf,buf_cnt);
			}
			set_color(COLOR_RED);
			draw_area();
			mtostr_translate();
			set_color(COLOR_WHITE);
        		fill_rect(20, 2+12 , 200,12*2);
			set_color(COLOR_BLACK);
refresh();

			strcpy(msgbuf,result_buf);
			p = match_gesture(result_buf);
			if (p) {
				strcat(msgbuf," -> ");
				strcat(msgbuf,p);
			}
        		draw_string(20, 2+12 ,msgbuf,DIR_NORTH);
			printf("result = %s (%4.2f)\n",msgbuf
					,(float)(e-s)/1000.0);
			sprintf(msgbuf,"%4.2f sec \n"
				,(float)(e-s)/1000.0);
        		draw_string(20, 2+12*2 ,msgbuf,DIR_NORTH);
			set_color(color);
			break;
			break;
		case ' ':
		case MK_UP:
			draw_direct = 0;
			set_color(COLOR_WHITE);
			clear_screen();
			set_color(color);
        		draw_string(20, 2 , "ΣĢ" ,DIR_NORTH);
			break;
		case MK_DOWN:
		{
			int x,y,ch,i,j,s,f;

			draw_direct = 1;
			s =  (c == MK_UP)?20:30;
			f =  (c == MK_UP)?12:16;

			set_color(COLOR_WHITE);
			clear_screen();
			set_color(COLOR_LIGHTGRAY);
			for (i=0,x=s/4; x < SCREEN_WIDTH; x+=s,i++) {
				for (j=0,y=s/4; y < SCREEN_HEIGHT; y+=s,j++) {
				   ch = (i%3)+(j%3)*3 + '1';
				   set_font(f,0); 
				   draw_font(x,y,ch,0);
				}
			}
			set_color(color);
        		draw_string(20, 2 , "ΣĢ" ,DIR_NORTH);
		}
			break;
		case MK_DUMP_SCREEN:
			sprintf(fname,"dump%03d",seq);
			write_screen_xpm(fname,current_screen);
			//write_screen_mgr(fname,current_screen,STK_GENERIC_192COLOR);
			seq++;
		}
	}
}

/* 
PFUκ椵(hsakai@pfu.co.jp)ꡣcircle ؿĺޤ

եåؿƤΤ礭ʤäƤΤǡ
ΤΤαƤޤɬפϻȤäƤߤƤ

------- 

sin, cos η׻ˤϡȼΥ롼ѤƤΤǡط׻Ѥ
饤֥󥯤ʤƤȤޤ(Ĥޤꡤѥ -lm ɬ̵)
Ȥϡ
draw_circle(100, 100, 300, 300);
ǡ(200, 200) 濴ȤơȾ100αߤޤ

ʲɲʬǤ


 ʲ mgl.h ؤɲâ

*/

/* sin, cos ΥޥŸˤʰ׷׻
 * ٤㤤
 * ٤ degree ǻ
 */
double easy_sin(int degree);
double easy_cos(int degree);

/*

 ʲ mgl.c ؤɲâ

*/

/* sin, cos ΥޥŸˤʰ׷׻
 * ٤㤤
 * ٤ degree ǻ
 */
double easy_sin(int degree)
{
  double rad, value, r2, r3, r5, r7;
  int d;

  while (degree < 0) degree += 360;
  degree = degree % 360;

  if (degree ==   0 || degree == 180) return ( 0.0);
  if (degree ==  30 || degree == 150) return ( 0.5);
  if (degree ==  90                 ) return ( 1.0);
  if (degree == 210 || degree == 330) return (-0.5);
  if (degree == 270                 ) return (-1.0);

  /* 090 ϰϤˤ */
  d = degree % 180;
  if (d >= 90) d = 180 - d;

  rad = (double)d * (3.1415926536 / 180.0);
  r2 = rad * rad;
  r3 = rad * r2;
  r5 = r2 * r3;
  r7 = r2 * r5;
  value = rad
    - r3 * (1.0 / (3*2))
    + r5 * (1.0 / (5*4*3*2))
    - r7 * (1.0 / (7*6*5*4*3*2));

  /* ʰ׷׻ʤΤǡ0.01.0 ۤ뤫? */
  if (value <   0) value = 0.0;
  if (value > 1.0) value = 1.0;

  if (degree >= 180) value = -value;

  return (value);
}

double easy_cos(int degree)
{
  return (easy_sin(degree + 90));
}

/* ߤ */
void draw_circle(int x1, int y1, int x2, int y2)
{
  int i, tmp, d;
  int cx, cy, rx, ry;
  double c, s, oc = 0.0, os = 0.0;

  if (x1 > x2) { tmp = x1; x1 = x2; x2 = tmp; }
  if (y1 > y2) { tmp = y1; y1 = y2; y2 = tmp; }

  cx = (x1 + x2) + 1;
  cy = (y1 + y2) + 1;
  rx = (x2 - x1);
  ry = (y2 - y1);

  if      (rx + ry <  20) d = 45;
  else if (rx + ry < 100) d = 15;
  else if (rx + ry < 200) d =  9;
  else                    d =  5;

  for (i = 0; i <= 45; i += d) {
    c = easy_cos(i);
    s = easy_sin(i);
    if (i) {
      draw_line((cx+oc*rx)*0.5,(cy+os*ry)*0.5,(cx+c*rx)*0.5,(cy+s*ry)*0.5);
      draw_line((cx+oc*rx)*0.5,(cy-os*ry)*0.5,(cx+c*rx)*0.5,(cy-s*ry)*0.5);
      draw_line((cx-oc*rx)*0.5,(cy+os*ry)*0.5,(cx-c*rx)*0.5,(cy+s*ry)*0.5);
      draw_line((cx-oc*rx)*0.5,(cy-os*ry)*0.5,(cx-c*rx)*0.5,(cy-s*ry)*0.5);
      draw_line((cx+os*rx)*0.5,(cy+oc*ry)*0.5,(cx+s*rx)*0.5,(cy+c*ry)*0.5);
      draw_line((cx+os*rx)*0.5,(cy-oc*ry)*0.5,(cx+s*rx)*0.5,(cy-c*ry)*0.5);
      draw_line((cx-os*rx)*0.5,(cy+oc*ry)*0.5,(cx-s*rx)*0.5,(cy+c*ry)*0.5);
      draw_line((cx-os*rx)*0.5,(cy-oc*ry)*0.5,(cx-s*rx)*0.5,(cy-c*ry)*0.5);
    }
    oc = c;
    os = s;
  }
}


static int plot_line(int *buf,int max_cnt,int x1, int y1, int x2, int y2) {
    int dx = x2 - x1;
    int dy = y2 - y1;
    int ax = ABS(dx) << 1;
    int ay = ABS(dy) << 1;
    int sx = (dx >= 0) ? 1 : -1;
    int sy = (dy >= 0) ? 1 : -1;

    int x = x1;
    int y = y1;
    int ret = 0;

    if (ax > ay) {
	int d = ay - (ax >> 1);
	while (x != x2) {
	    if ((max_cnt > 2) && ((x1 != x) || (y1 != y))) {
//printf("plot %d %d \n",x,y);
	        *buf++ = x;
	        *buf++ = y;
		max_cnt -= 2;
		ret += 2;
	    }

	    if (d > 0 || (d == 0 && sx == 1)) {
		y += sy;
		d -= ax;
	    }
	    x += sx;
	    d += ay;
	}
    } else {
	int d = ax - (ay >> 1);
	while (y != y2) {
	    if ((max_cnt > 2) && ((x1 != x) || (y1 != y))) {
//printf("plot %d %d \n",x,y);
	        *buf++ = x;
	        *buf++ = y;
		max_cnt -= 2;
		ret += 2;
	    }

	    if (d > 0 || (d == 0 && sy == 1)) {
		x += sx;
		d -= ay;
	    }
	    y += sy;
	    d += ax;
	}
    }
   if ((max_cnt > 2) && ((x1 != x) || (y1 != y))) {
//printf("plot %d %d \n",x,y);
        *buf++ = x;
        *buf++ = y;
	max_cnt -= 2;
	ret += 2;
  }
    return ret;
}
