/*
 * NINE -- the alternative keyboard function using mouse or touchpad
 *    (keycode is determined by the order passing unvisible NINE buttons)
 *
 * Copyright (C) 2000, 2001
 *	Kazuma Arino (kazuma@sola.c.u-tokyo.ac.jp)
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KAZUMA ARINO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


#include <sys/types.h>
#include <regex.h>
#include "gesture.h"

#ifndef NULL
#define NULL	(void *)0
#endif

struct gdef {
	char *name;
	char *gesture;
	regex_t reg;
} gdef[] = {
{ "A" , KEYCODE_A ,},
{ "B" , KEYCODE_B ,},
{ "C" , KEYCODE_C ,},
{ "D" , KEYCODE_D ,},
{ "E" , KEYCODE_E ,},
{ "F" , KEYCODE_F ,},
{ "G" , KEYCODE_G ,},
{ "H" , KEYCODE_H ,},
{ "I" , KEYCODE_I ,},
{ "J" , KEYCODE_J ,},
{ "K" , KEYCODE_K ,},
{ "L" , KEYCODE_L ,},
{ "M" , KEYCODE_M ,},
{ "N" , KEYCODE_N ,},
{ "O" , KEYCODE_O ,},
{ "P" , KEYCODE_P ,},
{ "Q" , KEYCODE_Q ,},
{ "R" , KEYCODE_R ,},
{ "S" , KEYCODE_S ,},
{ "T" , KEYCODE_T ,},
{ "U" , KEYCODE_U ,},
{ "V" , KEYCODE_V ,},
{ "W" , KEYCODE_W ,},
{ "X" , KEYCODE_X ,},
{ "Y" , KEYCODE_Y ,},
{ "Z" , KEYCODE_Z ,},
{ "RET" , KEYCODE_RET ,},
{ "ALT" , KEYCODE_ALT ,},
{ "CTRL" , KEYCODE_CTRL ,},
{ "RIGHT" , KEYCODE_RIGHT ,},
{ "LEFT" , KEYCODE_LEFT ,},
{ "UP" , KEYCODE_UP ,},
{ "DOWN" , KEYCODE_DOWN ,},
{ "TAB" , KEYCODE_TAB ,},
{ "SPACE" , KEYCODE_SPACE ,},
{ "PARENRIGHT" , KEYCODE_PARENRIGHT ,},
{ "BRACKETLEFT" , KEYCODE_BRACKETLEFT ,},
{ "BRACKETRIGHT" , KEYCODE_BRACKETRIGHT ,},
{ "SEMICOLON" , KEYCODE_SEMICOLON ,},
{ "PERIOD" , KEYCODE_PERIOD ,},
{ "GREATER" , KEYCODE_GREATER ,},
{ "ASCIITILDE" , KEYCODE_ASCIITILDE ,},
{ "GRAVE" , KEYCODE_GRAVE ,},
{ "SLASH" , KEYCODE_SLASH ,},
{ "NUMLOCK" , KEYCODE_NUMLOCK ,},
{ "SHIFT" , KEYCODE_SHIFT ,},
{ "BACKSPACE" , KEYCODE_BACKSPACE ,},
};

static int initialized;

static reg_strcpy(char *d,char *s) {
	*d++ = '^';
	while (*s) {
#if 0
		if (*s == '(' && s[1] == '|') {
			*d++ = *s;
			*d++ = '(';
			*d++ = ')';
		} else if (*s == '|' && s[1] == ')') {
			*d++ = *s;
			*d++ = '(';
			*d++ = ')';
		} else {
			*d++ = *s;
		}
		s++;
#else
		*d++ = *s++;
#endif
	}
	*d++ = '$';
	*d = 0;
}

static match_gesture_init() {
	int i,r;
	char buf[512];
	
	for (i=0; i< sizeof(gdef)/sizeof(gdef[0]); i++) {
		reg_strcpy(buf,gdef[i].gesture);
		r = regcomp(&gdef[i].reg, buf, REG_EXTENDED);
		if (r) {
			regerror(r, &gdef[i].reg, buf, 128);
			printf("%s\n",buf);
		}
	}
}

char *match_gesture(char *g) {
	int i,r;
	char buf[128];
	int match_cnt = 0;
	int matches[sizeof(gdef)/sizeof(gdef[0])];

	if (!initialized) {
		match_gesture_init();
		initialized = 1;
	}

	for (i=0; i< sizeof(gdef)/sizeof(gdef[0]); i++) {
		r = regexec(&gdef[i].reg, g, 0 , NULL, 0);
#ifdef FAST
		if (r == 0) return gdef[i].name;
#else
		if (r == 0) {
			matches[match_cnt++] = i;
		}
#endif
	}
#ifndef FAST
	if (match_cnt == 1) return gdef[matches[0]].name;
	if (match_cnt > 1)  {
		printf("warning multiple match %s\n",g);
		for (i=0; i<match_cnt; i++) {
		printf("      %s\n",gdef[matches[i]].name);
		}
	}
#endif
	return NULL;
}

#if 0
main() {
	int r;
	char *p;
	match_gesture_init();

printf("end init\n");
	p = match_gesture("258");
	if (p) {
		printf("match %s -> %s\n","258",p);
	}
	p = match_gesture("32147");
	if (p) {
		printf("match %s -> %s\n","32147",p);
	}
}
#endif
