#ifndef _KEY_CODE_H
#define _KEY_CODE_H

#define KEYCODE_A  (128+0)
#define KEYCODE_B  (128+1)
#define KEYCODE_C  (128+2)
#define KEYCODE_D  (128+3)
#define KEYCODE_E  (128+4)
#define KEYCODE_F  (128+5)
#define KEYCODE_G  (128+6)
#define KEYCODE_H  (128+7)
#define KEYCODE_I  (128+8)
#define KEYCODE_J  (128+9)
#define KEYCODE_K  (128+10)
#define KEYCODE_L  (128+11)
#define KEYCODE_M  (128+12)
#define KEYCODE_N  (128+13)
#define KEYCODE_O  (128+14)
#define KEYCODE_P  (128+15)
#define KEYCODE_Q  (128+16)
#define KEYCODE_R  (128+17)
#define KEYCODE_S  (128+18)
#define KEYCODE_T  (128+19)
#define KEYCODE_U  (128+20)
#define KEYCODE_V  (128+21)
#define KEYCODE_W  (128+22)
#define KEYCODE_X  (128+23)
#define KEYCODE_Y  (128+24)
#define KEYCODE_Z  (128+25)

#define KEYCODE_SHIFT (128+26)
#define KEYCODE_ALT (128+27)
#define KEYCODE_CAPS (128+28)
#define KEYCODE_CTRL (128+29)
#define KEYCODE_RIGHT (128+30)
#define KEYCODE_LEFT (128+31)
#define KEYCODE_UP (128+32)
#define KEYCODE_DOWN (128+33)
#define KEYCODE_BACKSPACE (128+34)
#define KEYCODE_RET (128+35)
#define KEYCODE_TAB (128+36)
#define KEYCODE_ESC (128+37)
#define KEYCODE_SPACE (128+38)
#define KEYCODE_NUMLOCK (128+39)



/* not supported */
#define KEYCODE_BACKSLASH (128+50)
#define KEYCODE_BRACKETLEFT (128+51) /* [ */
#define KEYCODE_BRACKETRIGHT (128+41) /* ] */
#define KEYCODE_SEMICOLON (128+42) /* ; */
#define KEYCODE_PERIOD (128+44) /* . */
#define KEYCODE_SLASH (128+45) /* / */
#define KEYCODE_GRAVE (128+46) /* ` */
#define KEYCODE_PARENRIGHT (128+47) /* ) */
#define KEYCODE_ASCIITILDE (128+48) /* ~ */
#define KEYCODE_GREATER (128+49)




#define KEYCODE_OFFSET 60
#define KEYCODE_0  (KEYCODE_O+KEYCODE_OFFSET)
#define KEYCODE_1  (KEYCODE_I + KEYCODE_OFFSET)
#define KEYCODE_2  (KEYCODE_Z + KEYCODE_OFFSET)
#define KEYCODE_3  (KEYCODE_B + KEYCODE_OFFSET)
#define KEYCODE_4  (KEYCODE_L + KEYCODE_OFFSET)
#define KEYCODE_5  (KEYCODE_S + KEYCODE_OFFSET)
#define KEYCODE_6  (KEYCODE_G + KEYCODE_OFFSET)
#define KEYCODE_7  (KEYCODE_F + KEYCODE_OFFSET)
#define KEYCODE_8  (KEYCODE_Y + KEYCODE_OFFSET)
#define KEYCODE_9  (256) /* tekito- */

#define RETURNCODE_9 (256-KEYCODE_OFFSET)

#endif
