#!/bin/sh
#
# NINE -- the alternative keyboard function using mouse or touchpad
#    (keycode is determined by the order passing unvisible NINE buttons)
#
# Copyright (C) 2000, 2001
#	Kazuma Arino (kazuma@sola.c.u-tokyo.ac.jp)
#      Koji Suzuki (suz@at.sakura.ne.jp)
#      
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY KAZUMA ARINO ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

cat << EOB
%{
#define YY_END_OF_BUFFER_CHAR 0
/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

#include "keycode.h"
#include "nine.h"
#define YY_INPUT(buf,result,max_size) \\
   { \\
     int cnt; \\
     cnt = nine_get_sequence(buf); \\
     fprintf(stderr,"buf=%s,max_size=%d\n",buf,max_size); \\
     result = (cnt == 0) ? YY_NULL : cnt; \\
  } 

int yywrap(void) {
	return 0;
}
%}
%%
EOB

cat pattern.txt

echo '.      {fprintf(stderr,"error,%s\n",yytext); YY_FLUSH_BUFFER ;return NULL ;}'

echo "%%"
