/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <stdio.h>
#include "config.h"
#include "mgl2.h"
#include "mglcol.h"
#include "event_man.h"
#include <stdlib.h>
#include <string.h>

#ifdef USE_LOCAL_MEMSET
#define memset	mgl_memset
#endif
#ifdef USE_LOCAL_MEMMOVE
#define memmove	mgl_memmove
#endif


#ifndef NULL
#define NULL (void *)0
#endif

/* 
 tb_alloc(),tb_free(p)   /

 tb_cut()                  ڡڤФ롣
 tb_insert(p,space)        space = 1 : ڡ᤹
                           space = 0 : ɽꥹȤ

*/
struct tb_cell {
	int x,y,xs,ys;
	struct screen *s;
	int focus;
	int key;
	struct tb_cell *prev;
	struct tb_cell *link;
} *tb_top,*tb_freelist,*tb_space;

tb_free(struct tb_cell *p) {
	p->link = tb_freelist;
	tb_freelist = p;
}

struct tb_cell *tb_alloc() {
	struct tb_cell *new;
	if (tb_freelist) {
		new = tb_freelist;
		tb_freelist = tb_freelist->link;
	} else {
		new = (struct tb_cell *)malloc(sizeof(*new));
	}
	memset(new,0,sizeof(*new));
	return new;
}

tb_insert(struct tb_cell *new,int space) {
	struct tb_cell *p,*q;
	struct tb_cell **top;

	new->link = NULL;
	if (space) {
		top = &tb_space;
	} else {
		top = &tb_top;
	}

	if (!(*top)) {
		(*top) = new;
		return;
	}
	p = (*top);
	q = NULL;
	while (p) {
		if ((p->y == new->y) &&(p->x > new->x)) {
			break;
		}
		if (p->y > new->y) {
			break;
		}
		q = p;
		p = p->link;
	}
	if (space) { /* concat */
	     if (!q) {
		new->link = (*top);
		(*top) = new;
	     } else if ((q->y == new->y) && (q->x + q->xs == new->x)) {
		    q->xs += new->xs;
		    tb_free(new);
		    new = q;
	    } else {
		    q->link = new;
	    }
	    if (!p) return;
	    if ((new->y == p->y) && (new->x + new->xs == p->x)) {
		new->xs += p->xs;
		new->link = p->link; /* cut p */
		tb_free(p);
	    }
	    return;
	}
	if (!q) {
		new->link = (*top);
		(*top) = new;
	} else {
		new->link = q->link;
		q->link = new;
	}
}

struct tb_cell *tb_cut(int xs) {
	struct tb_cell *new,*p,*q;

	if (!tb_space) {
		return NULL;
	}
	q = NULL;
	p = tb_space;
	while (p) {
		if (p->xs > xs) {
			new = tb_alloc();
			new->x = p->x;
			new->y = p->y;
			new->ys = p->ys;
			new->xs = xs;
			p->xs -= xs;
			p->x += xs;
			return new;
		} else if (p->xs == xs) {
		    if (q) {
			q->link = p->link; /* cut p */
			p->link = NULL;
			p->s = NULL;
			p->key = 0;
			p->focus = 0;
			return p;
		    } else {
			tb_space = p->link;
			p->link = NULL;
			p->s = NULL;
			p->key = 0;
			p->focus = 0;
			return p;
		    }
		}
		q = p;
		p = p->link;
	}
	return NULL;
}

struct tb_cell *tb_cut_bottom(int xs) {
	struct tb_cell *new,*p,*q;

	if (!tb_space) {
		return NULL;
	}
	q = NULL;
	p = tb_space;

	/* create reverse list */
	while (p) {
		p->prev = q;
		q = p;
		p = p->link;
	}
	p = q; /* last of queue */
	while (p) {
		if (p->xs > xs) {
			new = tb_alloc();
			new->x = p->x + p->xs -xs;
			new->y = p->y;
			new->ys = p->ys;
			new->xs = xs;
			p->xs -= xs;
			return new;
		} else if (p->xs == xs) {
		    if (p->prev) {
			p->prev->link = p->link; /* cut p */
			p->link = NULL;
			p->s = NULL;
			return p;
		    } else {
			tb_space = p->link;
			p->link = NULL;
			return p;
		    }
		}
		q = p;
		p = p->prev;
	}
	return NULL;
}

tb_detach(struct screen *s) {
	struct tb_cell *p,*q;

	if (!s) return;
	q = NULL;	
	p = tb_top;
	while (p) {
		if (p->s == s) break;
		q = p;
		p = p->link;
	}
	if (!p) return;

	/* remove from top */
	p->s = NULL;
	if (q) {
		q->link = p->link; /* cut p */
	} else {
		tb_top = p->link;
	}
	tb_insert(p,1); /* move to sapce */
}

tb_change(struct screen *new,struct screen *old) {
	struct tb_cell *p;

	if (!old || !new) return;

	p = tb_top;
	while (p) {
		if (p->s == old) break;
		p = p->link;
	}
	if (!p) return;
	p->s = new;
}

tb_set_focus(struct screen *s,int mode) {
	struct tb_cell *p;

	if (!s) return;
	p = tb_top;
	while (p) {
		if (p->s == s) {
			p->focus = mode;
		} else {
			p->focus = 0;
		}
		p = p->link;
	}
}

tb_mouse(int x,int y) {
	struct tb_cell *p;

//printf("tb_mouse %d %d\n",x,y);
	p = tb_top;
	while (p) {
		if ((p->x <= x) && (x < p->x + p->xs)
		    && (p->y <= y) && (y < p->y + p->ys) ) {
//printf("put_key %x\n",p->key);
			if (p->key > 0)
				put_key(p->key);
			break;
		}
		p = p->link;
	}
}

tb_attach(struct screen *s,int key,int where) {
	struct tb_cell *p;

	if (!s) return;
	p = tb_top;
	while (p) {
		if (p->s == s) {
			return;
		}
		p = p->link;
	}
	if (!where) p = tb_cut(s->width);
	else p = tb_cut_bottom(s->width);

	if (!p) return;
	p->s = s;
	p->key = key;
	tb_insert(p,0); /* to for ground  */
}

tb_show() {
	struct tb_cell *p;

//printf("tb_show\n");
	p = tb_space;
	while (p) {
//printf("  -- space %d %d %d %d\n",p->x,p->y,p->xs,p->ys);
		set_color(COLOR_LIGHTGRAY);
		fill_rect(p->x,p->y,p->xs,p->ys);
#if 0
		set_color(COLOR_DARKGRAY);
		draw_line(p->x+1,p->y+1,p->x+1,p->y+p->ys-1);
		draw_line(p->x+p->xs-1,p->y+1,p->x+p->xs-1,p->y+p->ys-1);
#else
		set_color(packMC(MCH_GREEN,5,5));
		draw_rect(p->x+1,p->y+1,3,14);
		draw_rect(p->x+p->xs-4,p->y+1,3,14);
#endif
		p = p->link;
	}
	p = tb_top;
	while (p) {
//printf("  -- %s icon %d %d %d %d\n",p->focus?"[]":"  ",p->x,p->y,p->xs,p->ys);
		bitblt(NULL,p->x,p->y,p->s,0,0,p->xs,p->ys,0);
		if (p->focus) {
			set_color(packMC(0,15,15));
			draw_rect(p->x   ,p->y +1, 15,15);
			set_color(COLOR_BLACK);
			draw_rect(p->x+1 ,p->y +2, 13,13);
		}
		p = p->link;
	}
	refresh();
}

tb_init(int x,int y,int xs,int ys) {
	int i;
	struct tb_cell *p;
	for (i=0; i+16 <= ys; i += 16) {
		p = tb_alloc();
		p->x = x;
		p->xs = xs;
		p->y = y + i;
		p->ys = 16;
		tb_insert(p,1);
	}
}
