/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *      
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#define packMC(hue,sat,bri) ((hue << 8) | (sat << 4) | bri)

#define packRGB(r,g,b) ((r << 8) | (g << 4) | b)

#define unpackMC(c,hue,sat,bri) {\
	hue = ( c >> 8 ) & 0xf;\
	sat = ( c >> 4 ) & 0xf;\
	bri = c & 0xf;\
}

#define unpackRGB(c,r,g,b) {\
	r = ( c >> 8 ) & 0xf;\
	g = ( c >> 4 ) & 0xf;\
	b = c & 0xf;\
}

#define SCALE	100

int mc_to_rgb(int c) {
	int r,g,b;
	int hue=0,sat=0,bri=0;

	unpackMC(c,hue,sat,bri);

	r = g = b = -1;
    	if (sat == 0) {
		r = g = b = bri;
	} else {
	   if (sat > bri) sat = bri;
	   bri = bri * SCALE + (SCALE/2);
	   sat = sat * SCALE + (SCALE/2);
	   switch (hue) {
	   case 0: /* Red */
		r = bri;
		g = bri - sat;
		b = bri - sat;
		break;
	   case 1:
		r = bri;
		g = bri - sat/2;
		b = bri - sat;
		break;
	   case 2:
		r = bri;
		g = bri;
		b = bri - sat;
		break;
	   case 3:
		r = bri - sat/2;
		g = bri;
		b = bri - sat;
		break;
	   case 4: /* Green */
		r = bri - sat;
		g = bri;
		b = bri - sat;
		break;
	   case 5:
		r = bri - sat;
		g = bri;
		b = bri - sat/2;
		break;
	   case 6:
		r = bri - sat;
		g = bri;
		b = bri;
		break;
	   case 7:
		r = bri - sat;
		g = bri - sat/2;
		b = bri;
		break;
	   case 8: /* blue */
		r = bri - sat;
		g = bri - sat;
		b = bri;
		break;
	   case 9:
		r = bri - sat/2;
		g = bri - sat;
		b = bri;
		break;
	   case 10:
		r = bri;
		g = bri - sat;
		b = bri;
		break;
	   case 11:
		r = bri;
		g = bri - sat;
		b = bri - sat/2;
		break;
	   default:
		r = g = b = 0;
	   }
	   r /= SCALE;
	   g /= SCALE;
	   b /= SCALE;
	}
	return   packRGB(r,g,b);
}

int mc_from_rgb(int c) {
	int r,g,b;
	int hue,sat,bri;
	int cmin,cmax;
	int d;

	unpackRGB(c,r,g,b);

	r = r * SCALE + (SCALE/2);
	g = g * SCALE + (SCALE/2);
	b = b * SCALE + (SCALE/2);

    	cmax = (r > g) ? r : g;
	if (b > cmax) cmax = b;
	cmin = (r < g) ? r : g;
	if (b < cmin) cmin = b;
	d = cmax - cmin;

	bri = cmax / (SCALE);
	if (bri != 0) {
	    sat = d / SCALE;
	}
	else
	    sat = 0;
	if (sat == 0)
	    hue = 0;
	else {
	    int redc,greenc,bluec;
	    redc = (cmax - r ) * (0xf * SCALE) / d;
	    greenc = (cmax - g) * (0xf * SCALE) / d;
	    bluec = (cmax - b) * (0xf * SCALE) / d;

	    if (r == cmax) {
		hue = bluec - greenc;
		if (hue < 0) hue += 3*SCALE;
//printf("    hue = %3d redc %3d greenc = %3d bluec %3d \n"
//,hue/SCALE,redc,greenc,bluec);
	    }
	    else if (g == cmax) {
	        hue = redc - bluec;
		if (hue < 0) hue += 3*SCALE;
	        hue += (4*6*SCALE);
	    }
            else {
		hue = greenc - redc;
		if (hue < 0) hue += 3*SCALE;
		hue += (8*6*SCALE);
	    }
	    if (hue < 0) {
		hue = hue + (12*6*SCALE);
	    } else {
	    }
	    //hue += (SCALE/2);
	    hue /= (SCALE*6);
	}
	return   packMC(hue,sat,bri);
}

#ifdef TEST
main() {
	int hue,sat,bri;
	int hue2,sat2,bri2;
	int r,g,b;
	int i,c,cc;

	for (i=0; i<12; i++)
	 for (bri=0; bri<=0xf; bri++)
	   for (sat=1; sat<= bri; sat++) {
		//if ((bri == 0) && (i != 0)) continue;
		//if ((sat != 0xf) || (bri != 0xf)) continue;
		hue = i;

		c = packMC(hue,sat,bri);
		cc = mc_to_rgb(c);
		unpackRGB(cc,r,g,b);
//printf("H %2d S %2d V %2d -> R %2d G %2d B %2d \n"
//,hue,sat,bri,r,g,b);
		c = packRGB(r,g,b);
		cc = mc_from_rgb(c);
		unpackMC(cc,hue2,sat2,bri2);
//printf("H %2d S %2d V %2d <- R %2d G %2d B %2d \n"
//,hue2,sat2,bri2,r,g,b);
if ((hue != hue2) || (sat != sat2) ||  (bri != bri2)) {
		printf("H %2d S %2d V %2d -> R %2d G %2d B %2d \n"
			,hue,sat,bri,r,g,b);
		printf("H %2d S %2d V %2d <- R %2d G %2d B %2d \n"
			,hue2,sat2,bri2,r,g,b);

		//printf("--------\n");
}
	}
}
#endif

#ifdef MAKETAB
main() {
	make_tables();
}

int mc2rgb_tab[4096];
int rgb2mc_tab[4096];
int rgb2mc_tab_alt[4096];
int mc_cnt;
int rgb_cnt;
int rgb_alt_cnt;

try_col(int c1,int r,int g,int b) {
	int c2;
	if ((r > 15) || (r < 0)) return 0;
	if ((g > 15) || (g < 0)) return 0;
	if ((b > 15) || (b < 0)) return 0;
	c2 = packRGB(r,g,b);
	if (rgb2mc_tab_alt[c2] < 0) {
		mc2rgb_tab[c1] = c2;
		rgb2mc_tab_alt[c2] = c1;
		mc_cnt++;
		rgb_alt_cnt++;
		return 1;
	}
	return 0;
}

make_tables() {
	int i,c,c1,c2,c3;
	int hue,sat,bri;
	int r,g,b;
	for (i=0; i<4096; i++) {
		mc2rgb_tab[i] = -1;
		rgb2mc_tab[i] = -1;
		rgb2mc_tab_alt[i] = -1;
	}
	sat = 0;
	hue = 0;
	for (bri =0; bri<16; bri++) {
		c1 = packMC(hue,sat,bri);
		c2 = mc_to_rgb(c1);
		unpackRGB(c2,r,g,b);
		if ((mc2rgb_tab[c1] >= 0) || (rgb2mc_tab[c2] >= 0)) {
			printf("duplicate mc(1) mc=%03x\n",c1);
			exit(1);
		}
		mc2rgb_tab[c1] = c2;
		rgb2mc_tab[c2] = c1;
		mc_cnt++;
		rgb_cnt++;
	}
	/* pass 1 */
	for (bri=15; bri >= 0; bri--)
	    for (sat=bri; sat > 0; sat--)
		for (hue=0; hue < 12; hue++) {
		c1 = packMC(hue,sat,bri);
		c2 = mc_to_rgb(c1);
		unpackRGB(c2,r,g,b);
		if (mc2rgb_tab[c1] >= 0) {
			printf("duplicate mc(2) mc=%03x\n",c1);
			exit(1);
		}
		if (rgb2mc_tab[c2] >= 0) {
			continue;
		}
		mc2rgb_tab[c1] = c2;
		rgb2mc_tab[c2] = c1;
		mc_cnt++;
		rgb_cnt++;
	}
	/* pass 2 */
	for (bri=15; bri >= 0; bri--)
	    for (sat=bri; sat > 0; sat--)
		for (hue=0; hue < 12; hue++) {
		c1 = packMC(hue,sat,bri);
		c2 = mc_to_rgb(c1);
		unpackRGB(c2,r,g,b);
		if (mc2rgb_tab[c1] >= 0) {
			continue;
		}
		if (rgb2mc_tab[c2] >= 0) {
			if (try_col(c1,r,g,b)) continue;
			if (try_col(c1,r+1,g,b)) continue;
			if (try_col(c1,r,g+1,b)) continue;
			if (try_col(c1,r,g,b+1)) continue;
			if (try_col(c1,r-1,g,b)) continue;
			if (try_col(c1,r,g-1,b)) continue;
			if (try_col(c1,r,g,b-1)) continue;
			if (try_col(c1,r+1,g+1,b)) continue;
			if (try_col(c1,r,g+1,b+1)) continue;
			if (try_col(c1,r+1,g,b+1)) continue;
			if (try_col(c1,r-1,g-1,b)) continue;
			if (try_col(c1,r,g-1,b-1)) continue;
			if (try_col(c1,r-1,g,b-1)) continue;
			printf("duplicate rgb mc=%03x rgb=%03x\n",c1,c2);
			exit(1);
		} else {
			printf("assertion error1 %03x %03x\n",c1,c2);
			exit(1);
		}
	}
	printf("total mc = %d rgb = %d rgb_alt = %d\n",mc_cnt,rgb_cnt,rgb_alt_cnt);
	for (bri=15; bri >= 0; bri--)
	    for (sat=15; sat >= 0; sat--)
		for (hue=0; hue < 12; hue++) {
		c1 = packMC(hue,sat,bri);
		if (mc2rgb_tab[c1] >= 0) {
			continue;
		}
		if ((sat == 0) || (bri == 0)) {
			c2 = packMC(0,0,bri);
			if (mc2rgb_tab[c2] >= 0) {
				mc2rgb_tab[c1] = mc2rgb_tab[c2];
			} else {
				printf("assertion error2 %03x %03x\n",c1,c2);
				exit(1);
			}
		}
		else if (sat > bri) {
			c2 = packMC(hue,bri,bri);
			if (mc2rgb_tab[c2] >= 0) {
				mc2rgb_tab[c1] = mc2rgb_tab[c2];
			} else {
				printf("assertion error3 %03x %03x\n",c1,c2);
				exit(1);
			}
		} else {
			printf("assertion error4 %03x \n",c1);
			exit(1);
		}
	}
	for (bri=15; bri >= 0; bri--)
	    for (sat=15; sat >= 0; sat--)
		for (hue=12; hue < 16; hue++) {
		c1 = packMC(hue,sat,bri);
		if (mc2rgb_tab[c1] >= 0) {
			printf("assertion error5 %03x \n",c1);
			exit(1);
		}
		mc2rgb_tab[c1] = 0;
	}
	
}

#endif
