/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *      
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MGL_H /* _MGL_H */
#define _MGL_H

#ifndef MGL_PREFIX
#define  create_gesture_pad  mgl_create_gesture_pad  
#define  create_virtual_key  mgl_create_virtual_key  
#define  create_virtual_key3  mgl_create_virtual_key3  
#define  millitime  mgl_millitime  
#define  vk_attach  mgl_vk_attach  
#define  vk_detach  mgl_vk_detach  
#define  vk_x  mgl_vk_x  
#define  vk_y  mgl_vk_y  
#define  bitblt  mgl_bitblt  
#define  clear_screen  mgl_clear_screen
#define  close_graph  mgl_close_graph  
#define  create_memscreen  mgl_create_memscreen  
#define  create_subscreen  mgl_create_subscreen  
#define  current_screen  mgl_current_screen  
#define  draw_font  mgl_draw_font  
#define  draw_line  mgl_draw_line  
#define  draw_pixel  mgl_draw_pixel  
#define  draw_pixel_wc  mgl_draw_pixel_wc
#define  draw_rect  mgl_draw_rect  
#define  draw_string  mgl_draw_string  
#define  fill_rect  mgl_fill_rect  
#define  free_screen  mgl_free_screen  
#define  get_key  mgl_get_key  
#define  get_key_im  mgl_get_key_im  
#define  get_pixel  mgl_get_pixel  
#define  get_pixstream  mgl_get_pixstream  
#define  key_select  mgl_key_select  
#define  load_font  mgl_load_font  
#define  open_graph  mgl_open_graph  
#define  physical_screen  mgl_physical_screen  
#define  pop_screen  mgl_pop_screen  
#define  push_screen  mgl_push_screen  
#define  put_pixel  mgl_put_pixel  
#define  put_pixstream  mgl_put_pixstream  
#define  put_pixstream_rect  mgl_put_pixstream_rect  
#define  refresh  mgl_refresh  
#define  set_color  mgl_set_color  
#define  set_font  mgl_set_font  
#define  set_icon  mgl_set_icon  
#define  pen_font  mgl_pen_font  
#define  pen_fattr  mgl_pen_fattr
#define  pen_color  mgl_pen_color  
#define  create_textscreen  mgl_create_textscreen 
#define  free_textscreen  mgl_free_textscreen 
#define  ts_clear  mgl_ts_clear 
#define  ts_put_string mgl_ts_put_string
#define  ts_goto mgl_ts_goto
#define  ts_set_bgcolor mgl_ts_set_bgcolor
#define  ts_put_image   mgl_ts_put_image
#define  conv_screen_from_v1  mgl_conv_screen_from_v1
#define  conv_screen_from_mgr  mgl_conv_screen_from_mgr
#define  conv_screen_to_mgr  mgl_conv_screen_to_mgr
#define  write_screen_xpm  mgl_write_screen_xpm
#define  write_screen_native  mgl_write_screen_native
#define  conv_screen_from_xpm  mgl_conv_screen_from_xpm
#define  read_screen_mgr  mgl_read_screen_mgr
#define  write_screen_mgr  mgl_write_screen_mgr
#define  get_im_mode mgl_get_im_mode
#define  toggle_im_mode mgl_toggle_im_mode
#define  im_avoid_point	mgl_im_avoid_point	
#define  im_impart_point mgl_im_impart_point	
#define  im_view_point mgl_im_view_point
#endif

#define mgl_pen_color (mgl_current_screen->_pen_color.color)
#define mgl_pen_font  (&(mgl_current_screen->_pen_font))
#define mgl_pen_fattr  (mgl_current_screen->_pen_font.attr)

#include <sys/types.h>

#if 0
#if defined (__FreeBSD__)
#  include <machine/endian.h>
#elif defined (__linux__)
#  ifndef _NETINET_IN_H
#    include <asm/byteorder.h>
#  endif
#endif
#endif

/* mgl-1.x format screen */
struct screen_v1 {
	int type; /* 1: malloced struct screen 2: malloced bitmap */
	int wbytes;
	int width;
	int height;
	char *bitmap;
};

/* mgl-2.x format screen */
#define screen_v2	screen


struct de_context {
	short color;		/* global */
	short flags;		/* local */
	int local_color;	/* local */
	void *link;		/* local */
	void *opt;		/* local */
};

struct fe_context {
	short attr;		/* global */
	char width;		/* global */
	char height;		/* global */
	void *link;		/* local */
	void *opt;		/* local */
};

struct screen {
	/* general screen field */
	int type;
	int op;			/* reserverd op */
	struct draw_engine *de; /* draw_engine */
	unsigned short width;
	unsigned short height;
	unsigned short wbytes;
	short need_clipping;
	char *bitmap; /* subscreen -> root screen addr : mem -> bitmap */
	short off_x;     /* subscreen -> offset x */
	short off_y;     /* subscreen -> offset y */
	int plbytes;	 /* size of 1 plane in bytes */

	struct de_context _pen_color;
	struct fe_context _pen_font;
	/* for futuer use (and binary comatibility ?) */
	int notused[10];
};

extern struct screen *mgl_current_screen,*mgl_physical_screen;

#define ST_KINDMASK		0xf
#define STK_NATIVE		0
#define STK_GENERIC_4COLOR	1
#define STK_GENERIC_192COLOR	2
#define STK_GENERIC_FULLCOLOR	3
#define STK_GENERIC_16COLOR	4
#define STK_MD_BASE		8

#define ST_ALLOCED		0x10
#define ST_ALLOCED_BITMAP	0x20
#define ST_SUBSCREEN		0x40
#define ST_RESERVEOP		0x80

struct draw_engine {
	struct screen *(*_create_subscreen)(struct screen *,int,int,int,int,int);
	void (*_free_screen)(struct screen *);
	void (*_put_pixel)(struct screen *,int,int,int);
	int (*_get_pixel)(struct screen *,int,int,int);
	void (*_set_color)(struct screen *,int);
	void (*_draw_pixel)(struct screen *,int,int);


	void (*_draw_line_vertical)(struct screen *,int,int,int,int,struct draw_engine*);
	void (*_draw_line_horizontal)(struct screen *,int,int,int,int,struct draw_engine *);

	void (*_draw_line)(struct screen *,int,int,int,int,struct draw_engine*);

	void (*_clear_screen)(struct screen *,struct draw_engine *);

	void (*_get_pixstream)(struct screen *,int,int,int *,int,int,int,struct draw_engine *);
	void (*_put_pixstream)(struct screen *,int,int,int *,int,int,struct draw_engine *);

	void (*_put_pixstream_rect)(struct screen *,int,int,int *,int,int,int,struct draw_engine *);

	void (*_bitblt_scroll_forward)(struct screen *,int,int
		,struct screen *,int,int,int,int,int,struct draw_engine *);
	void (*_bitblt_scroll_backward)(struct screen *,int,int
		,struct screen *,int,int,int,int,int,struct draw_engine *);
	void (*_bitblt_copy)(struct screen *,int,int
		,struct screen *,int,int,int,int,int,struct draw_engine *);
	void (*_bitblt_reserved_mask)(struct screen *,int,int
		,struct screen *,int,int,int,int,int,struct draw_engine *);
	void (*_bitblt_reserved_masktile)(struct screen *,int,int
		,struct screen *,int,int,int,int,int,struct draw_engine *);

	void (*_bitblt)(struct screen *,int,int
		,struct screen *,int,int,int,int,int,struct draw_engine *);
};

#define DE_FAST_VERTICAL	1

extern struct screen *(*_create_memscreen[16])(int,int,char *,int);

/* subscreen option for system */
#define CSS_AS_MEMSCREEN		1

/*
MGL ǤοϡHSB Ϥˤ롣(99/11/23)



      4: DITHER 
           bit  ON ˤȡǥ롣
          FULLCOLOR screen 鿧ɤ߽Фȡ bit  ON ˤʤäƤ
          bitblt  draw ϤǤͭ
          draw ϤǻȤϡŪ˻ꤹɤ
          
      2: TRANSPARENT
          Ʃ
      1: REVERSE
      |
   | OP(4)  | H(4)  | S(4)  | B(4)  |
             |      |       |
             |      |       +-- Bri()
             |      +---------- Sat() ( 15 䤫 0 ʤ )
             Hue() (12 colors)
                 0 red     
                 2 yellow  
                 4 green   
                 6 cyan    忧
                 8 blue    
                10 magenta ֻ
                12-15 not used

  ) Sat() ϡBri ʾͤꤷƤ 䤫Ѥʤ
      ޤ0 Υϡ쥤̣Hue ϰ̣ʤ

      äƻȤ翧ϡ
						Full     8bpp
		쥤 MaxBri+1          16      4
		12 * (1 + 2 + 3 ... + MaxSat)    1440    72
						 1456    76

      ˤʤ롣

ƥե졼ХåեǻȤ

Mono                    | 0000  | 0000  | #...  |
4 Gray Scale            | 0000  | 0000  | ##..  |
8bpp Pseudo Color(192)  | ####  | ##..  | ##..  |
16bpp Solid Color(3072) | ####  | ####  | ####  |

( . ϡ# Ʊ ex. 0x3 -> 0x33 )

Mono  4 Gray Scale ϤƤ...

8bpp 顼Ǥϡºݤˤϡ76 Ȥʤ
ޤbri ȤHue ԳΤˤʤΤǡ
¾ο˽ŤͤƤɤ(ͥ٤㤤)

16bpp ξ 12*16*16  Ѵơ֥롣
ˡ16*16*16 εѴơ֥뤬ɬס

ɬפʥХȿϡ (3K + 4K)*2bytes = 14K Х 

--------------------------------------------------------
*/

#define COLOR_WHITE		0x000f /* 1111 */
#define COLOR_LIGHTGRAY		0x000a /* 1010 */
#define COLOR_DARKGRAY		0x0005 /* 0101 */
#define COLOR_BLACK		0x0000 /* 0000 */
#define COLOR_REVERSE		0x1000
#define COLOR_TRANSPARENT	0x2000 	/* ?? */
#define COLOR_DITHER		0x4000 	/* option */

#define CONV_TO_COL2(c)		(((c) >> 3) & 0x1)
#define CONV_FROM_COL2(c)	((c) ? 0x00f : 0x000)

#define CONV_TO_COL4(c)		(((c) >> 2) & 0x3)
#define CONV_FROM_COL4(c)	(( (c) | ((c) << 2)) & 0xfff)

#define CONV_TO_COL192(c)	((((c) >> 4) & 0xfc) | (((c) >> 2) & 0x3))
#define CONV_FROM_COL192(c)	( ((c) & 0x3)  | (((c) & 0xf)<<2) \
 				 | ((c & 0xfc)<< 4) )

#define CONV_TO_COL16(c)	(c & 0xf)
#define CONV_FROM_COL16(c)	(c & 0xfff)

#define BLT_TILING		0x10000000
#define BLT_MASKING		0x20000000
#define BLT_MASKCOL		0x00ffffff

#define FA_NORMAL	0
#define FA_ITALIC	1
#define FA_BOLD		2

#define get_font_width()	(mgl_pen_font->width)
#define get_font_height() 	(mgl_pen_font->height)

struct font_engine {
	void (*_set_font)(struct screen *,int,int);
	void (*_draw_font)(struct screen *,int,int,int,int);
	int (*_load_font)(char *,int ,int);
	void (*_term)();
};
extern struct font_engine *mgl_fe;


/* global status */

extern int mgl_screen_width;
extern int mgl_screen_height;
#define SCREEN_WIDTH	mgl_screen_width
#define SCREEN_HEIGHT	mgl_screen_height

extern int mgl_apli_type;	/* if client used in open_graph() */
#define AT_MAIN		1
#define AT_MINIAPLI	2
#define AT_PALM		4
#define AT_TASKBAR	8

extern int mgl_client;		/* if client set after open_graph() */
				/* 0 : not client */
				/* 1 : client */
extern int mgl_color_model;	/* set after draw_engine init */
				/* 4 color    -> STK_GENERIC_4COLOR */
				/* 192 color  -> STK_GENERIC_192COLOR */
				/* full color -> STK_GENERIC_FULLCOLOR */
				/* 16 color -> STK_GENERIC_16COLOR */
extern char *mgl_server_id;	/* ident for server */
				/* used only at multiple server */

struct event_manager {
	int (*_get_key)(int);
	int (*_key_select)(int,fd_set *,int);
	void (*_refresh)();
	void (*_set_icon)(char *,char *);
	void (*_term)();
	int (*_set_keymode)(int);
};

extern int mgl_key_mode;

extern int mgl_keyboard_reopen;

#define MGL_SK_TRANSLATED			0
#define MGL_SK_RAW				1
#define MGL_SK_EXTRANSLATED			2

#define MGL_SK_KM_MASK			0x000f
#define MGL_SK_EXMOUSE_EVENT		0x0010
#define MGL_SK_EXMODIFIER		0x0020

#define MGL_SKM_MASK			0x7ff80000

/* the modifiers used by MGL_SK_EXTRANSLATED mode */
#define MGL_SKM_SHIFT			0x01000000
#define MGL_SKM_CTRL			0x02000000
#define MGL_SKM_ALT			0x04000000
#define MGL_SKM_CAPS			0x08000000
#define MGL_SKM_MENU			0x10000000
#define MGL_SKM_OPT			0x20000000
#define MGL_SKM_NOTICE			0x40000000
#define MGL_SKM_RSHIFT			0x00100000
#define MGL_SKM_RCTRL			0x00200000
#define MGL_SKM_RALT			0x00400000
#define MGL_SKM_RCAPS			0x00800000
#define MGL_SKM_RMENU			0x00080000

/* the status apper in only mgl_modifier_status */
#define MGL_SKS_CAPS_LOCKED		0x00040000
#define MGL_SKS_NUM_LOCKED		0x00020000

extern int mgl_key_ok;
extern int mgl_key_cancel;
extern int mgl_key_up;
extern int mgl_key_down;
extern int mgl_key_left;
extern int mgl_key_right;
extern int mgl_key_A;
extern int mgl_key_B;

struct virtual_key *mgl_create_gesture_pad(int x,int y,int xs,int ys);

/* 

  RAW ⡼ɤϡFreeBSD Ǥ K_CODE ⡼ (= scancode 
  1 ХȷϤѴη) 

  Ʊηϡ
  ¾ OS ǤϡΥηϤ˹碌롣

 */


extern struct event_manager *mgl_em;

struct textscreen {
	struct screen *ss,*sc,*save;
	int attr,x,y,xs,ys;
	int xpos,ypos,lh;
	int bgcolor;
};

#define TS_SAVE		1
#define TS_BORDER	2
#define TS_BLINE	4

/* MGL KEYCODE */
#define MK_F1		0x101
#define MK_F2		0x102
#define MK_F3		0x103
#define MK_F4		0x104
#define MK_F5		0x105
#define MK_F6		0x106
#define MK_F7		0x107
#define MK_F8		0x108
#define MK_F9		0x109
#define MK_F10		0x10a
#define MK_F11		0x10b
#define MK_F12		0x10c
#define MK_HOME		0x111
#define MK_END		0x112
#define MK_UP		0x113
#define MK_DOWN		0x114
#define MK_RIGHT	0x115
#define MK_LEFT		0x116
#define MK_PAGE_UP	0x117
#define MK_PAGE_DOWN	0x118
#define MK_INS		0x119
#define MK_DEL		0x11a
#define MK_MENU		0x11b
#define MK_NUMLOCK	0x11c

/* direction */
#define DIR_NORTH	0
#define DIR_WEST	1
#define DIR_SOUTH	2
#define DIR_EAST	3

/* MGR format */
#define MGR_HEADER_SIZE 16

/* vertual key */
struct virtual_key {
	int up,down,move;
	int x,y,xs,ys;
	struct virtual_key *parent;
	struct virtual_key *child;
	struct virtual_key *link;
	int (*callback)(int type,int x,int y);
};

/* vk Key Code 0x201 -- 0x2ff */

#define MK_V0	0x200
#define MK_V1	0x201
#define MK_V2	0x202
#define MK_V3	0x203
#define MK_V4	0x204
#define MK_V5	0x205
#define MK_V6	0x206
#define MK_V7	0x207
#define MK_V8	0x208
#define MK_V9	0x209
#define MK_V10	0x20a
#define MK_V11	0x20b
#define MK_V12	0x20c
#define MK_V13	0x20d
#define MK_V14	0x20e
#define MK_V15	0x20f


/* MGL_PREFIX  define ʤСmgl_ 褦 define  */
/*  */
int mgl_open_graph(void);
void mgl_close_graph(void);
/* ꡼ */
struct screen *mgl_create_memscreen(int xs,int ys,char *bitmap,int kind, int op);
struct screen *mgl_create_subscreen(struct screen *org,int x,int y,int xs,int ys);
void mgl_free_screen(struct screen *s);
/* ꡼եޥåѴ */
char *mgl_conv_screen_to_mgr(struct screen *s,char *buf,int len);
struct screen * mgl_conv_screen_from_mgr(unsigned char *buf,int kind);
struct screen * mgl_read_screen_mgr(char *name);
int mgl_write_screen_mgr(char *name, struct screen *ss,int opt);
struct screen *mgl_conv_screen_from_v1(struct screen_v1 *s,int kind);

#ifdef IMAGE_EXTENSION
int   mgl_write_screen_xpm(char *name, struct screen *s);
void   mgl_write_screen_native(char *name, struct screen *s);
struct screen *mgl_conv_screen_from_xpm(unsigned char **s,int kind);
#endif

/* 襳ƥ */
void mgl_push_screen(struct screen *s);
void mgl_pop_screen(void);
void mgl_set_color(int col);
void mgl_set_font(int size,int type);
/*  */

void mgl_clear_screen(void);
void mgl_draw_font(int x, int y, int code, int dir);
int mgl_draw_line(int x1, int y1, int x2, int y2);
void mgl_draw_pixel(int x, int y);
void mgl_draw_string(int x, int y, char *str, int dir);
void mgl_fill_rect(int x, int y, int xs, int ys);
void mgl_draw_rect(int x, int y, int xs, int ys);

/* ԥط */
void mgl_put_pixstream_rect(int x, int y,int *buf,int length,int dir,int op);
void mgl_put_pixstream(int x, int y,int *buf,int length,int dir);
void mgl_get_pixstream(int x, int y,int *buf,int length,int dir,int op);
int mgl_get_pixel(int x, int y, int op);
void mgl_put_pixel(int x, int y, int col);

void mgl_bitblt(struct screen *dst, int dx, int dy, struct screen *src, int sx, int sy, int xsize, int ysize, int op);

/* textscreen */
struct textscreen *mgl_create_textscreen(struct screen *s, int x,
                                     int y, int xs, int ys, int attr);
void mgl_free_textscreen(struct textscreen *t);
void mgl_ts_clear(struct textscreen *t);
void mgl_ts_put_string(struct textscreen *t, char *str, int op);
void mgl_ts_goto(struct textscreen *t, int x, int y);
void mgl_ts_set_bgcolor(struct textscreen *t, int c);
void mgl_ts_put_image(struct textscreen *t, struct screen *s,
                  int sx, int sy, int w, int h, int op);

/* ٥ȴط */
int mgl_get_key(int time_out);
int mgl_get_key_im(int time_out);
int mgl_key_select(int nfds, fd_set *readfds, int timeout);
void mgl_set_icon(char *icon,char *name);
int mgl_set_keymode(int);
struct virtual_key *mgl_create_virtual_key(int x,int y,int xs,int ys,int keycode);
struct virtual_key *mgl_create_virtual_key3(int x,int y,int xs,int ys,int down,int move,int up);
void mgl_vk_attach(struct virtual_key *parent,struct virtual_key *vk);
void mgl_vk_detach(struct virtual_key *vk,int clean_mode);
void mgl_refresh(void);
int mgl_get_im_mode(void);
void mgl_toggle_im_mode(void);
extern int mgl_vk_x;
extern int mgl_vk_y;
long long mgl_millitime(void);
int mgl_im_view_point(int xs,int ys,int *xp,int *yp);
void mgl_im_avoid_point(int x, int y, int clean);
void mgl_im_impart_point(int x, int y, int clean);

int mgl_get_keysym(char *name);
int mgl_set_keysym(char *name, int code);

void mgl_get_keymap(int code, char *sym1, char *sym2, char *sym3);
extern int mgl_button_shift; /* 0: button1 1: button2 2: button3 */
extern int mgl_modifier_status; 

#define MGL_CT_SAMPLE		1
#define MGL_CT_FORMULA		2
extern int mgl_calibrate_start(int *data,int max_data);
extern int mgl_calibrate_end(int *data);

char *mgl_getenv(char *);
 
void mgl2_clear_screen(struct screen *s);
void mgl2_put_pixel(struct screen *s,int x, int y, int col);
int mgl2_get_pixel(struct screen *s,int x, int y, int op);
void mgl2_get_pixstream(struct screen *s,int x, int y,int *buf,int length,int dir,int op);
void mgl2_put_pixstream(struct screen *s,int x, int y,int *buf,int length,int dir);
void mgl2_put_pixstream_rect(struct screen *s,int x, int y,int *buf,int length,int dir,int op);
void mgl2_set_color(struct screen *s,int col);
void mgl2_draw_pixel(struct screen *s,int x, int y);
int mgl2_draw_line(struct screen *s,int x1, int y1, int x2, int y2);
void mgl2_draw_rect(struct screen *s,int x, int y, int xs, int ys);
void mgl2_fill_rect(struct screen *s,int x, int y, int xs, int ys);
void mgl2_set_font(struct screen *s,int size,int type);
void mgl2_draw_font(struct screen *s,int x, int y, int code, int dir);
void mgl2_draw_string(struct screen *s,int x, int y, char *str, int dir);

#define mgl2_get_font_width(s)	((s)->_pen_font.width)
#define mgl2_get_font_height(s)	((s)->_pen_font.height)

#endif  /* _MGL_H */
