/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include "config.h"

#include <sys/types.h>
#include <sys/mman.h>

#include "mgl2.h"

#ifdef USE_LOCAL_MEMSET
#define memset	mgl_memset
#endif
#ifdef USE_LOCAL_MEMMOVE
#define memmove	mgl_memmove
#endif

#include "mgl_md.h"

#ifndef MGLDIR
#  define MGLDIR "/usr/local/lib/mgl"
#endif
#define FONTPATH	MGLDIR "/krom.fnt"

#if ( MGL_MACHINE == MGL_MACHINE_MG_LINUX )
#  define FONTPATH2	"/dev/mgfonts"
#endif

#ifndef NULL
#define NULL	(void *)0
#endif

#ifndef MAP_FAILED
#define MAP_FAILED  ((void *)-1)
#endif

static char *font_base;

static struct romfont {
	int height;
	int width;

	int koffset;
	int kwidth;
	int kbytes;
	int aoffset;
	int awidth;
	int abytes;
	int goffset;
	int gwidth;
	int gbytes;
	int fd;	/* external font */
} romfont[6] = {
	{  12, 12, 0x00000, 2,32,  0x3f000, 1,16 ,  0x40000, 2,32},
	{  16, 16, 0x44800, 2,32,  0x83800, 1,16 ,  0x84800, 2,32},
	{  24, 24, 0x89800, 3,80, 0x127000, 2,48 , 0x12a000, 3,80},
	{   8, 16, 0x00000, 0, 0, 0x89000,  1, 8 , 0x000000, 0, 0},
};

#define ferom_font  ((struct romfont *)(s->_pen_font.opt))
#define ferom_attr  (s->_pen_font.attr)
#define ferom_width (s->_pen_font.width)
#define ferom_height (s->_pen_font.height)
#define ferom_off  (*(char *)(&s->_pen_font.link))

/* եȥ°ꤷޤ
        size ϡ12,16,24 Τɤ줫
        attr ϡFA_ITALIC  FA_BOLD ξꤷޤ
*/
static void ferom_set_font(struct screen *s,int size, int attr) {
	ferom_off = 0;
	switch (size) {
	case 12:
		ferom_font = &romfont[0];
		ferom_width = ferom_height = 12;
		break;
	case 16:
		ferom_font = &romfont[1]; 
		if (ferom_font->height == 0) {
			ferom_font = &romfont[0];
			ferom_off = 2;
		}
		ferom_width = ferom_height = 16;
		break;
	case 24:
		ferom_font = &romfont[2];
		if (ferom_font->height == 0) {
			ferom_font = &romfont[0];
			ferom_off = 6;
		}
		ferom_width = ferom_height = 24;
		break;
	default: 
		if (size == romfont[4].height) {
			ferom_font = &romfont[4];
			ferom_width = ferom_font->width;
			ferom_height = ferom_font->height;
		} else if ( size == romfont[5].height) {
			ferom_font = &romfont[5];
			ferom_width = ferom_font->width;
			ferom_height = ferom_font->height;
		} else {
			ferom_font = &romfont[0];
			ferom_width = ferom_font->width;
			ferom_height = ferom_font->height;
		}
	}
	ferom_attr = attr;
	return;
}

#if 0
/* x,y 顢code ʸ褷ޤ(åԥդ)
        ʸɤϡ2Хʸ (EUC1Х * 256 + EUC2Х)
        1Хʸ (<256) Ǥ
        ) x,y ϡʸκκɸǤ
*/
void ferom_draw_font_clipping(int x, int y, int code, int x1, int y1, int x2, int y2) {
	char *p;
	int xcode;
	int width;
	int height;
	int i,j,k;
	int d = (ferom_attr & FA_ITALIC)?64:0;
	int xx,yy;
	int x0 = x;
	
	x <<= 8;

	if (code < 0x100) {
		p = font_base + ferom_font->aoffset + ferom_font->abytes * code;
		height = ferom_font->height;
		width = ferom_font->awidth;
	} else if (((code >> 8) & 0xff) == 0x8E) {
		xcode = (code & 0xff);
		p = font_base + ferom_font->aoffset + ferom_font->abytes * xcode;
		height = ferom_font->height;
		width = ferom_font->awidth;
	} else {
		xcode = (((code >> 8) & 0x7f) - 0x21) * 96 
			+ ((code & 0x7f) - 0x20);
		if (xcode >= 8064) return;
		p = font_base + ferom_font->koffset + ferom_font->kbytes * xcode;
		height = ferom_font->height;
		width = ferom_font->kwidth;
	}
	if (width == 0) return;

	if (x1 <= x0 && y1 <= y
	    && x0 + ferom_font->width < x2 && y + height < y2){
	    /* NO CLIPPING */
	    for (i = 0; i < height; i++){
		yy = y + i;
		for (j = 0; j < width; j++, p++){
		    for (k = 0; k < 8; k++){
			if (*p & (1<<(7-k))){
			    xx = ((x+d*(height-1-i))>>8)+j*8+k;
			    draw_pixel(xx,yy);
			    if (ferom_attr & FA_BOLD)
				draw_pixel(xx+1,yy);
			}
		    }
		}
	    }	
	}else{
	    /* CLIPPING */
	    for (i = 0; i < height; i++){
		yy = y + i;
		for (j = 0; j < width; j++, p++){
		    if (y1 <= yy && yy < y2){
			for (k = 0; k < 8; k++){
			    if (*p & (1<<(7-k))){
				xx = ((x+d*(height-1-i))>>8)+j*8+k;
				if (x1 <= xx && xx < x2)
				    draw_pixel(xx,yy);
				if (ferom_attr & FA_BOLD)
				    if (x1 <= xx+1 && xx+1 < x2)
					draw_pixel(xx+1,yy);
			    }
			}
		    }
		}
	    }	
	}
	return;
}

#endif

/* x,y 顢code ʸ褷ޤ
        ʸɤϡ2Хʸ (EUC1Х * 256 + EUC2Х)
        1Хʸ (<256) Ǥ
        ) x,y ϡʸκκɸǤ
*/
static void ferom_draw_font(struct screen *s,int x, int y, int code, int dir) {
	char *p;
	int xcode;
	int width;
	int height;
	int i,j,k;
	int d = (ferom_attr & FA_ITALIC)?64:0;
	int xx,yy;
	int x2,y2;
	int x0 = x;
	int buf[24*24];
	int *bp;
	int col = pen_color;
	
	if (code < 0x100) {
		p = font_base + ferom_font->aoffset + ferom_font->abytes * code;
		height = ferom_font->height;
		width = ferom_font->awidth;
		x += ferom_off >> 1;
		y += ferom_off;
	} else if (((code >> 8) & 0xff) == 0x8E) {
		xcode = (code & 0xff);
		p = font_base + ferom_font->aoffset + ferom_font->abytes * xcode;
		height = ferom_font->height;
		width = ferom_font->awidth;
		x += ferom_off>>1;
		y += ferom_off;
	} else {
		xcode = (((code >> 8) & 0x7f) - 0x21) * 96 
			+ ((code & 0x7f) - 0x20);
		if (xcode >= 8064) return;
		p = font_base + ferom_font->koffset + ferom_font->kbytes * xcode;
		height = ferom_font->height;
		width = ferom_font->kwidth;
		x += ferom_off;
		y += ferom_off;
	}
	if ((width <= 0) || width > 4) return;

	switch (dir) {
	default:
	case DIR_NORTH:
	    if (!(ferom_attr & FA_ITALIC)) {
		bp = buf;
	    	for (i = 0; i < height; i++) {
		  for (j = 0; j < width; j++, p++) {
#if (OPTIMIZE_FOR == OPTTYPE_SLOW)
		    for (k = 0; k < 8; k++) {
			*bp++ = (*p & (1<<(7-k)))? col
			                  :COLOR_TRANSPARENT;
			}
#elif (0 /*OPTIMZE_FOR == OPTTYPE_486*/)
			int dat = *p;
			bp[0] = (dat & 0x80)? col :COLOR_TRANSPARENT;
			bp[1] = (dat & 0x40)? col :COLOR_TRANSPARENT;
			bp[2] = (dat & 0x20)? col :COLOR_TRANSPARENT;
			bp[3] = (dat & 0x10)? col :COLOR_TRANSPARENT;
			bp[4] = (dat & 0x08)? col :COLOR_TRANSPARENT;
			bp[5] = (dat & 0x04)? col :COLOR_TRANSPARENT;
			bp[6] = (dat & 0x02)? col :COLOR_TRANSPARENT;
			bp[7] = (dat & 0x01)? col :COLOR_TRANSPARENT;
			bp += 8;
#else
			int dat = *p;
			bp[0] = COLOR_TRANSPARENT; if (dat & 0x80) bp[0] = col;
			bp[1] = COLOR_TRANSPARENT; if (dat & 0x40) bp[1] = col;
			bp[2] = COLOR_TRANSPARENT; if (dat & 0x20) bp[2] = col;
			bp[3] = COLOR_TRANSPARENT; if (dat & 0x10) bp[3] = col;
			bp[4] = COLOR_TRANSPARENT; if (dat & 0x08) bp[4] = col;
			bp[5] = COLOR_TRANSPARENT; if (dat & 0x04) bp[5] = col;
			bp[6] = COLOR_TRANSPARENT; if (dat & 0x02) bp[6] = col;
			bp[7] = COLOR_TRANSPARENT; if (dat & 0x01) bp[7] = col;
			bp += 8;
#endif
		    }
		}
		put_pixstream_rect(x,y,buf,height*width*8,dir,width*8);
		if (ferom_attr & FA_BOLD)
		    put_pixstream_rect(x+1,y,buf,height*width*8,dir,width*8);
		break;
	    }
	    x <<= 8;
	    for (i = 0; i < height; i++) {
		yy = y+i;
		bp = buf;
		for (j = 0; j < width; j++, p++) {
		    for (k = 0; k < 8; k++) {
		 	*bp++ = (*p & (1<<(7-k)))? col
				          :COLOR_TRANSPARENT;
			}
		}
		xx = (x+d*(height-1-i))>>8;
		put_pixstream(xx,yy,buf,width*8,dir);
		if (ferom_attr & FA_BOLD)
		    put_pixstream(xx+1,yy,buf,width*8,dir);
	    }
	    break;
	case DIR_SOUTH:
	    x <<= 8;
	    for (i = 0; i < height; i++) {
		yy = y-i;
		bp = buf;
		for (j = 0; j < width; j++, p++) {
		    for (k = 0; k < 8; k++) {
		 	*bp++ = (*p & (1<<(7-k)))? col
				          :COLOR_TRANSPARENT;
			}
		}
		xx = (x-d*(height-1-i))>>8;
		put_pixstream(xx,yy,buf,width*8,dir);
		if (ferom_attr & FA_BOLD)
		    put_pixstream(xx-1,yy,buf,width*8,dir);
	    }
	    break;
	case DIR_WEST:
	    y <<= 8;
	    for (i = 0; i < height; i++) {
		xx = x+i;
		bp = buf;
		for (j = 0; j < width; j++, p++) {
		    for (k = 0; k < 8; k++) {
		 	*bp++ = (*p & (1<<(7-k)))? col
				          :COLOR_TRANSPARENT;
			}
		}
		yy = (y-d*(height-1-i))>>8;
		put_pixstream(xx,yy,buf,width*8,dir);
		if (ferom_attr & FA_BOLD)
		    put_pixstream(xx,yy+1,buf,width*8,dir);
	    }
	    break;
	case DIR_EAST:
	    y <<= 8;
	    for (i = 0; i < height; i++) {
		xx = x-i;
		bp = buf;
		for (j = 0; j < width; j++, p++) {
		    for (k = 0; k < 8; k++) {
		 	*bp++ = (*p & (1<<(7-k)))? col
				          :COLOR_TRANSPARENT;
			}
		}
		yy = (y+d*(height-1-i))>>8;
		put_pixstream(xx,yy,buf,width*8,dir);
		if (ferom_attr & FA_BOLD)
		    put_pixstream(xx,yy-1,buf,width*8,dir);
	    }
	    break;
	}
	return;
}

static int ferom_load_font(char *fname, int width, int height) {
	struct romfont *f = NULL;
	char *p;
	int fd;
	char fpath[256];

	if ((width == 12) && (height == 12) && (romfont[0].height == 0)) {
		f = &romfont[0];
	} else
	if ((width == 16) && (height == 16) && (romfont[1].height == 0)) {
		f = &romfont[1];
	} else
	if ((width == 24) && (height == 24) && (romfont[2].height == 0)) {
		f = &romfont[2];
	} else
	if (romfont[4].height == 0) {
		f = &romfont[4];
	} else
	if (romfont[5].height == 0) {
		f = &romfont[5];
	} else {
		return 0;
	}

	strcpy(fpath,MGLDIR);
	strcat(fpath,"/");
	strcat(fpath,fname);
//printf("load_font %s\n",fpath);
	fd = open(fpath,0);
	if (fd < 0) {
//printf("--- fail\n");
		return 0;
	}

	f->height = height;
	f->width = width;
	f->aoffset = 32;
	f->awidth = (width/2+7)/8;
	f->abytes = f->awidth * height;
	f->koffset = f->aoffset + f->abytes * 256;
	f->kwidth = (width+7)/8;
	f->kbytes = f->kwidth * height;
	f->fd = fd;

	p = (char *) mmap( (caddr_t)0, f->koffset + f->kbytes*8064,
                                   PROT_READ,
				   MAP_SHARED | MAP_FILE,
				   fd, 0);
        if(p == MAP_FAILED){
	        fclose(fd);
		return 0;
        }
	if (!font_base) {
		font_base = p;
	} else {
		f->aoffset += p - font_base;
		f->koffset += p - font_base;
	}
	return 1;
}

static struct font_engine ferom;

int ferom_init() {
    int fd = -1;

#if ( MGL_MACHINE == MGL_MACHINE_MG_LINUX )
    fd = open(FONTPATH2,0);
    if (fd < 0) { fd = open(FONTPATH,0); }
#else 
    fd = open(FONTPATH,0);
#endif
    if (fd >= 0) {
        font_base = (char *) mmap((caddr_t)0, 0x200000,
				   PROT_READ,
				   MAP_SHARED | MAP_FILE,
				   fd, 0);
	if(font_base == MAP_FAILED) font_base = NULL;
    }
    if (!font_base) {
	if (fd > 0) close(fd);
	memset(romfont,0,sizeof(romfont));
	ferom_load_font("k12x12.fnt", 12, 12);
	ferom_load_font("k16x16.fnt", 16, 16);
	ferom_load_font("k24x24.fnt", 24, 24);
   }
   if (!font_base) {
	printf("fatal error -- no fonts\n");
	exit(1);
	return (-1);
   }
   ferom._draw_font = ferom_draw_font;
   ferom._set_font = ferom_set_font;
   ferom._load_font = ferom_load_font;
   mgl_fe = &ferom;
}

