
#define ORD_RGB		0
#define ORD_R5G6B5	1
/* 

ORG_RGB:
       (r << 10) | (g << 5) | b;
ORG_R5G6B5
       (r << 11) | (g << 5) | b;

no other type

   
*/
static short fb16_ctable[4096];
static char *fb16_base;
static int fb16_rowbytes;

static void fb16_setup_ctable(int rgbord) {
	int i;
	int packed_rgb, r,g,b;

	for (i = 0; i < 1024 * 3; i++) {
		packed_rgb = mc_to_rgb(i);
		unpackRGB(packed_rgb, r ,g ,b); /* r,g,b is 4bit */
		switch(rgbord) {
		case ORD_RGB:
			if (r)
				r = r*2+1;
			if (g)
				g = g*2+1;
			if (b)
				b = b*2+1;
                	fb16_ctable[i] = ((r << 10) | (g << 5) | b);
			break;
		case ORD_R5G6B5:
			if (r)
				r = r*2+1;
			if (g)
				g = 0x3f*(g+1)/16;
			if (b)
				b = b*2+1;
                	fb16_ctable[i] = ((r << 11) | (g << 5) | b);
			break;
		default:
			printf("unknown rgb order %d\n",rgbord);
			exit(1);
		}
        }
        for(; i < 4096; i++) {
                fb16_ctable[i] = fb16_ctable[0];
        }
        return;
}

static void fb16_setup(char *base,int rowbytes,int rgbord) {
	fb16_base = base;
	fb16_rowbytes = rowbytes;
	fb16_setup_ctable(rgbord);
}

static void fb16_put_pixstream(int x,int y,int *buf,int xs,int dir, int op) {
	short *pcolor;
	int i;
	pcolor = (short *)(fb16_base + fb16_rowbytes * y + x * 2);
	for (i=0; i< xs; i++,pcolor++,buf++) {
		*pcolor = fb16_ctable[*buf & 0x0fff];
	}
}
