/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef MAP_FAILED
#define MAP_FAILED  ((void *)-1)
#endif

struct emc_packet {
	int kind;
	int args[10];
};

/* client -> server */
#define REQ_CONNECT	0x0011	/* (type) */
/* client <- server */
#define RPLY_CONNECT	0x0026	/* (screen_width,screen_height,xs,ys,type) */
				/*          1   8       8      8           */
				/* type =    | bpp  | type | deidx |       */
				/*         1: use send/recv
				/* args[5]  offset                         */
				/* args[6] ... [9] fb_file_name            */
/* client -> server */
#define ACCEPT_SIZE	0x0031	/* (yes_no) */
#define REQ_DISPMODE	0x0043	/* hide x,y*/
#define RPLY_DISPMODE	0x0050	/* none */


/* client -> server */
#define SET_IM_MODE	0x0061	/* 0: disable 1: enable  NORPLY */
#define REQ_REFRESH	0x0074	/* r_minx,r_miny,r_maxx,r_maxy */
#define REPLY_DISPMODE	0x0080
#define SET_ICON	0x0091	/* length */
#define EXIT_NOTIFY	0x00a0	/* none */
#define SET_KEY_MODE	0x00b1	/* mode */

/* server -> client */
#define EVENT_KEY	0x0302	/* ncodes, code1,code2... */
#define EVENT_MPRESS	0x0313	/* x,y ,mgl_button_shift */
#define EVENT_MRELEASE	0x0322	/* x,y */
#define EVENT_MMOVE	0x0332	/* x,y */
#define EVENT_FOCUS	0x0341	/* on */
#define PUT_KEYMAP	0x0354	/* index, sym1,sym2,sym3 */

#define MAX_SCREEN_SIZE		0x100000	/* 1mb */
#define MAX_SCREENATTR_SIZE	0x040000	/* 256kb */

#define REQ_SHOW	0
#define REQ_HIDE	1

#define FOCUS_ON	1
#define FOCUS_OFF	0

#define kind2name(x)  \
((x == REQ_CONNECT)?"REQ_CONNECT" \
:(x == RPLY_CONNECT)?"RPLY_CONNECT" \
:(x == ACCEPT_SIZE)?"ACCEPT_SIZE" \
:(x == REQ_DISPMODE)?"REQ_DISPMODE" \
:(x == RPLY_DISPMODE)?"RPLY_DISPMODE" \
:(x == SET_IM_MODE)?"SET_IM_MODE" \
:(x == REQ_REFRESH)?"REQ_REFRESH" \
:(x == REPLY_DISPMODE)?"REPLY_DISPMODE" \
:(x == SET_ICON)?"SET_ICON" \
:(x == EXIT_NOTIFY)?"EXIT_NOTIFY" \
:(x == SET_KEY_MODE)?"SET_KEY_MODE" \
:(x == EVENT_KEY)?"EVENT_KEY" \
:(x == EVENT_MPRESS)?"EVENT_MPRESS" \
:(x == EVENT_MRELEASE)?"EVENT_MRELEASE" \
:(x == EVENT_MMOVE)?"EVENT_MMOVE" \
:(x == EVENT_FOCUS)?"EVENT_FOCUS" \
:(x == PUT_KEYMAP)?"PUT_KEYMAP" \
:"unkown")

static inline emc_packet_print(char *s,struct emc_packet *p) {
	int i,n;
	char *kind_name;
	kind_name = kind2name(p->kind);
	n = p->kind & 0xf;
	if (!strcmp("unkown",kind_name)) {
	    n = 0;
	    printf("%s %s(0x%04x)",s,kind_name,p->kind);
	} else {
	    if (p->kind == EVENT_KEY) n = p->args[0]+1;
	    printf("%s %s",s,kind_name);
	}
	for (i=0; i< n; i++) {
		printf(" %d",p->args[i]);
	}
	printf("\n");
}

// #define DEBUG_COMM
