/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include "mgl2.h"

int main() {
	char buf[256];
	struct textscreen *t;
	int ret;
	int i;

	open_graph();
	set_font(12,0);
	set_color(COLOR_WHITE);
	clear_screen();

	set_color(COLOR_BLACK);
	t = create_textscreen(NULL,20,20,600,12*10+8,TS_BORDER|TS_BLINE);
	i = 0;
	set_font(16,0);
	ts_put_string(t,"start test",0);
	mgl_set_keymode(MGL_SK_EXTRANSLATED);
	while (1) {
		ret = get_key(-1);
//printf("%08x\n",ret);
		if (ret < 0) {
			printf("error --- ret = %d\n",ret);
		}
		if (  (ret & ~MGL_SKM_MASK) == ('c'&0x1f)
		   || (ret & ~MGL_SKM_MASK) == (033) ) {
			break;
		}
		if (ret & MGL_SKM_SHIFT) {
			set_color(COLOR_BLACK);
		} else {
			set_color(COLOR_LIGHTGRAY);
		}
		draw_string(0,0,"SHIFT",DIR_NORTH);
		if (ret & MGL_SKM_CTRL) {
			set_color(COLOR_BLACK);
		} else {
			set_color(COLOR_LIGHTGRAY);
		}
		draw_string(100,0,"CTRL",DIR_NORTH);
		if (ret & MGL_SKM_ALT) {
			set_color(COLOR_BLACK);
		} else {
			set_color(COLOR_LIGHTGRAY);
		}
		draw_string(300,0,"ALT",DIR_NORTH);
		if (ret & MGL_SKM_CAPS) {
			set_color(COLOR_BLACK);
		} else {
			set_color(COLOR_LIGHTGRAY);
		}
		draw_string(400,0,"CAPS",DIR_NORTH);
		if (!(ret & MGL_SKM_NOTICE)) {
			set_color(COLOR_BLACK);
			if ((ret & ~MGL_SKM_MASK) < 0x20) {
				buf[0] = '^';
				buf[1] = (ret & ~MGL_SKM_MASK) | 0x20;
				buf[2] = 0;
			}
			buf[0] = ret & ~MGL_SKM_MASK;
			buf[1] = 0;
			ts_put_string(t,buf,0);
		}
refresh();
	}
}
