#include "mgl2.h"

#define OFFSET 24

#ifndef NULL
#define NULL (void *)0
#endif

draw_plus(struct textscreen *ts,int x,int y) {
	int c;
	int gx,gy;
	char buf[256];

	gx = gy = 0;
	set_color(COLOR_REVERSE);

	fill_rect(x-1,y-10,3,21);
	fill_rect(x-10,y-1,21,3);

	while ((c = get_key(-1)) != 033) {
		if (c == MK_V1) {	/* down */
			gx = vk_x;
			gy = vk_y;
		}
		if (c == MK_V2) {	/* up */
			break;
		}
	}

	fill_rect(x-1,y-10,3,21);
	fill_rect(x-10,y-1,21,3);

	set_color(COLOR_BLACK);
	sprintf(buf,"\n(%d,%d) -> (%d,%d)",x,y,gx,gy);
	ts_put_string(ts,buf,0);
}

main() {
	int h;
	struct textscreen *ts;
	struct virtual_key *v;

	SCREEN_WIDTH = 240;
	SCREEN_HEIGHT = 320;
	if (!open_graph()) {
		exit(1);
	}

	set_color(COLOR_WHITE);
	clear_screen();
	set_color(COLOR_BLACK);

	v = create_virtual_key3(0,0,SCREEN_WIDTH,SCREEN_HEIGHT,
		MK_V1,MK_V0,MK_V2);
	vk_attach(NULL,v);
	ts = create_textscreen(NULL,OFFSET*2,OFFSET
			,SCREEN_WIDTH-OFFSET*4,SCREEN_HEIGHT-OFFSET*2,0);
	ts_clear(ts);
	ts_put_string(ts,"ܤǼ줿Ȥ򥿥åפƤ",0);

	draw_plus(ts,SCREEN_WIDTH/2,SCREEN_HEIGHT/2);
	draw_plus(ts,OFFSET,OFFSET);
	draw_plus(ts,OFFSET,SCREEN_HEIGHT-OFFSET);
	draw_plus(ts,SCREEN_WIDTH-OFFSET,SCREEN_HEIGHT-OFFSET);
	draw_plus(ts,SCREEN_WIDTH-OFFSET,OFFSET);

	set_color(COLOR_BLACK);
	ts_put_string(ts,"\nOK ʤ ꥿򲡤Ƥ",0);
	get_key(-1);
}

