#include "mgl2.h"
#include <time.h>
#include <sys/types.h>
#include <sys/time.h>

#ifndef NULL
#define NULL	(void *)0
#endif

#define REFRESH()	refresh()

#if 0
static long long millitime(void) {
	struct timeval n;
	gettimeofday(&n,0);
	return (n.tv_sec *1000 + n.tv_usec/1000);
}
#endif

#undef DEBUG
#define LOOP_SCROLL 	   40
#define LOOP_FILL          4
#define LOOP_DITHER 	   4
#define LOOP_FONT	   20
#define LOOP_CONV	100


static char *names[] = { "NATIVE   ",
			 "4COLOR   ",
			 "16COLOR  ",
			 "192COLOR ",
			 "FULLCOLOR"  };

#define N (sizeof(names)/sizeof(names[0]))

int results[N][10];
int result_cnt;

struct screen *screens[N];

int main() {
	static int kinds[] = { STK_NATIVE,
			       STK_GENERIC_4COLOR,
			       STK_GENERIC_16COLOR,
			       STK_GENERIC_192COLOR,
			       STK_GENERIC_FULLCOLOR };
	int i,j;
	char *name;
	struct screen *s;
	SCREEN_WIDTH = 640;
	SCREEN_HEIGHT = 240;
	open_graph();

	name = "pre-test";
	scroll_bench(name);
	fill_bench(name);
	dither_bench(name);
	font_bench(name);

	for (i=0; i<N; i++,result_cnt++) {
		name = names[i];
		if (i!=0) {
			s = create_memscreen(SCREEN_WIDTH,SCREEN_HEIGHT,NULL
				,kinds[i],0);
			if(s == NULL){
			    printf("does not support %s, and skip.\n", name);
			    continue;
			}
			push_screen(s);
printf("push_screen %08x -> %08x\n",s,current_screen);
		}
		screens[i] = current_screen;
		set_color(COLOR_LIGHTGRAY);
		clear_screen();


		scroll_bench(name);
		fill_bench(name);
		dither_bench(name);
		font_bench(name);
		printf("need_clipping = %d\n",current_screen->need_clipping);
		if (i!=0) {
			pop_screen();
printf("pop_screen -> %08x\n",current_screen);
		}
	}
	printf("           ");
	for (i=0; i<N; i++) {
		printf("%-12s",names[i]);
	}
	printf("\n");
	for (j=0; j<4; j++) {
		printf("%-9s",
			(j==0)?"scroll"
			:(j==1)?"fill"
			:(j==2)?"dither"
			:(j==3)?"font"
			:"----");
		for (i=0; i<N; i++) {
			printf(" %10.4f ",(float)results[i][j]/(480*240));
		}
		printf("\n");
	}
	for (j=0; j<N; j++) {
		for (i=0; i<N; i++) {
			convert_bench(i,j);
		}
	}

	printf("-> to    ");
	for (i=0; i<N; i++) {
		printf("%-12s",names[i]);
	}
	printf("\n");
	printf("V from\n");
	for (j=0; j<N; j++) {
		printf("%-9s",names[j]);
		for (i=0; i<N; i++) {
			printf(" %10.4f ",(float)results[j][i]/(480*240));
		}
		printf("\n");
	}
	close_graph();
	return 0;
}

scroll_bench(char *name) {
	long long s,e;
	int i,n;
	long dot;


	set_color(COLOR_DARKGRAY);
	fill_rect(30,30,SCREEN_WIDTH-60,SCREEN_HEIGHT-60);
	set_color(COLOR_DARKGRAY);
	fill_rect(60,60,SCREEN_WIDTH-120,SCREEN_HEIGHT-120);

	dot = 0;
	s = millitime();
	for (i=0; i<LOOP_SCROLL; i++) {
	bitblt(NULL,0,0,NULL,8,8,SCREEN_WIDTH-8,SCREEN_HEIGHT-8,0);
		dot += (SCREEN_WIDTH-8)*(SCREEN_HEIGHT-8);
		REFRESH();
	bitblt(NULL,0,0,NULL,16,0,SCREEN_WIDTH-16,SCREEN_HEIGHT,0);
		dot += (SCREEN_WIDTH-16)*(SCREEN_HEIGHT);
		REFRESH();
	bitblt(NULL,0,0,NULL,0,16,SCREEN_WIDTH,SCREEN_HEIGHT-16,0);
		dot += (SCREEN_WIDTH)*(SCREEN_HEIGHT-16);
		REFRESH();
	bitblt(NULL,16,0,NULL,0,0,SCREEN_WIDTH-16,SCREEN_HEIGHT,0);
		dot += (SCREEN_WIDTH-16)*(SCREEN_HEIGHT);
		REFRESH();
	bitblt(NULL,0,16,NULL,0,0,SCREEN_WIDTH,SCREEN_HEIGHT-16,0);
		dot += (SCREEN_WIDTH)*(SCREEN_HEIGHT-16);
		REFRESH();
	}
	e = millitime();
	printf("scroll-%s  %9.5f us/dot\n", name
			,(float)((double)(e - s)*1000.0/dot));
	results[result_cnt][0] = 
			(int)((double)dot*1000 / (e - s));
}

fill_bench(char *name) {
	static int cols[4] = 
		{COLOR_WHITE,COLOR_BLACK,COLOR_LIGHTGRAY,COLOR_DARKGRAY};

	long long s,e;
	int i,j,k,n;
	long dot;

	dot = 0;
	s = millitime();
	for (i=0; i<LOOP_FILL; i++) {
	    for (j=0; j<16; j++) {
		set_color(cols[j&0x3]);
		fill_rect(0,0,SCREEN_WIDTH,SCREEN_HEIGHT);
		dot += (SCREEN_WIDTH)*(SCREEN_HEIGHT);
	        REFRESH();
	    }
	}
	e = millitime();
	printf("fill-%s    %9.5f us/dot\n", name
		,(float)((double)(e - s)*1000.0/dot));
	results[result_cnt][1] = 
			(int)((double)dot*1000 / (e - s));
}

dither_bench(char *name) {
	long long s,e;
	int i,j,n;
	long dot;

	dot = 0;
	s = millitime();
	for (i=0; i<LOOP_DITHER; i++) {
	    for (j=0; j<16; j++) {
		set_color(j | COLOR_DITHER);
		fill_rect(0,0,SCREEN_WIDTH,SCREEN_HEIGHT);
		dot += (SCREEN_WIDTH)*(SCREEN_HEIGHT);
	        REFRESH();
	    }
	}
	e = millitime();
	printf("dither-%s  %9.5f us/dot\n",name
		, (float)((double)(e - s)*1000.0/dot));
	results[result_cnt][2] = 
			(int)((double)dot*1000 / (e - s));
}

font_bench(char *name) {
	long long s,e;
	int i,j,n;
	int x,y,c;
	int dot;
	static char *a = "";
	int code;

	dot = 0;
	set_color(COLOR_WHITE);
	clear_screen();

	set_color(COLOR_BLACK);
	set_font(12,0);
	code = ((a[0] & 0xff)<<8)  | (a[1] & 0xff);

	s = millitime();
	j = 0;
	for (i=0; i<LOOP_FONT; i++) {
	    for (y=0; y + 12 <= SCREEN_HEIGHT; y += 12) {
		for (x=0; x + 12 <= SCREEN_WIDTH; x += 12) {
			c = j+code;
			draw_font(x,y,c,DIR_NORTH);
			if (j > 51) j=0;
			dot++;
			j++;
		}
	    }
	    REFRESH();
	}
	e = millitime();
	printf("font-%s     %9.5f us/char\n", name
		,(float)((double)(e - s)*1000/dot));
	results[result_cnt][3] = 
			(int)((double)dot*12*12*1000 / (e - s));
}


convert_bench(int from,int to) {
	long long s,e;
	int i,j,n;
	int dot = 0;
	s = millitime();
	for (i=0; i<LOOP_CONV; i++) {
		bitblt(screens[from],0,0,screens[to],0,0
			,SCREEN_WIDTH,SCREEN_HEIGHT,0);
		dot += (SCREEN_WIDTH)*(SCREEN_HEIGHT);
	        REFRESH();
	}
	e = millitime();
	printf("convert-%s->%s     %9.5f us/dot\n", names[from],names[to]
		,(float)((double)(e - s)*1000/dot));
	results[from][to] = 
			(int)((double)dot*1000 / (e - s));
}
