/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * ʰץ󥨥ǥ
 *
 * 16x16 ޤǤΥ᡼ 192COLOR ⡼ɤȤǤޤ
 * ޤΤȤޥǤǥåȤǤޤ
 * ̹
 *
 *
 *              +-----------+
 *             |           |
 *             |Х |
 *             |           |
 *             |           |
 *             +-----------+
 *
 *                ѥå
 *
 *             
 *                  ¥
 *
 *                    ܥ
 * 
 * ڥ졼
 * ե
 *    SAVE (F7)
 *    LOAD (F6)
 * icon_c.mgr(ե̾) ɤ߹񤭹ꤷޤ
 * 
 * 
 * ⡼
 *    MODE_PEN(p)    1dot ޤ
 *    MODE_BRASH(B)  ³ƤƱΥɥåȤޤȤƽ񤭴ޤ  
 *    MODE_PICKUP(P) Хο ɤ߹ߤޤ
 *
 * Τΰư
 *    MOVE_LEFT(^H) 
 *    MOVE_DOWN(^J)
 *    MOVE_UP(^K)
 *    MOVE_RIGHT(^L)
 * ¾
 *    SHOW_GRAY(^G) 쥤Υå
 *
*/


#include "mgl2.h"
#include "mglcol.h"

/* for XPM */
#include <stdio.h>
struct xpm_context {
    struct physical_col {
	char used;
	char id;
	short col;
	char rgb[8];
    } phys_col[76];
    int col_num;
    int used_col;
    short col_ind[256];
    short xpm_ind[256];
};
/* ɤ߹ߥե̾ */
char load_name[256]="icon_c.mgr";

char *icon_edit ="\
#MGR000200160016
++++++++++++++++
++iiiiiiiiiii+++
+iiiiiiii@iiii++
+iiiiiii@B@iii++
+iiiiii@BBB@ii++
+iiiii@BBBBB@i++
+iiii@BBBBB@ii++
+iii@BBBBB@iii++
+ii@k@BBB@iiii++
+ii@kk@B@iiiii++
+ii@@kk@iiiiii++
+ii@@@@iiiiiii++
+iiiiiiiiiiiii++
++iiiiiiiiiii+++
++++++++++++++++
++++++++++++++++
";

char *icon_pen ="\
#MGR000200160016
+iiiiiiiiiii++++
iiiiiiii@iiii+++
iiiiiii@B@iii+++
iiiiii@BBB@ii+++
iiiii@BBBBB@i+++
iiii@BBBBB@ii+++
iii@BBBBB@iii+++
ii@k@BBB@iiii+++
ii@kk@B@iiiii+++
ii@@kk@iiiiii+++
ii@@@@iiiiiii+++
iiiiiiiiiiiii+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";

char *icon_brush="\
#MGR000200160016
+iiiiiiiiiii++++
iiii@@@@@iiii+++
iiii@jjj@iiii+++
iiii@jjj@iiii+++
i@@@@jjj@@@@i+++
i@jjjjjjjjj@i+++
i@jjjjjjjjj@i+++
i@@@@@@@@@@@i+++
iiEBEBEBEBEii+++
iiEBEBEBEBEii+++
iiEBEBEBEBEii+++
iEBEBEBEBEiii+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";

char *icon_pickup="\
#MGR000200160016
+iiiiiiiiiii++++
ii@@@iiiiiiii+++
ii@@@iiiiiiii+++
i@@@@@@@@@@@i+++
i@+++@@@+++@i+++
i@++@SSS@++@i+++
i@+@SSSSS@+@i+++
i@+@SSSSS@+@i+++
i@++@SSS@++@i+++
i@+++@@@+++@i+++
i@@@@@@@@@@@i+++
iiiiiiiiiiiii+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";
char *icon_load ="\
#MGR000200160016
+iiiiiiiiiii++++
i@@@@@@@@@iii+++
i@=@==;;@=@ii+++
i@=@==;;@==@i+++
i@=@==;;@==@i+++
i@=@@@@@@==@i+++
i@==r======@i+++
i@==r======@i+++
i@==r======@i+++
i@==r======@i+++
i@==rrrrr==@i+++
i@@@@@@@@@@@i+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";

char *icon_save ="\
#MGR000200160016
+iiiiiiiiiii++++
i@@@@@@@@@iii+++
i@=@==;;@=@ii+++
i@=@==;;@==@i+++
i@=@==;;@==@i+++
i@=@@@@@@==@i+++
i@===rrrr==@i+++
i@==r======@i+++
i@===rr====@i+++
i@=====r===@i+++
i@=rrrr====@i+++
i@@@@@@@@@@@i+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";

char *icon_down ="\
#MGR000200160016
+iiiiiiiiiii++++
iiii@@@@@iiii+++
iiii@TTT@iiii+++
iiii@TTT@iiii+++
iiii@TTT@iiii+++
i@@@@TTT@@@@i+++
i@TTTTTTTTT@i+++
ii@TTTTTTT@ii+++
iii@TTTTT@iii+++
iiii@TTT@iiii+++
iiiii@T@iiiii+++
iiiiii@iiiiii+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";
char *icon_up ="\
#MGR000200160016
+iiiiiiiiiii++++
iiiiii@iiiiii+++
iiiii@T@iiiii+++
iiii@TTT@iiii+++
iii@TTTTT@iii+++
ii@TTTTTTT@ii+++
i@TTTTTTTTT@i+++
i@@@@TTT@@@@i+++
iiii@TTT@iiii+++
iiii@TTT@iiii+++
iiii@TTT@iiii+++
iiii@@@@@iiii+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";
char *icon_left ="\
#MGR000200160016
+iiiiiiiiiii++++
iiiiii@@iiiii+++
iiiii@T@iiiii+++
iiii@TT@iiiii+++
iii@TTT@@@@@i+++
ii@TTTTTTTT@i+++
i@TTTTTTTTT@i+++
ii@TTTTTTTT@i+++
iii@TTT@@@@@i+++
iiii@TT@iiiii+++
iiiii@T@iiiii+++
iiiiii@@iiiii+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";
char *icon_right ="\
#MGR000200160016
+iiiiiiiiiii++++
iiiii@@iiiiii+++
iiiii@T@iiiii+++
iiiii@TT@iiii+++
i@@@@@TTT@iii+++
i@TTTTTTTT@ii+++
i@TTTTTTTTT@i+++
i@TTTTTTTT@ii+++
i@@@@@TTT@iii+++
iiiii@TT@iiii+++
iiiii@T@iiiii+++
iiiii@@iiiiii+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";

char *icon_gray ="\
#MGR000200160016
+iiiiiiiiiii++++
i@@@@@@@@@@@i+++
i@@@@@@****@i+++
i@@@@@@****@i+++
i@@@@@@****@i+++
i@@@@@@****@i+++
i@@@@@@@@@@@i+++
i@++++@....@i+++
i@++++@....@i+++
i@++++@....@i+++
i@++++@....@i+++
i@@@@@@@@@@@i+++
+iiiiiiiiiii++++
++++++++++++++++
++++++++++++++++
++++++++++++++++
";

#ifndef NULL
#define NULL	(void *)0
#endif

/* icon size (16 - 32)
 * 륢Υꤹ롣
 * 16x16 -> ICON_SIZE=16
 * 32x32 -> ICON_SIZE=32
 */
#define ICON_SIZE 20
#define ICON_X	(palette_x + 13*cw)
#define ICON_Y	(palette_y + 2*cw)

#define BORDER_W  4
#define CANVAS_WN ICON_SIZE	/* x cw */
#define CANVAS_HN ICON_SIZE	/* x cw */
#define PALLET_WN 16
#define PALLET_HN  6

#define ICON_W	13
#define ICON_H	13

#define ICON_WN	9

int canvas_x;
int canvas_y;
int palette_x;
int palette_y;
int icon_x;
int icon_y;

int cw;		/* cell width /height */
int pressed;

#define MK_MODE		MK_V0 + 1
#define MK_LOAD		MK_F6 /*MK_V0 + 2*/
#define MK_SAVE		MK_F7 /*MK_V0 + 3*/
#define MK_GRAY		('g' & 0x1f) /*MK_V0 + 4*/

#define MK_MOUSE_DOWN	MK_V0 + 5
#define MK_MOUSE_MOVE	MK_V0 + 6
#define MK_MOUSE_UP	MK_V0 + 7

#define MK_MOVE_UP	('k' & 0x1f)
#define MK_MOVE_DOWN	('j' & 0x1f)
#define MK_MOVE_LEFT	('h' & 0x1f)
#define MK_MOVE_RIGHT	('l' & 0x1f)

#define MK_CANVAS_MIN	(MK_V0 + 10)
#define MK_CANVAS(x,y)	(MK_CANVAS_MIN + (y)*ICON_SIZE + (x))
#define MK_CANVAS_MAX	MK_CANVAS(ICON_SIZE,6)
#define MK_CANVAS_X(v)	((v - MK_CANVAS_MIN)%ICON_SIZE)
#define MK_CANVAS_Y(v)	((v - MK_CANVAS_MIN)/ICON_SIZE)


fix_xy(int xs,int ys) {
	int i,j,my;
	cw = (ys - ICON_H - BORDER_W*2)/(CANVAS_HN + PALLET_HN);
	i = (xs - BORDER_W*2) / (CANVAS_WN);
	if (i < cw) cw = i;
//printf("cw =  %d\n",cw);
	canvas_x = palette_x = icon_x = (xs - (CANVAS_WN*cw))/ 2;
	if (CANVAS_WN*cw < ICON_SIZE*8)
		icon_x = 10;
	my = (ys - ICON_H - (CANVAS_HN + PALLET_HN)*cw - BORDER_W*2)/2;

	canvas_y = BORDER_W;
	palette_y = BORDER_W + my + CANVAS_HN*cw;
	icon_y = BORDER_W + my *2 + (CANVAS_HN+PALLET_HN)*cw;
//printf("canvas_x = %d\n",canvas_x);
//printf("canvas_y = %d\n",canvas_y);
//printf("palette_y = %d\n",palette_y);
//printf("icon_y = %d\n",icon_y);
}


int icon16[ICON_SIZE][ICON_SIZE];

#define MODE_PEN	0
#define MODE_BRUSH	1
#define MODE_PICKUP	2

int cur_mode = MODE_PEN;
int cur_col = COLOR_WHITE;
int palette[16][6];

struct virtual_key *vk_canvas;

put_canvas(int x,int y, int col) {
	int xx = x;
	int yy = y;

 	x = canvas_x + (x * cw);
	y = canvas_y + (y * cw);

	if (!vk_canvas) {
		vk_canvas = create_virtual_key3( canvas_x, canvas_y,
										 cw*ICON_SIZE, cw*ICON_SIZE,
										 MK_MOUSE_DOWN,MK_MOUSE_MOVE,MK_MOUSE_UP);
		vk_attach(NULL,vk_canvas);
	}
	icon16[yy][xx] = col;
	set_color(col);
	fill_rect(x,y,cw,cw);
	col &= 0xf;
	if (col > 7) col -= 5;
	else  col += 5;
	set_color(col);
	draw_rect(x,y,cw+1,cw+1);
}

put_icon() {
	int x,y;

	refresh();
	x = ICON_X;
	y = ICON_Y;
	put_pixstream_rect( x, y, &icon16[0][0],
						ICON_SIZE*ICON_SIZE,
						DIR_NORTH, ICON_SIZE);
	refresh();
}

dump_icon() {
	int x,y;
	struct screen *s;

	x = ICON_X;
	y = ICON_Y;
	s = create_subscreen(NULL,x,y,ICON_SIZE,ICON_SIZE);
	if (!s) return;
	write_screen_mgr("icon_c",s,STK_GENERIC_192COLOR);
	write_screen_mgr("icon_m",s,STK_GENERIC_4COLOR);
	free_screen(s);
}

load_icon() {
	int x,y;
	int i,j,c;
	struct screen *s;
	s = read_screen_mgr( load_name );
	if (!s) return;
	if ((s->width > ICON_SIZE ) || (s->height > ICON_SIZE)) {
		free_screen(s);
		return;
	}
	x = ICON_X;
	y = ICON_Y;
	bitblt(NULL,x,y,s,0,0,s->width,s->height,0);
	for (i=0; i<ICON_SIZE; i++) for (j=0; j<ICON_SIZE; j++) {
		c = get_pixel(x+i,y+j,0);
		put_canvas(i,j,c);
	}
	free_screen(s);
}

struct screen *read_screen_xpm(char *name, int kind)
{
  struct xpm_context xc;
  struct screen *s;
  int i,j,x,y,w,h,c,d;
  int col,r,g,b;
  char *p;
  char rgb[32];
  FILE *fd;
  char buf[256];

  /* file open */
  fd = fopen(name,"r");
  if(fd == NULL){
	perror("open");
	return(NULL);
  }
  /* set 0 */
  for (c=0; c<256; c++) {
	xc.xpm_ind[c] = 0;
  }
  /* read size */
  while ( fgets(buf,256,fd) ) {
	if ( buf[0]=='"' ) break;
  }
  if (!buf) return NULL;
  //  printf("%s",buf);
  if (sscanf(buf,"\"%d %d %d %d\"",&w,&h,&xc.col_num,&c) != 4) {
	return NULL;
  }
  if ((c != 1) || (xc.col_num > 76)) return NULL;
  /* COLORɤ߹ */
  j=0;
  while ( fgets(buf,256,fd) ) {
	if (buf[0]!='"') continue;
	if (!buf) return NULL;
	if ( !strstr(buf,"None") ) {
	  //if (sscanf(xpm[idx],"%c %c %7s",&c,&d,&rgb) != 3) return NULL;
	  {	/* sscanf ޤʤΤ...(^^; */
		int m=0;
		while( buf[m]!='"' ) m++;
		m++;
		c = buf[m++];
		if ( buf[m]!=' ' && buf[m]!='\t' ) m++;
		while( buf[m]==' ' || buf[m]=='\t' ) m++;
		d = buf[m++];
		while( buf[m]!='#' ) m++;
		sprintf( rgb, "%.7s", &buf[m] );
		//  printf("%s\n",rgb);
	  }
	  if (d != 'c') return NULL;
	  if (strlen(rgb) != 7) return NULL;
	  if ((strlen(rgb) != 7) || (rgb[0] != '#') ) return NULL;
	  strcpy(xc.phys_col[j].rgb,rgb);
	  rgb[2] = 0;
	  rgb[0] = xc.phys_col[j].rgb[1];
	  rgb[1] = xc.phys_col[j].rgb[2];
	  if (sscanf(rgb,"%02x",&r) != 1) return NULL;
	  rgb[0] = xc.phys_col[j].rgb[3];
	  rgb[1] = xc.phys_col[j].rgb[4];
	  if (sscanf(rgb,"%02x",&g) != 1) return NULL;
	  rgb[0] = xc.phys_col[j].rgb[5];
	  rgb[1] = xc.phys_col[j].rgb[6];
	  if (sscanf(rgb,"%02x",&b) != 1) return NULL;
	  //printf("%c(%d) %02x%02x%02x\n",c,c,r,g,b);
	  r >>= 4;
	  g >>= 4;
	  b >>= 4;
	  col = packRGB(r,g,b);
	  col = mc_from_rgb(col);
	  
	  xc.phys_col[j].id = c;
	  xc.phys_col[j].col = col;
	  
	  xc.xpm_ind[c & 0xff] = j;
	}
	j++;
	if (j>=xc.col_num) break;
  }
  s = create_memscreen(w,h,NULL,kind,0);
  if (!s) return NULL;
  push_screen(s);
  /* DATAɤ߹ */
  y=0;
  while ( fgets(buf,256,fd)!=NULL ) {
	if (buf[0]!='"') continue;
	if (y>h) break;
	p = &buf[1];
	for (x=0; (x < w) && (*p) ; x++,p++) {
	  col = xc.phys_col[xc.xpm_ind[*p & 0xff]].col;
	  put_pixel(x,y,col);
	}
	y++;
  }
  //printf("read done w %d h %d\n",x,y);
  pop_screen();
  return s;
}

load_xpm() {
    int x,y;
	int i,j,c;
	struct screen *s;
	s = read_screen_xpm( "icon_x.xpm", STK_GENERIC_192COLOR );
	if (!s) return;
	if ((s->width > ICON_SIZE ) || (s->height > ICON_SIZE)) {
		free_screen(s);
		return;
	}
	x = ICON_X;
	y = ICON_Y;
	bitblt(NULL,x,y,s,0,0,s->width,s->height,0);
	for (i=0; i<ICON_SIZE; i++) for (j=0; j<ICON_SIZE; j++) {
		c = get_pixel(x+i,y+j,0);
		put_canvas(i,j,c);
	}
	free_screen(s);
}

move_icon(int c) {
	int x,y;

	switch(c) {
	    case MK_MOVE_UP:
	      for (x=0; x<ICON_SIZE; x++) for (y=0; y<ICON_SIZE-1; y++) {
		icon16[y][x] = icon16[y+1][x];
		put_canvas(x,y,icon16[y][x]);
	      }
	      break;
	    case MK_MOVE_LEFT:
	      for (x=0; x<ICON_SIZE-1; x++) for (y=0; y<ICON_SIZE; y++) {
		icon16[y][x] = icon16[y][x+1];
		put_canvas(x,y,icon16[y][x]);
	      }
	      break;
	    case MK_MOVE_DOWN:
	      for (x=ICON_SIZE-1; x>=0; x--) for (y=ICON_SIZE-1; y>=1; y--) {
		icon16[y][x] = icon16[y-1][x];
		put_canvas(x,y,icon16[y][x]);
	      }
	      break;
	    case MK_MOVE_RIGHT:
	      for (x=ICON_SIZE-1; x>=1; x--) for (y=ICON_SIZE-1; y>=0; y--) {
		icon16[y][x] = icon16[y][x-1];
		put_canvas(x,y,icon16[y][x]);
	      }
	    break;
	}
	put_icon();
}

rotate180() {
	int x,y;
	int buf[ICON_SIZE][ICON_SIZE];

	for (x=0; x<ICON_SIZE; x++) for (y=0; y<ICON_SIZE; y++) {
	  buf[y][x] = icon16[y][x];
	}
	for (x=0; x<ICON_SIZE; x++) for (y=0; y<ICON_SIZE; y++) {
	  icon16[y][x] = buf[ICON_SIZE-1-y][ICON_SIZE-1-x];
	  put_canvas(x,y,icon16[y][x]);
	}
	put_icon();
}

show_gray() {
	int x,y;
	int i,j,c;
	int save[ICON_SIZE][ICON_SIZE];

	x = ICON_X;
	y = ICON_Y;

	for (i=0; i<ICON_SIZE; i++) for (j=0; j<ICON_SIZE; j++) {
		c = get_pixel(x+i,y+j,0);
		save[i][j] = c;
		c &= 0xf;
		put_canvas(i,j,c);
	}
	put_icon();
	get_key(-1);
	for (i=0; i<ICON_SIZE; i++) for (j=0; j<ICON_SIZE; j++) {
		c = save[i][j];
		put_canvas(i,j,c);
	}
	put_icon();
}

paint_icon(int xx,int yy,int col) {
	int x,y;
	int nextbreak;
	int old_col;
	int mark[ICON_SIZE][ICON_SIZE]; /* 0: none 1: check_next 2: done */

	old_col = icon16[yy][xx];
	for (x=0; x<ICON_SIZE; x++) for (y=0; y<ICON_SIZE; y++) {
		mark[y][x] = 0;
	}
	mark[yy][xx] = 1;
	for (;;) {
	    nextbreak = 1;
	    for (x=0; x<ICON_SIZE; x++) for (y=0; y<ICON_SIZE; y++) {
		if (mark[y][x] == 1) {
			icon16[y][x] = col;
			mark[y][x] = 2;
			if ((y > 0) && (mark[y-1][x] == 0) 
			    && (old_col == icon16[y-1][x])) {
				mark[y-1][x] = 1;
				nextbreak = 0;
			}
			if ((x > 0) && (mark[y][x-1] == 0)
			    && (old_col == icon16[y][x-1])) {
				mark[y][x-1] = 1;
				nextbreak = 0;
			}
			if ((y < 15) && (mark[y+1][x] == 0)
			    && (old_col == icon16[y+1][x])) {
				mark[y+1][x] = 1;
				nextbreak = 0;
			}
			if ((x < 15) && (mark[y][x+1] == 0)
			    && (old_col == icon16[y][x+1])) {
				mark[y][x+1] = 1;
				nextbreak = 0;
			}
	        }
	    }
	    if (nextbreak) break;
	}
	for (x=0; x<ICON_SIZE; x++) for (y=0; y<ICON_SIZE; y++) {
		put_canvas(x,y,icon16[y][x]);
	}
	put_icon();
}


set_palette() {
	int hue,sat,bri,col;
	int i,j;
	int x,y,xx,yy;
	struct virtual_key *v;

	sat = bri = 15;
	for (hue = 0; hue < 12; hue++) {
	    x = palette_x + hue * cw;
	    y = palette_y;
	    xx = hue;
	    yy =  0;
	    for (i=3; i>0; i--) {
	      for (j = 0; j < 3; j++) {
		bri = i*5;
		sat = bri - j * 5;
		if (sat > 0) {
			col = packMC(hue,sat,bri);
			set_color(col);
			fill_rect(x,y,cw-1,cw-1);
			set_color(col ^ 0xf);
			draw_rect(x,y,cw-1,cw-1);
			v = create_virtual_key(x,y,cw,cw ,MK_CANVAS(xx,yy));
			vk_attach(NULL,v);
			palette[xx][yy] = col; 
			y += cw;
			yy++;
		}
	      }
	    }
	}
	hue = sat = 0;
	for (i=0; i<4; i++) {
		bri = i*5;
		x = palette_x + 12*cw + i*cw;
		y = palette_y;
		xx = i+12;
		yy = 0;
		v = create_virtual_key(x,y,cw,cw ,MK_CANVAS(xx,yy));
		vk_attach(NULL,v);
		col = packMC(hue,sat,bri);
		set_color(col);
		fill_rect(x,y,cw-1,cw-1);
		set_color(col ^ 0xf);
		draw_rect(x,y,cw-1,cw-1);
		palette[xx][yy] = col; 
	}
}

show_mode() {
	int x,y;
	char *p;
	struct screen *s;

	x = icon_x + ICON_SIZE;
	y = icon_y;

	switch(cur_mode) {
	default:
	case MODE_PEN:    p = icon_pen;    break;
	case MODE_BRUSH:  p = icon_brush;  break;
	case MODE_PICKUP: p = icon_pickup; break;
	}
	s = conv_screen_from_mgr(p,STK_GENERIC_192COLOR);
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
}

show_col() {
	int x,y;

	x = icon_x;
	y = icon_y;

	set_color(cur_col);
	fill_rect(x,y,ICON_W,ICON_H);
	set_color(cur_col ^ 0xf);
	draw_rect(x,y,ICON_W,ICON_H);
}

set_button() {
	int i;
	int x,y,c;
	struct screen *s;
	struct virtual_key *v;

	show_col();
	x = icon_x + ICON_SIZE;
	y = icon_y;

	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_MODE);
	vk_attach(NULL,v);
	show_mode();
	s = conv_screen_from_mgr(icon_load,STK_GENERIC_192COLOR);
	x += 16;
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_LOAD);
	vk_attach(NULL,v);

	s = conv_screen_from_mgr(icon_save,STK_GENERIC_192COLOR);
	x += 16;
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_SAVE);
	vk_attach(NULL,v);

	s = conv_screen_from_mgr(icon_gray,STK_GENERIC_192COLOR);
	x += 16;
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_GRAY);
	vk_attach(NULL,v);

	s = conv_screen_from_mgr(icon_down,STK_GENERIC_192COLOR);
	x += 16;
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_MOVE_DOWN);
	vk_attach(NULL,v);

	s = conv_screen_from_mgr(icon_up,STK_GENERIC_192COLOR);
	x += 16;
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_MOVE_UP);
	vk_attach(NULL,v);

	s = conv_screen_from_mgr(icon_left,STK_GENERIC_192COLOR);
	x += 16;
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_MOVE_LEFT);
	vk_attach(NULL,v);

	s = conv_screen_from_mgr(icon_right,STK_GENERIC_192COLOR);
	x += 16;
	bitblt(NULL,x,y,s,0,0,ICON_W,ICON_H,0);
	free_screen(s);
	v = create_virtual_key(x,y,ICON_W,ICON_H,MK_MOVE_RIGHT);
	vk_attach(NULL,v);
}

main(int argc,char *argv[]) {
	int x,y,col;
	int c;
	int xx,yy;
	int new_x,new_y;

#if 0
	SCREEN_WIDTH  = 160;
	SCREEN_HEIGHT = (240-16);
#else
	SCREEN_WIDTH  = 240;
	SCREEN_HEIGHT = (320-16);
#endif
	while( 1 ){
	  extern char *optarg;
	  int opt;
	  if( (opt=getopt(argc,argv,"mf:")) == EOF ) break;
	  switch( opt ) {
		/* ߥ˥ץ */
		case 'm':
		  mgl_apli_type = AT_MINIAPLI;
		  break;
		/* ɤ߹ߥե */
		case 'f':
		  sprintf( load_name, "%s", optarg );
		  break;
		default: break;
	  }
	}
	if (!open_graph()) {
		printf("initialize error\n");
		exit(1);
	}
	set_icon(icon_edit,"icon edit");
	fix_xy(SCREEN_WIDTH,SCREEN_HEIGHT);
	set_color(COLOR_LIGHTGRAY);
	fill_rect(0,0,SCREEN_WIDTH,SCREEN_HEIGHT);

	for (x=0; x<ICON_SIZE; x++) for (y=0; y<ICON_SIZE; y++) {
		icon16[y][x] = COLOR_WHITE;
		put_canvas(x,y,icon16[y][x]);
	}
	set_palette();
	set_button();
	load_icon();
	while (((c = get_key(-1)) != 'q') ) {
		if (c == MK_MODE) {
			cur_mode = (cur_mode + 1)%3;
			show_mode();
		} else if (c == 'p') {
			cur_mode = MODE_PEN;
			show_mode();
		} else if (c == 'B') {
			cur_mode = MODE_BRUSH;
			show_mode();
		} else if (c == 'P') {unsigned char
			cur_mode = MODE_PICKUP;
			show_mode();
		} else if (c == 'r') {
			rotate180();
		} else if (c == 'x') {
			load_xpm();
		} else if ((c == MK_GRAY) || (c == 'M')) {
			show_gray();
		} else if (c == MK_F8) {
			write_screen_mgr("screen_c",NULL,STK_GENERIC_192COLOR);
			write_screen_mgr("screen_m",NULL,STK_GENERIC_4COLOR);
		} else if (c == MK_F7) {
			dump_icon();
		} else if (c == MK_F6) {
			load_icon();
		} else if ((c == MK_MOVE_LEFT) || (c == MK_MOVE_RIGHT) 
		          || (c == MK_MOVE_UP) || (c == MK_MOVE_DOWN)) {
			move_icon(c);
		} else if ((c >= MK_CANVAS_MIN) && ( c < MK_CANVAS_MAX)) {
			xx = MK_CANVAS_X(c);
			yy = MK_CANVAS_Y(c);
			cur_col = palette[xx][yy];
			show_col();
		} else if (c == MK_MOUSE_DOWN) { /* down */
			pressed = 1;
			xx = vk_x/cw;
			yy = vk_y/cw;
			if (cur_mode == MODE_BRUSH) {
				paint_icon(xx,yy,cur_col);
				continue;
			} else if (cur_mode == MODE_PICKUP) {
				cur_col = icon16[yy][xx];
				cur_mode = MODE_PEN;
				show_col();
				show_mode();
			}
			put_canvas(xx,yy,cur_col);
		} else if (pressed && (c == MK_MOUSE_MOVE)) { /* move */
			new_x = vk_x/cw;
			new_y = vk_y/cw;
			if (cur_mode != MODE_PEN) continue;
			if ((new_x != xx) || (new_y != yy)) {
				xx = new_x;
				yy = new_y;
				put_canvas(xx,yy,cur_col);
			}
		} else if ( c == MK_MOUSE_UP) {
			pressed = 0;
			if (cur_mode != MODE_PEN) continue;
			put_icon();
		}
	}
}
