INSTALL=install
MAKEDEPEND=sh ../conf/mkdep.sh
INCS_X11= -I/usr/X11R6/include

# set ELFENV in config.mk
# a.out env. -> 0
# ELF env.   -> 1
ifndef ELFENV
ELFENV=1
endif

ifeq (${ELFENV},1)
LIBS_X11= -L/usr/X11R6/lib -Wl,-rpath,/usr/X11R6/lib -lX11
else
LIBS_X11= -L/usr/X11R6/lib -lX11
endif
ifeq (${SUPPORT_X_KEYMOUSE},y)
LIBS_X11 += -lXtst -lXext
endif

INCS_CONS= -I/usr/pkg/include
ifeq (${ELFENV},1)
    LIBS_CONS= -L/usr/pkg/lib -Wl,-rpath /usr/pkg/lib
else
    LIBS_CONS= -L/usr/pkg/lib
endif

ifndef LIBS_IM
INCS_IM = -I/usr/pkg/include
    ifeq (${ELFENV},1)
    LIBS_IM = -L/usr/pkg/lib -Wl,-rpath,/usr/pkg/lib -lcanna
    else
    LIBS_IM = -L/usr/pkg/lib -lcanna
    endif
endif

SHLIB_CFLAGS=-fpic -DPIC
ifeq (${ELFENV},1)
    SHLIB_LDFLAGS = -shared
    SHLIB_LD=${CC}
    MGLPIC_CFLAGS= ${SHLIB_CFLAGS}
    MGLPIC_LDFLAGS= ${SHLIB_LDFLAGS} -Wl,-soname,libmgl2.so.${VER}
else
    SHLIB_LDFLAGS = -Bshareable
    SHLIB_LD=${LD}
    MGLPIC_CFLAGS= ${SHLIB_CFLAGS}
    MGLPIC_LDFLAGS= ${SHLIB_LDFLAGS}
endif
MGLPIC_LD= ${SHLIB_LD}

DEFAULT_LIBS = 

ifdef SERVER_X11
DEFAULT_LIBS += ${LIBS_X11}
endif
ifdef SERVER_CONS
DEFAULT_LIBS += ${LIBS_CONS}
endif

ifdef IM_STATIC
DEFAULT_LIBS += ${LIBS_IM}
endif

LIBS_MDATE= -lkvm

ifdef MGL_INSTALLED
	INCS_MGL = -I${MGL_HEADER_DIR}
	ifeq (${ELFENV},1)
	LIBS_MGL = -L${MGL_LIB_DIR} -L/usr/X11R6/lib -Wl,-rpath,/usr/pkg/lib -L/usr/pkg/lib  -lmgl2
	else
	LIBS_MGL = -L${MGL_LIB_DIR} -L/usr/X11R6/lib -L/usr/pkg/lib  -lmgl2	
	endif
else
	INCS_MGL = -I${SRCDIR}
	ifeq (${ELFENV},1)
	LIBS_MGL = -L${SRCDIR} -rdynamic -Wl,-rpath,/usr/X11R6/lib -L/usr/X11R6/lib -Wl,-rpath,/usr/pkg/lib -L/usr/pkg/lib -lmgl2 
	else
	LIBS_MGL = -L${SRCDIR} -L/usr/X11R6/lib -L/usr/pkg/lib -lmgl2 
	endif
endif

ifneq (${ELFENV},1)
    SYM_PREFIX=yes
endif

PRIV_ROOT=	-o root -g bin -m 4555
PRIV_BIN=	-o bin -g bin -m 555
PRIV_KMEM=	-o bin -g kmem -m 2555
PRIV_FILE=	-o bin -g bin -m 444


