#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/file.h>
#include <dev/wscons/wsconsio.h>

print_calib(calib)
        struct wsmouse_calibcoords *calib;
{
        int i;

	printf("%d %d %d %d %d "
		, calib->minx
        	, calib->miny
		, calib->maxx
        	, calib->maxy
        	, calib->samplelen
		);

        for (i = 0; i < calib->samplelen; i++) {
		printf("%d %d %d %d "
                	, calib->samples[i].rawx
                	, calib->samples[i].rawy
                	, calib->samples[i].x
                	, calib->samples[i].y
			);
        }
	printf("\n");
}

scan_calib(calib, argc, argv)
        struct wsmouse_calibcoords *calib;
	int argc;
	char *argv[];
{
	int i,j;
	int dat;
	if (argc < 5) return 2; /* mismatch number of parameters */
	for (i=0; i<argc; i++) {
		if (sscanf(argv[i],"%d",&dat) != 1) {
			return 1; /* parameter format error */
		}
		switch(i) {
		case 0:	calib->minx = dat; break;
		case 1:	calib->miny = dat; break;
		case 2:	calib->maxx = dat; break;
		case 3:	calib->maxy = dat; break;
		case 4:	calib->samplelen = dat;
			if (5 + dat*4 != argc) {
				return 2; /* mismatch number of parameters */
			}
			j = 0;
			break;
		default:
			switch((i-5)% 4) {
			case 0: calib->samples[j].rawx = dat; break;
			case 1: calib->samples[j].rawy = dat; break;
			case 2: calib->samples[j].x = dat; break;
			case 3: calib->samples[j++].y = dat; break;
			}
		}
	}
	return 0;
}


#define CALIB_LOAD	1
#define CALIB_STORE	2

main(argc,argv)
	int argc;
	char *argv[];
{
        struct wsmouse_calibcoords resetcalib, newcalib, savecalib;
        int i, c, r, fd;
	int mode = CALIB_LOAD;

	while ((c = getopt(argc,argv,"s")) != -1) {
		switch(c) {
		case 's':	/* store data */
			mode = CALIB_STORE;
			break;
		}
	}
	if (mode == CALIB_LOAD) {
            if ((fd = open("/dev/wsmouse0", O_RDONLY)) < 0) {
                perror("read open");
                exit(1);
            }
            if (ioctl(fd, WSMOUSEIO_GCALIBCOORDS, &savecalib)) {
                perror("WSMOUSEIO_GCALIBCOORDS");
                exit(1);
            }
	    print_calib(&savecalib);
	    exit(0);
	}
#ifdef SETTEST
	r = scan_calib(&newcalib,argc-optind,argv+optind);
	printf("%d\n",r);
	if (r == 0) print_calib(&newcalib);
	exit(0);
	
#endif
	if ((fd = open("/dev/wsmouse0", O_RDWR)) < 0) {
		perror("read/write open");
		exit(1);
	}
	if (ioctl(fd, WSMOUSEIO_GCALIBCOORDS, &savecalib)) {
                perror("WSMOUSEIO_GCALIBCOORDS");
                exit(1);
	}
	if (scan_calib(&newcalib,argc-optind,argv+optind)) {
		errno = EINVAL;
                perror("(1)WSMOUSEIO_SCALIBCOORDS");
                exit(1);
	}
        memset(&resetcalib, 0, sizeof(resetcalib));
        resetcalib.samplelen = WSMOUSE_CALIBCOORDS_RESET;
        if (ioctl(fd, WSMOUSEIO_SCALIBCOORDS, &resetcalib)) {
                perror("(2)WSMOUSEIO_SCALIBCOORDS");
                exit(1);
	}
	if (ioctl(fd, WSMOUSEIO_SCALIBCOORDS, &newcalib) == 0) {
		exit(0);
	}
        if (ioctl(fd, WSMOUSEIO_SCALIBCOORDS, &savecalib)) {
                perror("(3)WSMOUSEIO_SCALIBCOORDS");
                exit(2); /* can't recover */
        }
        exit(1);
}
