/*
                       Editor Find In Pages Dialog
 */

#ifndef EDITORFIP_H
#define EDITORFIP_H

#include <gtk/gtk.h>


/* typedef struct _editor_fip_struct	editor_fip_struct; */
typedef struct _editor_fip_item_struct	editor_fip_item_struct;
#define EDITOR_FIP_ITEM(p)		((editor_fip_item_struct *)(p))


/*
 *	Find In Pages Dialog:
 */
struct _editor_fip_struct {

	gboolean	initialized,
			map_state,
			processing;

	gpointer	core_ptr;
	gpointer	editor_ptr;

	GtkWidget	*toplevel,
			*main_vbox,
			*find_combo;

	/* Buttons on right column */
	GtkWidget	*find_btn,
			*clear_btn,
			*stop_btn,
			*close_btn;

	gint		stop_find_count;

	/* Search options */
	GtkWidget	*match_all_radio,
			*match_any_radio,
			*match_phrase_radio;
	GtkWidget	*case_sensitive_toggle;	/* Case sensitive if togged */

	/* Search results put into this clist, it has 4 columns which
	 * are for; excerpt, type, name (header or section's name), and
	 * manual page name.
	 */
	GtkWidget	*results_clist;
	gint		selected_result;		/* Can be -1 */
	GtkWidget *results_menu;

	/* Important menu items on results menu */
	GtkWidget	*goto_mi;

	/* Goto selected result button */
	GtkWidget	*goto_btn;

	GtkWidget	*status_bar_dock,
			*status_bar_toplevel,
			*status_bar_progress,
			*status_bar_label;

	gfloat		status_bar_progress_pos_last;

};


/*
 *	Find In Pages Dialog Item:
 */
struct _editor_fip_item_struct {

	editor_fip_struct	*editor_fip;
	GtkCList	*clist;

	/* Pointer to the matched branch node on the layout_ctree on
	 * editor that was searched through */
	GtkCTreeNode	*found_branch;

	/* This will be used for matching branch data on the editor
	 * when the user wants to `go to' the matched result. This is
	 * better since the found_branch may get deleted and matching
	 * by the branch's data seems to work out better */
	gpointer	branch_data;

	/* Matched text position, can be -1 for n/a */
	gint		text_sel_start,
			text_sel_end;

	/* Matched line number, can be -1 for n/a */
	gint		line_num;

};


extern gint EditorFIPAddItem(
        editor_fip_struct *fip,
        const gchar *excerpt,
	gint line_num,
        const gchar *name,
        const gchar *manual_page,
        GtkCTreeNode *found_branch,
	gpointer branch_data,
        gint text_sel_start, gint text_sel_end
);
extern void EditorFIPItemDelete(editor_fip_item_struct *item);

extern void EditorFIPSetBusy(editor_fip_struct *fip);
extern void EditorFIPSetReady(editor_fip_struct *fip);

extern editor_fip_struct *EditorFIPNew(void *core_ptr, void *editor_ptr);
extern void EditorFIPUpdateMenus(editor_fip_struct *fip);
extern void EditorFIPSetStatusMessage(
	editor_fip_struct *fip, const gchar *mesg
);
extern void EditorFIPSetStatusProgress(
	editor_fip_struct *fip, gfloat percent
);
extern void EditorFIPReset(editor_fip_struct *fip, gboolean need_unmap);
extern void EditorFIPMap(editor_fip_struct *fip);
extern void EditorFIPUnmap(editor_fip_struct *fip);
extern void EditorFIPDelete(editor_fip_struct *fip);






#endif	/* EDITORFIP_H */
