/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef _FILETREE_H_
#define _FILETREE_H_

#include "lopster.h"

typedef file_node_t* (*file_node_function_t)(file_node_t*, void*);

void
file_tree_init(file_tree_t* tree, char* name, char* des);
void
file_tree_destroy(file_tree_t* tree);
void
file_node_init(file_node_t* node, char* name);
file_node_t*
file_node_search_file(file_node_t* node, file_t* file);
void
file_tree_node_remove(file_tree_t* tree, file_node_t* node);
void
file_tree_node_show(file_tree_t* tree, file_node_t* child);
file_node_t*
file_node_insert_file(file_tree_t* tree, file_node_t* node,
		      file_t* file, gboolean check_dup);
file_node_t*
file_tree_insert_file(file_tree_t* tree, file_t * file);
file_node_t*
file_tree_insert_folder(file_tree_t* tree, file_node_t* parent, 
			char* folder, int check);
void 
file_tree_show(file_tree_t* tree, int mediatype, int show_time);
void
file_tree_calc_matrix(file_tree_t* tree);
file_node_t*
file_node_next(file_node_t* node);
void 
file_tree_clear_files(file_tree_t *tree);
void
file_tree_search(file_tree_t *tree, search_t *search, int* cnt);
file_node_t*
file_node_action(file_tree_t* tree, file_node_t* node, 
		 file_node_function_t action, void* data);
char* 
file_node_get_folder(file_node_t* node, int* size);
file_node_t*
file_tree_search_filename(file_tree_t* tree, char* filename);
file_node_t*
file_tree_search_winname(file_tree_t* tree, file_node_t* node, char* fname);


int
on_file_tree_search_changed(GtkWidget * widget, void* user_data);
void
on_file_tree_select_row(GtkCTree *ctree, GList *node,
			gint column, gpointer user_data);
void
on_file_select_row(GtkCList *clist, gint row, gint column,
		   GdkEvent *event, gpointer user_data);
void 
on_file_tree_files1_clicked(GtkButton * button,
			    gpointer user_data);
void 
on_file_tree_files2_clicked(GtkButton * button,
			    gpointer user_data);


void
download_file_node(file_tree_t* tree, file_node_t* node,
		   char* dir, int withdir);
void 
file_node_destroy(file_tree_t* tree, file_node_t* node);
GList*
file_tree_search_filesize(file_tree_t* tree, file_t* file);
void
file_tree_mark(file_tree_t* tree, int when);
void
file_node_update(file_tree_t* tree, file_node_t* node,
		 int p, int c);
void
file_node_show(file_tree_t* tree, file_node_t* child, int check);

gboolean
on_tree_motion_notify_event(GtkWidget * widget,
			    GdkEventMotion * event, gpointer user_data);
gboolean
on_tree_leave_notify_event(GtkWidget * widget,
			   GdkEventCrossing * event, gpointer user_data);
void
file_tree_release_page(file_tree_t* tree);

#endif
