/***************************************************************************
	tuning.h - Gameplay tuning values

    begin                : 28 Apr 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

// All speed values are in pixels per millisecond unless otherwise specified

// ----------------------------- Objects -------------------------------------
// Maximum amount of each type of object allowed at one time
#define	MAX_INTERFACE_OBJECTS 3		// Max interface objects allowed
#define MAX_BLOCKS_X 20				// Max blocks across
#define MAX_BLOCKS_Y 20				// Max blocks down
#define MAX_BG_OBJECTS 30			// Max background objects allowed

#define OBJ_WIDTH 30				// Width of sprites on screen
#define OBJ_HEIGHT OBJ_WIDTH		// Height of sprites on screen

// ------------------------------- Blocks ------------------------------------
#define MAINCHAR_PAUSE_TIME 30
#define STANDARD_PAUSE_TIME 50

// ----------------------------- BG Objects ----------------------------------

// ------------------------------ Screen -------------------------------------
// Resolution in which the game runs
#define INTERFACE_HEIGHT OBJ_HEIGHT

#define PLAY_AREA_WIDTH (OBJ_WIDTH * MAX_BLOCKS_X)
#define PLAY_AREA_HEIGHT (OBJ_HEIGHT * MAX_BLOCKS_Y)

#define SCREEN_WIDTH PLAY_AREA_WIDTH
#define SCREEN_HEIGHT (INTERFACE_HEIGHT + PLAY_AREA_HEIGHT)

#define SCREEN_DEPTH 32
#define BPP (SCREEN_DEPTH/8)

#define SCREEN_MAX_X (SCREEN_WIDTH-1)
#define SCREEN_MAX_Y (SCREEN_HEIGHT-1)
