/***************************************************************************
	main.h  -  main header

	begin                : 19 Feb 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

#include <stdlib.h>
#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

// -------------------------------------------------------------------------------------------------
// Settings
// -------------------------------------------------------------------------------------------------

// Comment this line out to run in a window
//#define FULLSCREEN_FLAG

// Enable music & sound effects
//#define SOUND_ENABLED

// -------------------------------------------------------------------------------------------------
// Cheats
// -------------------------------------------------------------------------------------------------

// --------------------------------------------------------------------------
// Debug output
// --------------------------------------------------------------------------

// Uncomment this to output the framerate to the terminal once every second
//#define DEBUG_FRAMERATE

// Uncomment this to print out screen & main character's positions when the game is paused
//#define DEBUG_PAUSE

// Uncomment to enable general debug checks & lockups
#define DEBUG_CHECKS

// Uncomment to output important debug info to the terminal
#define DEBUG_MODE1

// Uncomment to output once-a-frame debug info to the terminal
//#define DEBUG_MODE2

// Uncomment to output loads of ugly debug info to the terminal (eg. once-per-function)
//#define DEBUG_MODE3

// important debug info
#ifdef DEBUG_MODE1
//#define DEBUG_MODE1_FILE
//#define DEBUG_MODE1_BG
#define DEBUG_MODE1_OBJ
//#define DEBUG_MODE1_OBJ_C		// create messages
//#define DEBUG_MODE1_OBJ_D		// destroy messages
#define DEBUG_MODE1_ENEMIES
//#define DEBUG_MODE1_SPR
#define DEBUG_MODE1_MUS
#define DEBUG_MODE1_SND
#define DEBUG_MODE1_INPUT
#endif

// once-a-frame debug info
#ifdef DEBUG_MODE2
#define DEBUG_MODE2_BG
#define DEBUG_MODE2_OBJ
#define DEBUG_MODE2_PATHS
#define DEBUG_MODE2_MC
#endif

// loads of ugly info
#ifdef DEBUG_MODE3
#define DEBUG_MODE3_BG
#define DEBUG_MODE3_OBJ
#define DEBUG_MODE3_SPR
#endif

// On-screen guides, points, etc
//#define DEBUG_POINTS_BG		// bounding box in purple, collisions in white
//#define DEBUG_POINTS_SPR		// purple position of sprite

// =================================================================================================
// SHOULD NOT CHANGE ANYTHING BELOW THIS LINE
// =================================================================================================

// -------------------------------------------------------------------------------------------------
// Structures & declarations
// -------------------------------------------------------------------------------------------------
typedef struct
{
	float	x;
	float	y;
} vec2d;

typedef struct
{
	int	x;
	int	y;
} vec2di;

// Directions
enum MN_Dirs
{
	DirUp,
	DirUpRight,
	DirRight,
	DirDownRight,
	DirDown,
	DirDownLeft,
	DirLeft,
	DirUpLeft,
	// --------------------
	MN_NoOfDirs
};

enum MN_Dirs4
{
	Dir4Up,
	Dir4Right,
	Dir4Down,
	Dir4Left,
};

// --------------------------------------------------------------------------
// Definitions
// --------------------------------------------------------------------------

// Things to make the code shorter or nicer
#define false 0
#define true 1
#define uchar unsigned char
#define bool unsigned char

// Standard exit with an error macro
#define Lockup(_msg) \
	printf(_msg"\n"); \
	printf("Last SDL error (if any) : %s\n", SDL_GetError()); \
	SDL_Quit(); \
	exit(1)

#define BASE_DIR "data/"
#define SAVE_FILENAME "/.kapookarc"

// Special levels
#define INTERFACE_LEVEL	0

// Maths values
#define ROOT_2 			1.4142135623731
#define HALF_ROOT_2		0.7071067811866
#define PI				3.1415926535898
#define	HALF_PI			1.5707963267949

// -------------------------------------------------------------------------------------------------
// Constants
// -------------------------------------------------------------------------------------------------

// -------------------------------------------------------------------------------------------------
// Structures
// -------------------------------------------------------------------------------------------------

// -------------------------------------------------------------------------------------------------
// Global variables
// -------------------------------------------------------------------------------------------------

extern bool		MN_Quit;						// True means the game is over
extern int		MN_CurrentLevel;				// Level no currently in play
extern int		MN_HighestLevel;				// The highest level no that the player has reached
extern int		MN_Score;						// score for current level

extern SDL_Surface	*screen;					// The actual screen
extern SDL_Surface	*vScreen;					// Virtual screen which gets copied over the main screen once a frame

extern bool		MN_SoundEnabled;				// Whether or not sound is enabled

// -------------------------------------------------------------------------------------------------
// Functions
// -------------------------------------------------------------------------------------------------

// Initialises versatile things that may be reset at any time, eg. when player dies
void MN_Reset(void);

// Call this once when MN_CurrentLevel contains the correct level, to load that level
void MN_InitLevel(void);

// Instantly jumps to the specified level
void MN_JumpToLevel(int _level);
