/***************************************************************************
	input.c - keyboard/joystick/etc routines

    begin                : 28 Apr 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

#include "main.h"
#include "input.h"
#include "objects.h"
#include "backgrounds.h"

SDL_Event			IN_Event;
SDL_Joystick		*joystick;
bool				IN_Up;
bool				IN_Down;
bool				IN_Left;
bool				IN_Right;
bool				pauseKeyReleased;
bool				gamePaused;
vec2di				IN_MousePos;
enum IN_MBStates	IN_MouseButtonState;

// Resets input variables
void IN_Reset()
{
	IN_Up = false;
	IN_Down = false;
	IN_Left = false;
	IN_Right = false;
	pauseKeyReleased = true;
	gamePaused = false;
	IN_MousePos.x = -1;
	IN_MousePos.y = -1;
	IN_MouseButtonState = IN_MB_UP;
}

// Initialises input
void IN_Init()
{
	IN_Reset();

	if (SDL_NumJoysticks() > 0)
	{
		#ifdef DEBUG_MODE1_INPUT
		printf("Joystick found.\n");
		#endif

		SDL_JoystickEventState(SDL_ENABLE);
		joystick = SDL_JoystickOpen(0);
	} else {
		#ifdef DEBUG_MODE1_INPUT
		printf("No joystick found.\n");
		#endif

		joystick = NULL;
	}
}

// Processes any SDL input and updates the global variables accordingly
void IN_ProcessInput()
{
	while (SDL_PollEvent(&IN_Event))
	{
		switch (IN_Event.type)
		{
			case SDL_QUIT:
			{
				MN_Quit = true;
				break;
			}

			case SDL_KEYDOWN:
			{
				switch (IN_Event.key.keysym.sym)
				{
					case SDLK_LEFT:
					case SDLK_KP4:
					{
						IN_Left = true;
						IN_Right = false;
						break;
					}
					case SDLK_RIGHT:
					case SDLK_KP6:
					{
						IN_Right = true;
						IN_Left = false;
						break;
					}
					case SDLK_UP:
					case SDLK_KP8:
					{
						IN_Up = true;
						IN_Down = false;
						break;
					}
					case SDLK_DOWN:
					case SDLK_KP2:
					{
						IN_Down = true;
						IN_Up = false;
						break;
					}
					case SDLK_ESCAPE:
					{
						MN_Reset();
						break;
					}
					case SDLK_q:
					{
						MN_Quit = true;
						break;
					}
					case SDLK_p:
					{
						if (pauseKeyReleased)
						{
							gamePaused = !gamePaused;
							pauseKeyReleased = false;
						}
						break;
					}
					default:
					{
						break;
					}
				}
				break;
			}

			case SDL_KEYUP:
			{
				switch (IN_Event.key.keysym.sym)
				{
					case SDLK_LEFT:
					case SDLK_KP4:
					{
						IN_Left = false;
						break;
					}
					case SDLK_RIGHT:
					case SDLK_KP6:
					{
						IN_Right = false;
						break;
					}
					case SDLK_UP:
					case SDLK_KP8:
					{
						IN_Up = false;
						break;
					}
					case SDLK_DOWN:
					case SDLK_KP2:
					{
						IN_Down = false;
						break;
					}
					case SDLK_p:
					{
						pauseKeyReleased = true;
					}
					default:
					{
						break;
					}
				}
				break;
			}

			case SDL_JOYAXISMOTION:
			{
				#define JOY_THRESHOLD 3200

				switch (IN_Event.jaxis.axis)
				{
					case 0: // x axis
					{
						if (IN_Event.jaxis.value < -JOY_THRESHOLD)
						{
							IN_Left = true;
							IN_Right = false;
						} else {
							if (IN_Event.jaxis.value > JOY_THRESHOLD)
							{
								IN_Right = true;
								IN_Left = false;
							} else {
								IN_Left = false;
								IN_Right = false;
							}
						}
						break;
					}

					case 1: // y axis
					{
						if (IN_Event.jaxis.value < -JOY_THRESHOLD)
						{
							IN_Up = true;
							IN_Down = false;
						} else {
							if (IN_Event.jaxis.value > JOY_THRESHOLD)
							{
								IN_Down = true;
								IN_Up = false;
							} else {
								IN_Up = false;
								IN_Down = false;
							}
						}
						break;
					}

					default:
					{
						break;
					}
				}

				break;
			}
		}
	}

	// Get the mouse cursor pos
	if (SDL_GetMouseState(&IN_MousePos.x, &IN_MousePos.y) & SDL_BUTTON(1))
	{
		if (IN_MouseButtonState == IN_MB_UP)
		{
			IN_MouseButtonState = IN_MB_CLICKED;
		} else {
			IN_MouseButtonState = IN_MB_HELD;
		}
	} else {
		IN_MouseButtonState = IN_MB_UP;
	}
}
