/***************************************************************************
	backgrounds.h - background layer routines - header

    begin                : 22 Feb 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

// ---------------------------------------------------------------------------------------------------------------------
// Constants
// ---------------------------------------------------------------------------------------------------------------------

#define		BG_MAX_LAYERS			1		// Can change if needed

// ---------------------------------------------------------------------------------------------------------------------
// Structures
// ---------------------------------------------------------------------------------------------------------------------

typedef struct
{
	bool		visible;		// true => layer gets drawn; false => pos updated & only objects drawn
	SDL_Surface	*surface;		// Pointer to the SDL_Surface bitmap
	float		x;				// Floating point x position
	float		y;				// Floating point y position
	vec2d		pos;			// x & y position of top left corner
	float		relSpeedX;		// Horizontal speed relative to the main layer (1.0 => same speed)
	float		relSpeedY;		// Vertical speed relative to the main layer (1.0 => same speed)
	int			wrapX;			// x coordinate where layer should wrap around
	int			wrapY;			// y coordinate where layer should wrap around
} BG_Layer;

// ---------------------------------------------------------------------------------------------------------------------
// Globals
// ---------------------------------------------------------------------------------------------------------------------
extern BG_Layer	BG_Layers[BG_MAX_LAYERS];	// Array of all the background layer structures
extern BG_Layer *BG_MainLayer;			// Pointer to the main layer

extern uchar	BG_MainLayerNo;			// Which layer is currently the main layer
extern float	BG_MainSpeedX;			// Horizontal speed of the main bg layer
extern float	BG_MainSpeedY;			// Vertical speed of the main bg layer
extern float	BG_MainX, BG_MainY;		// main layer's top left corner's current coordinates
extern enum MN_Dirs4 BG_ScrollingDir;	// Direction the bg is scrolling (Dir4... from enum MN_Dirs4)


// ---------------------------------------------------------------------------------------------------------------------
// Macros
// ---------------------------------------------------------------------------------------------------------------------

// Checks if the coordinates are considered on the screen
// _x & _y = coords of the object; _layer is a pointer to the layer it's on
#define BG_IsOnScreen(_left, _top, _right, _bottom, _layer) \
	(((_bottom > _layer->y) && (_top < _layer->y + SCREEN_HEIGHT)) \
  && ((_right > _layer->x) && (_left < _layer->x + SCREEN_WIDTH)))

// ---------------------------------------------------------------------------------------------------------------------
// Functions
// ---------------------------------------------------------------------------------------------------------------------

// (Re)sets the bg layers' initial position.
void BG_Reset(void);

// Goes through all layers and frees the surfaces from memory
void BG_FreeSurfaces(void);

// Initialise all background layers for _currLevel
void BG_Init(void);

// Blit src onto dest from position (x, y)
void BG_BlitSurface(SDL_Surface *src, int x, int y, SDL_Surface *dest);

// Blits vScreen to screen, similar to SDL_BlitSurface but with lots of hardcoded bodges for more speed
void BG_BlitScreen();

// Update & blit all background layers for _currLevel
void BG_UpdateLayers(void);

// Given left, top, width & height, checks if the rectangle is clear on the main layer
bool BG_IsSpaceClear(int _left, int _top, int _width, int _height);

// Clears a disc on the main bg layer at the specified pos, using the shingle hole mask sprite
void BG_ClearDisc(int _x, int _y);
