/* -*- Mode: C; c-basic-offset: 4 -*- */
/* GTK DBF Editor -- a simple dbf editor built with GTK+
 * Copyright (C) 2001-2011 Steffen Macke
 *
 * table.c: display dbf table
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "interface.h"
#include "support.h"
#include "shapefil.h"
#include "dbf.h"
#include "table.h"

void
on_treeview1_cursor_changed (GtkTreeView * treeview1, gpointer user_data)
{
  GtkTreePath *path;
  gint *indices;
  gint row;

  gtk_tree_view_get_cursor (treeview1, &path, NULL);
  indices = gtk_tree_path_get_indices (path);
  row = indices[0];
  gtk_tree_path_free (path);
  if (row == n_current_record)
    {
      return;
    }
  dbf_display_record (dbf_editor_window, row);
}

void
dbf_fill_table ()
{
  GtkTreeView *treeview1;
  int i, j;
  int n_fields;
  int n_record_count;
  gchar *field_attribute;
  gchar **record;
  GList *columns;
  GType *types;
  GtkListStore *store;
  GtkTreeIter iter;
  GtkCellRenderer *renderer;
  char field_name[12];
  int n_field_width;

  if (DBFGetRecordCount (dbfh_file) == 0)
    {
      return;
    }

  treeview1 = GTK_TREE_VIEW (glade_xml_get_widget (glade_xml, "treeview1"));

  n_fields = DBFGetFieldCount (dbfh_file);

  types = g_new (GType, n_fields);
  for (i = 0; i < n_fields; i++)
    {
      types[i] = G_TYPE_STRING;
      renderer = gtk_cell_renderer_text_new ();
      DBFGetFieldInfo (dbfh_file, i, field_name, &n_field_width, NULL);
      gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview1),
						   -1, field_name, renderer,
						   "text", i, NULL);
    }

  store = GTK_LIST_STORE (gtk_list_store_newv (n_fields, types));

  n_record_count = DBFGetRecordCount (dbfh_file);
  for (j = 0; j < n_record_count; j++)
    {
      gtk_list_store_append (store, &iter);
      for (i = 0; i < n_fields; i++)
	{
	  GValue gvalue = { 0, };
	  field_attribute =
	    g_convert ((gchar *) DBFReadStringAttribute (dbfh_file, j, i), -1,
		       "UTF-8", dbf_encoding, NULL, NULL, NULL);
	  g_value_init (&gvalue, G_TYPE_STRING);
	  g_value_set_string (&gvalue, field_attribute);
	  gtk_list_store_set_value (store, &iter, i, &gvalue);
	}
    }
  gtk_tree_view_set_model (GTK_TREE_VIEW (treeview1), GTK_TREE_MODEL (store));
}

void
dbf_table_add_row ()
{
  GtkListStore *store;
  GtkTreeView *treeview1;
  GtkTreeIter iter;
  GtkTreeSelection *selection;
  int n_fields;
  gchar **record;
  int i;

  treeview1 = glade_xml_get_widget (glade_xml, "treeview1");
  store = GTK_LIST_STORE (gtk_tree_view_get_model (treeview1));
  gtk_list_store_append (store, &iter);
  selection = GTK_TREE_SELECTION (gtk_tree_view_get_selection (treeview1));
  gtk_tree_selection_select_iter (selection, &iter);
}

/**
 * Reflect the data entry window selection in the table.
 */
void
dbf_table_select_row (gint row)
{
  GtkTreeView *treeview1;
  GtkTreePath *path;
  GtkTreeSelection *selection;

  treeview1 = glade_xml_get_widget (glade_xml, "treeview1");
  path = gtk_tree_path_new_from_indices (row, -1);
  selection = GTK_TREE_SELECTION (gtk_tree_view_get_selection (treeview1));
  gtk_tree_selection_select_path (selection, path);
  gtk_tree_path_free (path);
}

void
dbf_table_set_cell_value (gchar * value, gint column, gint row)
{
  GtkTreeView *treeview1;
  GtkTreePath *path;
  GtkTreeIter iter;
  GtkListStore *store;
  GValue gvalue = { 0, };

  treeview1 = glade_xml_get_widget (glade_xml, "treeview1");
  path = gtk_tree_path_new_from_indices (row, -1);
  store = GTK_LIST_STORE (gtk_tree_view_get_model (treeview1));
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  g_value_init (&gvalue, G_TYPE_STRING);
  g_value_set_string (&gvalue, value);
  gtk_list_store_set_value (store, &iter, column, &gvalue);
  gtk_tree_path_free (path);
}
