#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <err.h>

#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <net/if.h>

#ifdef HAVE_NET_IF_VAR_H
#include <net/if_var.h>      
#endif
#ifdef HAVE_NET_IF_ETHER_H
#include <net/if_ether.h>
#else
#ifdef HAVE_NET_ETHERNET_H
#include <net/ethernet.h>   
#endif
#endif
 
#if defined(HAVE_DEV_PCMCIA_IF_WI_IEEE_H)
#include <dev/pcmcia/if_wi_ieee.h>
#elif defined(HAVE_MACHINE_IF_WAVELAN_IEEE_H)
#include <machine/if_wavelan_ieee.h>      
#elif defined(HAVE_DEV_IC_WI_IEEE_H)
#include <dev/ic/wi_ieee.h>
#endif

void 
set_wi_info (char *ifname, struct wi_req * wreq)
{
  struct ifreq ifr;
  int s;

  bzero ((char *) &ifr, sizeof (ifr));

  strcpy (ifr.ifr_name, ifname);
  ifr.ifr_data = (caddr_t) wreq;

  s = socket (AF_INET, SOCK_DGRAM, 0);

  if (s == -1)
    err (1, "socket");

  if (ioctl (s, SIOCSWAVELAN, &ifr) == -1)
    close (s);

  close (s);

  return;


}

int 
get_wi_info (char *ifname, struct wi_req * wreq)
{

  struct ifreq ifr;
  int s;

  bzero ((char *) &ifr, sizeof (ifr));

  strcpy (ifr.ifr_name, ifname);
  ifr.ifr_data = (caddr_t) wreq;

  s = socket (AF_INET, SOCK_DGRAM, 0);

  if (s == -1) {
    err (1, "socket");
    return 0;
  }
  if (ioctl (s, SIOCGWAVELAN, &ifr) == -1) {
    close (s);
    wreq->wi_val[0] = 0;
    return 0;
  }
  close (s);
  return 1;
}




int 
get_qua (ifname)
  char *ifname;
{


  struct wi_req wreq;
  struct ifreq ifr;
  int s;

  bzero ((char *) &ifr, sizeof (ifr));

  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_COMMS_QUALITY;

  strcpy (ifr.ifr_name, ifname);
  ifr.ifr_data = (caddr_t) & wreq;

  s = socket (AF_INET, SOCK_DGRAM, 0);

  if (s == -1)
    err (1, "socket");

  if (ioctl (s, SIOCGWAVELAN, &ifr) == -1) {
    close (s);
    return 0;

    /*
     * err(1, "SIOCGWAVELAN");
     */
  }
  close (s);


  return wreq.wi_val[0];
}

int 
get_actual_txrate (ifname)
  char *ifname;
{

  struct wi_req wreq;
  struct ifreq ifr;
  int s;

  bzero ((char *) &ifr, sizeof (ifr));

  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_CUR_TX_RATE;

  strcpy (ifr.ifr_name, ifname);
  ifr.ifr_data = (caddr_t) & wreq;

  s = socket (AF_INET, SOCK_DGRAM, 0);

  if (s == -1)
    err (1, "socket");

  if (ioctl (s, SIOCGWAVELAN, &ifr) == -1) {
    close (s);
    return 0;

    /*
     * err(1, "SIOCGWAVELAN");
     */
  }
  close (s);


  return wreq.wi_val[0];

}
