// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/storagetransfer/logging/transfer_activity_log.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of the storage system.
type StorageSystemType int32

const (
	// Unspecified.
	StorageSystemType_STORAGE_SYSTEM_TYPE_UNSPECIFIED StorageSystemType = 0
	// AWS S3.
	StorageSystemType_AWS_S3 StorageSystemType = 1
	// Azure Blob Storage.
	StorageSystemType_AZURE_BLOB StorageSystemType = 2
	// Google Cloud Storage.
	StorageSystemType_GCS StorageSystemType = 3
	// POSIX file system.
	StorageSystemType_POSIX_FS StorageSystemType = 4
	// HTTP/HTTPS servers.
	StorageSystemType_HTTP StorageSystemType = 5
)

// Enum value maps for StorageSystemType.
var (
	StorageSystemType_name = map[int32]string{
		0: "STORAGE_SYSTEM_TYPE_UNSPECIFIED",
		1: "AWS_S3",
		2: "AZURE_BLOB",
		3: "GCS",
		4: "POSIX_FS",
		5: "HTTP",
	}
	StorageSystemType_value = map[string]int32{
		"STORAGE_SYSTEM_TYPE_UNSPECIFIED": 0,
		"AWS_S3":                          1,
		"AZURE_BLOB":                      2,
		"GCS":                             3,
		"POSIX_FS":                        4,
		"HTTP":                            5,
	}
)

func (x StorageSystemType) Enum() *StorageSystemType {
	p := new(StorageSystemType)
	*p = x
	return p
}

func (x StorageSystemType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StorageSystemType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_enumTypes[0].Descriptor()
}

func (StorageSystemType) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_logging_transfer_activity_log_proto_enumTypes[0]
}

func (x StorageSystemType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StorageSystemType.Descriptor instead.
func (StorageSystemType) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{0}
}

// Possible actions which a transfer operation can make.
type TransferActivityLog_Action int32

const (
	// Unspeficied action.
	TransferActivityLog_ACTION_UNSPECIFIED TransferActivityLog_Action = 0
	// Finding work to do, such as listing files in a directory or listing
	// objects in a bucket.
	TransferActivityLog_FIND TransferActivityLog_Action = 1
	// Copying files or objects.
	TransferActivityLog_COPY TransferActivityLog_Action = 2
	// Deleting files or objects at destination.
	TransferActivityLog_DELETE TransferActivityLog_Action = 3
)

// Enum value maps for TransferActivityLog_Action.
var (
	TransferActivityLog_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "FIND",
		2: "COPY",
		3: "DELETE",
	}
	TransferActivityLog_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"FIND":               1,
		"COPY":               2,
		"DELETE":             3,
	}
)

func (x TransferActivityLog_Action) Enum() *TransferActivityLog_Action {
	p := new(TransferActivityLog_Action)
	*p = x
	return p
}

func (x TransferActivityLog_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferActivityLog_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_enumTypes[1].Descriptor()
}

func (TransferActivityLog_Action) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_logging_transfer_activity_log_proto_enumTypes[1]
}

func (x TransferActivityLog_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferActivityLog_Action.Descriptor instead.
func (TransferActivityLog_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{11, 0}
}

// AWS S3 object metadata.
type AwsS3ObjectMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the S3 bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name/key of the object.
	ObjectKey string `protobuf:"bytes,2,opt,name=object_key,json=objectKey,proto3" json:"object_key,omitempty"`
	// Last modified time of the object.
	LastModifiedTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// The MD5 checksum of the object's content.
	Md5 string `protobuf:"bytes,4,opt,name=md5,proto3" json:"md5,omitempty"`
	// Required. Size of the object in bytes.
	Size int64 `protobuf:"varint,5,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *AwsS3ObjectMetadata) Reset() {
	*x = AwsS3ObjectMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsS3ObjectMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsS3ObjectMetadata) ProtoMessage() {}

func (x *AwsS3ObjectMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsS3ObjectMetadata.ProtoReflect.Descriptor instead.
func (*AwsS3ObjectMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{0}
}

func (x *AwsS3ObjectMetadata) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *AwsS3ObjectMetadata) GetObjectKey() string {
	if x != nil {
		return x.ObjectKey
	}
	return ""
}

func (x *AwsS3ObjectMetadata) GetLastModifiedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedTime
	}
	return nil
}

func (x *AwsS3ObjectMetadata) GetMd5() string {
	if x != nil {
		return x.Md5
	}
	return ""
}

func (x *AwsS3ObjectMetadata) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// AWS S3 bucket metadata.
type AwsS3BucketMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the S3 bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The path of transfer objects as an object key prefix ending with "/".
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *AwsS3BucketMetadata) Reset() {
	*x = AwsS3BucketMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsS3BucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsS3BucketMetadata) ProtoMessage() {}

func (x *AwsS3BucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsS3BucketMetadata.ProtoReflect.Descriptor instead.
func (*AwsS3BucketMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{1}
}

func (x *AwsS3BucketMetadata) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *AwsS3BucketMetadata) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Google Cloud Storage object metadata.
type GcsObjectMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Cloud Storage bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name/key of the object.
	ObjectKey string `protobuf:"bytes,2,opt,name=object_key,json=objectKey,proto3" json:"object_key,omitempty"`
	// Last modified time of the object.
	LastModifiedTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// The MD5 checksum of the object's content.
	Md5 string `protobuf:"bytes,4,opt,name=md5,proto3" json:"md5,omitempty"`
	// The CRC32C checksum of the object's content.
	Crc32C string `protobuf:"bytes,5,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	// Required. Size of the object in bytes.
	Size int64 `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *GcsObjectMetadata) Reset() {
	*x = GcsObjectMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsObjectMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsObjectMetadata) ProtoMessage() {}

func (x *GcsObjectMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsObjectMetadata.ProtoReflect.Descriptor instead.
func (*GcsObjectMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{2}
}

func (x *GcsObjectMetadata) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GcsObjectMetadata) GetObjectKey() string {
	if x != nil {
		return x.ObjectKey
	}
	return ""
}

func (x *GcsObjectMetadata) GetLastModifiedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedTime
	}
	return nil
}

func (x *GcsObjectMetadata) GetMd5() string {
	if x != nil {
		return x.Md5
	}
	return ""
}

func (x *GcsObjectMetadata) GetCrc32C() string {
	if x != nil {
		return x.Crc32C
	}
	return ""
}

func (x *GcsObjectMetadata) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// Google Cloud Storage bucket metadata.
type GcsBucketMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Cloud Storage bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The path of transfer objects as an object key prefix ending with "/".
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *GcsBucketMetadata) Reset() {
	*x = GcsBucketMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsBucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsBucketMetadata) ProtoMessage() {}

func (x *GcsBucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsBucketMetadata.ProtoReflect.Descriptor instead.
func (*GcsBucketMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{3}
}

func (x *GcsBucketMetadata) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GcsBucketMetadata) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Azure Blob Storage blob metadata.
type AzureBlobMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Azure Blob storage account.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. Name of the container.
	Container string `protobuf:"bytes,2,opt,name=container,proto3" json:"container,omitempty"`
	// Required. Name of the blob.
	BlobName string `protobuf:"bytes,3,opt,name=blob_name,json=blobName,proto3" json:"blob_name,omitempty"`
	// Last modified time of the blob.
	LastModifiedTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// The MD5 checksum of the object's content.
	Md5 string `protobuf:"bytes,5,opt,name=md5,proto3" json:"md5,omitempty"`
	// Required. Size of the blob in bytes.
	Size int64 `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *AzureBlobMetadata) Reset() {
	*x = AzureBlobMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureBlobMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureBlobMetadata) ProtoMessage() {}

func (x *AzureBlobMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureBlobMetadata.ProtoReflect.Descriptor instead.
func (*AzureBlobMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{4}
}

func (x *AzureBlobMetadata) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *AzureBlobMetadata) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

func (x *AzureBlobMetadata) GetBlobName() string {
	if x != nil {
		return x.BlobName
	}
	return ""
}

func (x *AzureBlobMetadata) GetLastModifiedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedTime
	}
	return nil
}

func (x *AzureBlobMetadata) GetMd5() string {
	if x != nil {
		return x.Md5
	}
	return ""
}

func (x *AzureBlobMetadata) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// Azure Blob Storage container metadata.
type AzureBlobContainerMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Azure Blob storage account.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. Name of the container.
	Container string `protobuf:"bytes,2,opt,name=container,proto3" json:"container,omitempty"`
	// The path of transfer blobs as a blob name prefix ending with "/".
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *AzureBlobContainerMetadata) Reset() {
	*x = AzureBlobContainerMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureBlobContainerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureBlobContainerMetadata) ProtoMessage() {}

func (x *AzureBlobContainerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureBlobContainerMetadata.ProtoReflect.Descriptor instead.
func (*AzureBlobContainerMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{5}
}

func (x *AzureBlobContainerMetadata) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *AzureBlobContainerMetadata) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

func (x *AzureBlobContainerMetadata) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// POSIX file metadata.
type PosixFileMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Path of a file.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Last modified time (mtime) of the file.
	LastModifiedTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// The CRC32C checksum of the object's content.
	Crc32C string `protobuf:"bytes,3,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	// Required. Size of the file in bytes.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *PosixFileMetadata) Reset() {
	*x = PosixFileMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PosixFileMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PosixFileMetadata) ProtoMessage() {}

func (x *PosixFileMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PosixFileMetadata.ProtoReflect.Descriptor instead.
func (*PosixFileMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{6}
}

func (x *PosixFileMetadata) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *PosixFileMetadata) GetLastModifiedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedTime
	}
	return nil
}

func (x *PosixFileMetadata) GetCrc32C() string {
	if x != nil {
		return x.Crc32C
	}
	return ""
}

func (x *PosixFileMetadata) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// HTTP file metadata.
type HttpFileMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Url of the HTTP file.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The MD5 checksum of the file's content.
	Md5 string `protobuf:"bytes,2,opt,name=md5,proto3" json:"md5,omitempty"`
	// Size of the file in bytes.
	Size int64 `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *HttpFileMetadata) Reset() {
	*x = HttpFileMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpFileMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpFileMetadata) ProtoMessage() {}

func (x *HttpFileMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpFileMetadata.ProtoReflect.Descriptor instead.
func (*HttpFileMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{7}
}

func (x *HttpFileMetadata) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *HttpFileMetadata) GetMd5() string {
	if x != nil {
		return x.Md5
	}
	return ""
}

func (x *HttpFileMetadata) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// HTTP manifest file metadata.
type HttpManifestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Url of the HTTP manifest which contains the list of HTTP files to
	// transfer.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *HttpManifestMetadata) Reset() {
	*x = HttpManifestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpManifestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpManifestMetadata) ProtoMessage() {}

func (x *HttpManifestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpManifestMetadata.ProtoReflect.Descriptor instead.
func (*HttpManifestMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{8}
}

func (x *HttpManifestMetadata) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// Metadata of a blob/file/object.
type ObjectMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Storage system type of the object.
	Type StorageSystemType `protobuf:"varint,1,opt,name=type,proto3,enum=google.storagetransfer.logging.StorageSystemType" json:"type,omitempty"`
	// Types that are assignable to Metadata:
	//
	//	*ObjectMetadata_AwsS3Object
	//	*ObjectMetadata_AzureBlob
	//	*ObjectMetadata_GcsObject
	//	*ObjectMetadata_PosixFile
	//	*ObjectMetadata_HttpFile
	Metadata isObjectMetadata_Metadata `protobuf_oneof:"metadata"`
}

func (x *ObjectMetadata) Reset() {
	*x = ObjectMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectMetadata) ProtoMessage() {}

func (x *ObjectMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectMetadata.ProtoReflect.Descriptor instead.
func (*ObjectMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{9}
}

func (x *ObjectMetadata) GetType() StorageSystemType {
	if x != nil {
		return x.Type
	}
	return StorageSystemType_STORAGE_SYSTEM_TYPE_UNSPECIFIED
}

func (m *ObjectMetadata) GetMetadata() isObjectMetadata_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *ObjectMetadata) GetAwsS3Object() *AwsS3ObjectMetadata {
	if x, ok := x.GetMetadata().(*ObjectMetadata_AwsS3Object); ok {
		return x.AwsS3Object
	}
	return nil
}

func (x *ObjectMetadata) GetAzureBlob() *AzureBlobMetadata {
	if x, ok := x.GetMetadata().(*ObjectMetadata_AzureBlob); ok {
		return x.AzureBlob
	}
	return nil
}

func (x *ObjectMetadata) GetGcsObject() *GcsObjectMetadata {
	if x, ok := x.GetMetadata().(*ObjectMetadata_GcsObject); ok {
		return x.GcsObject
	}
	return nil
}

func (x *ObjectMetadata) GetPosixFile() *PosixFileMetadata {
	if x, ok := x.GetMetadata().(*ObjectMetadata_PosixFile); ok {
		return x.PosixFile
	}
	return nil
}

func (x *ObjectMetadata) GetHttpFile() *HttpFileMetadata {
	if x, ok := x.GetMetadata().(*ObjectMetadata_HttpFile); ok {
		return x.HttpFile
	}
	return nil
}

type isObjectMetadata_Metadata interface {
	isObjectMetadata_Metadata()
}

type ObjectMetadata_AwsS3Object struct {
	// Object metadata of AWS S3.
	AwsS3Object *AwsS3ObjectMetadata `protobuf:"bytes,3,opt,name=aws_s3_object,json=awsS3Object,proto3,oneof"`
}

type ObjectMetadata_AzureBlob struct {
	// Blob metadata of Azure Blob Storage.
	AzureBlob *AzureBlobMetadata `protobuf:"bytes,4,opt,name=azure_blob,json=azureBlob,proto3,oneof"`
}

type ObjectMetadata_GcsObject struct {
	// Object metadata of Google Cloud Storage.
	GcsObject *GcsObjectMetadata `protobuf:"bytes,5,opt,name=gcs_object,json=gcsObject,proto3,oneof"`
}

type ObjectMetadata_PosixFile struct {
	// File/directory metadata of POSIX file system.
	PosixFile *PosixFileMetadata `protobuf:"bytes,6,opt,name=posix_file,json=posixFile,proto3,oneof"`
}

type ObjectMetadata_HttpFile struct {
	// Metadata of a file on a HTTP server.
	HttpFile *HttpFileMetadata `protobuf:"bytes,7,opt,name=http_file,json=httpFile,proto3,oneof"`
}

func (*ObjectMetadata_AwsS3Object) isObjectMetadata_Metadata() {}

func (*ObjectMetadata_AzureBlob) isObjectMetadata_Metadata() {}

func (*ObjectMetadata_GcsObject) isObjectMetadata_Metadata() {}

func (*ObjectMetadata_PosixFile) isObjectMetadata_Metadata() {}

func (*ObjectMetadata_HttpFile) isObjectMetadata_Metadata() {}

// Metadata of a bucket/container/directory
type ContainerMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Storage system type of the object.
	Type StorageSystemType `protobuf:"varint,1,opt,name=type,proto3,enum=google.storagetransfer.logging.StorageSystemType" json:"type,omitempty"`
	// Types that are assignable to Metadata:
	//
	//	*ContainerMetadata_AwsS3Bucket
	//	*ContainerMetadata_AzureBlobContainer
	//	*ContainerMetadata_GcsBucket
	//	*ContainerMetadata_PosixDirectory
	//	*ContainerMetadata_HttpManifest
	Metadata isContainerMetadata_Metadata `protobuf_oneof:"metadata"`
}

func (x *ContainerMetadata) Reset() {
	*x = ContainerMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerMetadata) ProtoMessage() {}

func (x *ContainerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerMetadata.ProtoReflect.Descriptor instead.
func (*ContainerMetadata) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{10}
}

func (x *ContainerMetadata) GetType() StorageSystemType {
	if x != nil {
		return x.Type
	}
	return StorageSystemType_STORAGE_SYSTEM_TYPE_UNSPECIFIED
}

func (m *ContainerMetadata) GetMetadata() isContainerMetadata_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *ContainerMetadata) GetAwsS3Bucket() *AwsS3BucketMetadata {
	if x, ok := x.GetMetadata().(*ContainerMetadata_AwsS3Bucket); ok {
		return x.AwsS3Bucket
	}
	return nil
}

func (x *ContainerMetadata) GetAzureBlobContainer() *AzureBlobContainerMetadata {
	if x, ok := x.GetMetadata().(*ContainerMetadata_AzureBlobContainer); ok {
		return x.AzureBlobContainer
	}
	return nil
}

func (x *ContainerMetadata) GetGcsBucket() *GcsBucketMetadata {
	if x, ok := x.GetMetadata().(*ContainerMetadata_GcsBucket); ok {
		return x.GcsBucket
	}
	return nil
}

func (x *ContainerMetadata) GetPosixDirectory() *PosixFileMetadata {
	if x, ok := x.GetMetadata().(*ContainerMetadata_PosixDirectory); ok {
		return x.PosixDirectory
	}
	return nil
}

func (x *ContainerMetadata) GetHttpManifest() *HttpManifestMetadata {
	if x, ok := x.GetMetadata().(*ContainerMetadata_HttpManifest); ok {
		return x.HttpManifest
	}
	return nil
}

type isContainerMetadata_Metadata interface {
	isContainerMetadata_Metadata()
}

type ContainerMetadata_AwsS3Bucket struct {
	// Bucket metadata of AWS S3.
	AwsS3Bucket *AwsS3BucketMetadata `protobuf:"bytes,3,opt,name=aws_s3_bucket,json=awsS3Bucket,proto3,oneof"`
}

type ContainerMetadata_AzureBlobContainer struct {
	// Container metadata of Azure Blob Storage.
	AzureBlobContainer *AzureBlobContainerMetadata `protobuf:"bytes,4,opt,name=azure_blob_container,json=azureBlobContainer,proto3,oneof"`
}

type ContainerMetadata_GcsBucket struct {
	// Bucket metadata of Google Cloud Storage.
	GcsBucket *GcsBucketMetadata `protobuf:"bytes,5,opt,name=gcs_bucket,json=gcsBucket,proto3,oneof"`
}

type ContainerMetadata_PosixDirectory struct {
	// Directory metadata of POSIX file system.
	PosixDirectory *PosixFileMetadata `protobuf:"bytes,6,opt,name=posix_directory,json=posixDirectory,proto3,oneof"`
}

type ContainerMetadata_HttpManifest struct {
	// Metadata of a manifest file on a HTTP server.
	HttpManifest *HttpManifestMetadata `protobuf:"bytes,7,opt,name=http_manifest,json=httpManifest,proto3,oneof"`
}

func (*ContainerMetadata_AwsS3Bucket) isContainerMetadata_Metadata() {}

func (*ContainerMetadata_AzureBlobContainer) isContainerMetadata_Metadata() {}

func (*ContainerMetadata_GcsBucket) isContainerMetadata_Metadata() {}

func (*ContainerMetadata_PosixDirectory) isContainerMetadata_Metadata() {}

func (*ContainerMetadata_HttpManifest) isContainerMetadata_Metadata() {}

// Schema of log payload of transfer activity.
type TransferActivityLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the transfer operation.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
	// Required. The action which the transfer operation made.
	Action TransferActivityLog_Action `protobuf:"varint,2,opt,name=action,proto3,enum=google.storagetransfer.logging.TransferActivityLog_Action" json:"action,omitempty"`
	// Required. Status of the action.
	Status *TransferActivityLog_Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// Metadata of source bucket/container/directory. Only set if the action is
	// FIND.
	SourceContainer *ContainerMetadata `protobuf:"bytes,4,opt,name=source_container,json=sourceContainer,proto3" json:"source_container,omitempty"`
	// Metadata of destination bucket/container/directory. Only set if the action
	// is FIND.
	DestinationContainer *ContainerMetadata `protobuf:"bytes,5,opt,name=destination_container,json=destinationContainer,proto3" json:"destination_container,omitempty"`
	// Metadata of the source blob/file/object. Only set if the action is COPY or
	// DELETE when deletion is applied to source.
	SourceObject *ObjectMetadata `protobuf:"bytes,6,opt,name=source_object,json=sourceObject,proto3" json:"source_object,omitempty"`
	// Metadata of the destination blob/file/object. Only set if the action is
	// or DELETE when deletion is applied to destination.
	DestinationObject *ObjectMetadata `protobuf:"bytes,7,opt,name=destination_object,json=destinationObject,proto3" json:"destination_object,omitempty"`
	// Required. Completion time of the action.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
}

func (x *TransferActivityLog) Reset() {
	*x = TransferActivityLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferActivityLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferActivityLog) ProtoMessage() {}

func (x *TransferActivityLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferActivityLog.ProtoReflect.Descriptor instead.
func (*TransferActivityLog) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{11}
}

func (x *TransferActivityLog) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *TransferActivityLog) GetAction() TransferActivityLog_Action {
	if x != nil {
		return x.Action
	}
	return TransferActivityLog_ACTION_UNSPECIFIED
}

func (x *TransferActivityLog) GetStatus() *TransferActivityLog_Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *TransferActivityLog) GetSourceContainer() *ContainerMetadata {
	if x != nil {
		return x.SourceContainer
	}
	return nil
}

func (x *TransferActivityLog) GetDestinationContainer() *ContainerMetadata {
	if x != nil {
		return x.DestinationContainer
	}
	return nil
}

func (x *TransferActivityLog) GetSourceObject() *ObjectMetadata {
	if x != nil {
		return x.SourceObject
	}
	return nil
}

func (x *TransferActivityLog) GetDestinationObject() *ObjectMetadata {
	if x != nil {
		return x.DestinationObject
	}
	return nil
}

func (x *TransferActivityLog) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

// Status of an action.
type TransferActivityLog_Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A string value of the Google RPC code as the status of the
	// action. The action succeeded if it's `OK`, and failed otherwise.
	StatusCode string `protobuf:"bytes,1,opt,name=status_code,json=statusCode,proto3" json:"status_code,omitempty"`
	// A string that represents the type of error encountered. Populated only if
	// status_code is not `OK`.
	ErrorType string `protobuf:"bytes,2,opt,name=error_type,json=errorType,proto3" json:"error_type,omitempty"`
	// A human-readable error message for the failure. Populated only if
	// status_code is not `OK`.
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *TransferActivityLog_Status) Reset() {
	*x = TransferActivityLog_Status{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferActivityLog_Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferActivityLog_Status) ProtoMessage() {}

func (x *TransferActivityLog_Status) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferActivityLog_Status.ProtoReflect.Descriptor instead.
func (*TransferActivityLog_Status) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP(), []int{11, 0}
}

func (x *TransferActivityLog_Status) GetStatusCode() string {
	if x != nil {
		return x.StatusCode
	}
	return ""
}

func (x *TransferActivityLog_Status) GetErrorType() string {
	if x != nil {
		return x.ErrorType
	}
	return ""
}

func (x *TransferActivityLog_Status) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

var File_google_storagetransfer_logging_transfer_activity_log_proto protoreflect.FileDescriptor

var file_google_storagetransfer_logging_transfer_activity_log_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb,
	0x01, 0x0a, 0x13, 0x41, 0x77, 0x73, 0x53, 0x33, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x10, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x64, 0x35, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6d, 0x64, 0x35, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x46, 0x0a, 0x13,
	0x41, 0x77, 0x73, 0x53, 0x33, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x22, 0xe1, 0x01, 0x0a, 0x11, 0x47, 0x63, 0x73, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x12, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x64, 0x35, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6d, 0x64, 0x35, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32,
	0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x12,
	0x17, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x44, 0x0a, 0x11, 0x47, 0x63, 0x73, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xec,
	0x01, 0x0a, 0x11, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x62, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x62, 0x6c, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x64, 0x35, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6d, 0x64, 0x35, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x72, 0x0a,
	0x1a, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x07, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x22, 0xa7, 0x01, 0x0a, 0x11, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x12, 0x48, 0x0a, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x72,
	0x63, 0x33, 0x32, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x72, 0x63, 0x33,
	0x32, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x4f, 0x0a, 0x10, 0x48,
	0x74, 0x74, 0x70, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x64, 0x35, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6d, 0x64, 0x35, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x2d, 0x0a, 0x14,
	0x48, 0x74, 0x74, 0x70, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x90, 0x04, 0x0a, 0x0e,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4a,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x59, 0x0a, 0x0d, 0x61, 0x77,
	0x73, 0x5f, 0x73, 0x33, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x33, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x77, 0x73, 0x53, 0x33, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x52, 0x0a, 0x0a, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x62,
	0x6c, 0x6f, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x42, 0x6c, 0x6f, 0x62, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x09,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x12, 0x52, 0x0a, 0x0a, 0x67, 0x63, 0x73,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x47,
	0x63, 0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x52, 0x0a,
	0x0a, 0x70, 0x6f, 0x73, 0x69, 0x78, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x09, 0x70, 0x6f, 0x73, 0x69, 0x78, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x4f, 0x0a, 0x09, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x08, 0x68, 0x74, 0x74, 0x70, 0x46, 0x69,
	0x6c, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc5,
	0x04, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x4a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x59, 0x0a, 0x0d, 0x61, 0x77, 0x73, 0x5f, 0x73, 0x33, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x33, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b,
	0x61, 0x77, 0x73, 0x53, 0x33, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x6e, 0x0a, 0x14, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x42, 0x6c, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x12, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c,
	0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x0a, 0x67,
	0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x47, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x5c, 0x0a, 0x0f, 0x70, 0x6f, 0x73, 0x69, 0x78, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x46,
	0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0e, 0x70,
	0x6f, 0x73, 0x69, 0x78, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x5b, 0x0a,
	0x0d, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0c, 0x68, 0x74,
	0x74, 0x70, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe0, 0x06, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x67, 0x12, 0x21,
	0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x57, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x4c, 0x6f, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x67, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x5c, 0x0a, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x12, 0x66, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x5d,
	0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x44, 0x0a,
	0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x72, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24, 0x0a,
	0x0b, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x40, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x49, 0x4e,
	0x44, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x2a, 0x75, 0x0a, 0x11, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23,
	0x0a, 0x1f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x57, 0x53, 0x5f, 0x53, 0x33, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x41, 0x5a, 0x55, 0x52, 0x45, 0x5f, 0x42, 0x4c, 0x4f, 0x42, 0x10, 0x02, 0x12,
	0x07, 0x0a, 0x03, 0x47, 0x43, 0x53, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4f, 0x53, 0x49,
	0x58, 0x5f, 0x46, 0x53, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x54, 0x54, 0x50, 0x10, 0x05,
	0x42, 0xec, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x42, 0x18, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0xca, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0xea, 0x02, 0x20, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescOnce sync.Once
	file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescData = file_google_storagetransfer_logging_transfer_activity_log_proto_rawDesc
)

func file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescGZIP() []byte {
	file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescOnce.Do(func() {
		file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescData)
	})
	return file_google_storagetransfer_logging_transfer_activity_log_proto_rawDescData
}

var file_google_storagetransfer_logging_transfer_activity_log_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_storagetransfer_logging_transfer_activity_log_proto_goTypes = []interface{}{
	(StorageSystemType)(0),             // 0: google.storagetransfer.logging.StorageSystemType
	(TransferActivityLog_Action)(0),    // 1: google.storagetransfer.logging.TransferActivityLog.Action
	(*AwsS3ObjectMetadata)(nil),        // 2: google.storagetransfer.logging.AwsS3ObjectMetadata
	(*AwsS3BucketMetadata)(nil),        // 3: google.storagetransfer.logging.AwsS3BucketMetadata
	(*GcsObjectMetadata)(nil),          // 4: google.storagetransfer.logging.GcsObjectMetadata
	(*GcsBucketMetadata)(nil),          // 5: google.storagetransfer.logging.GcsBucketMetadata
	(*AzureBlobMetadata)(nil),          // 6: google.storagetransfer.logging.AzureBlobMetadata
	(*AzureBlobContainerMetadata)(nil), // 7: google.storagetransfer.logging.AzureBlobContainerMetadata
	(*PosixFileMetadata)(nil),          // 8: google.storagetransfer.logging.PosixFileMetadata
	(*HttpFileMetadata)(nil),           // 9: google.storagetransfer.logging.HttpFileMetadata
	(*HttpManifestMetadata)(nil),       // 10: google.storagetransfer.logging.HttpManifestMetadata
	(*ObjectMetadata)(nil),             // 11: google.storagetransfer.logging.ObjectMetadata
	(*ContainerMetadata)(nil),          // 12: google.storagetransfer.logging.ContainerMetadata
	(*TransferActivityLog)(nil),        // 13: google.storagetransfer.logging.TransferActivityLog
	(*TransferActivityLog_Status)(nil), // 14: google.storagetransfer.logging.TransferActivityLog.Status
	(*timestamppb.Timestamp)(nil),      // 15: google.protobuf.Timestamp
}
var file_google_storagetransfer_logging_transfer_activity_log_proto_depIdxs = []int32{
	15, // 0: google.storagetransfer.logging.AwsS3ObjectMetadata.last_modified_time:type_name -> google.protobuf.Timestamp
	15, // 1: google.storagetransfer.logging.GcsObjectMetadata.last_modified_time:type_name -> google.protobuf.Timestamp
	15, // 2: google.storagetransfer.logging.AzureBlobMetadata.last_modified_time:type_name -> google.protobuf.Timestamp
	15, // 3: google.storagetransfer.logging.PosixFileMetadata.last_modified_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.storagetransfer.logging.ObjectMetadata.type:type_name -> google.storagetransfer.logging.StorageSystemType
	2,  // 5: google.storagetransfer.logging.ObjectMetadata.aws_s3_object:type_name -> google.storagetransfer.logging.AwsS3ObjectMetadata
	6,  // 6: google.storagetransfer.logging.ObjectMetadata.azure_blob:type_name -> google.storagetransfer.logging.AzureBlobMetadata
	4,  // 7: google.storagetransfer.logging.ObjectMetadata.gcs_object:type_name -> google.storagetransfer.logging.GcsObjectMetadata
	8,  // 8: google.storagetransfer.logging.ObjectMetadata.posix_file:type_name -> google.storagetransfer.logging.PosixFileMetadata
	9,  // 9: google.storagetransfer.logging.ObjectMetadata.http_file:type_name -> google.storagetransfer.logging.HttpFileMetadata
	0,  // 10: google.storagetransfer.logging.ContainerMetadata.type:type_name -> google.storagetransfer.logging.StorageSystemType
	3,  // 11: google.storagetransfer.logging.ContainerMetadata.aws_s3_bucket:type_name -> google.storagetransfer.logging.AwsS3BucketMetadata
	7,  // 12: google.storagetransfer.logging.ContainerMetadata.azure_blob_container:type_name -> google.storagetransfer.logging.AzureBlobContainerMetadata
	5,  // 13: google.storagetransfer.logging.ContainerMetadata.gcs_bucket:type_name -> google.storagetransfer.logging.GcsBucketMetadata
	8,  // 14: google.storagetransfer.logging.ContainerMetadata.posix_directory:type_name -> google.storagetransfer.logging.PosixFileMetadata
	10, // 15: google.storagetransfer.logging.ContainerMetadata.http_manifest:type_name -> google.storagetransfer.logging.HttpManifestMetadata
	1,  // 16: google.storagetransfer.logging.TransferActivityLog.action:type_name -> google.storagetransfer.logging.TransferActivityLog.Action
	14, // 17: google.storagetransfer.logging.TransferActivityLog.status:type_name -> google.storagetransfer.logging.TransferActivityLog.Status
	12, // 18: google.storagetransfer.logging.TransferActivityLog.source_container:type_name -> google.storagetransfer.logging.ContainerMetadata
	12, // 19: google.storagetransfer.logging.TransferActivityLog.destination_container:type_name -> google.storagetransfer.logging.ContainerMetadata
	11, // 20: google.storagetransfer.logging.TransferActivityLog.source_object:type_name -> google.storagetransfer.logging.ObjectMetadata
	11, // 21: google.storagetransfer.logging.TransferActivityLog.destination_object:type_name -> google.storagetransfer.logging.ObjectMetadata
	15, // 22: google.storagetransfer.logging.TransferActivityLog.complete_time:type_name -> google.protobuf.Timestamp
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_storagetransfer_logging_transfer_activity_log_proto_init() }
func file_google_storagetransfer_logging_transfer_activity_log_proto_init() {
	if File_google_storagetransfer_logging_transfer_activity_log_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsS3ObjectMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsS3BucketMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsObjectMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsBucketMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureBlobMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureBlobContainerMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PosixFileMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpFileMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpManifestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferActivityLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferActivityLog_Status); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ObjectMetadata_AwsS3Object)(nil),
		(*ObjectMetadata_AzureBlob)(nil),
		(*ObjectMetadata_GcsObject)(nil),
		(*ObjectMetadata_PosixFile)(nil),
		(*ObjectMetadata_HttpFile)(nil),
	}
	file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ContainerMetadata_AwsS3Bucket)(nil),
		(*ContainerMetadata_AzureBlobContainer)(nil),
		(*ContainerMetadata_GcsBucket)(nil),
		(*ContainerMetadata_PosixDirectory)(nil),
		(*ContainerMetadata_HttpManifest)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storagetransfer_logging_transfer_activity_log_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_storagetransfer_logging_transfer_activity_log_proto_goTypes,
		DependencyIndexes: file_google_storagetransfer_logging_transfer_activity_log_proto_depIdxs,
		EnumInfos:         file_google_storagetransfer_logging_transfer_activity_log_proto_enumTypes,
		MessageInfos:      file_google_storagetransfer_logging_transfer_activity_log_proto_msgTypes,
	}.Build()
	File_google_storagetransfer_logging_transfer_activity_log_proto = out.File
	file_google_storagetransfer_logging_transfer_activity_log_proto_rawDesc = nil
	file_google_storagetransfer_logging_transfer_activity_log_proto_goTypes = nil
	file_google_storagetransfer_logging_transfer_activity_log_proto_depIdxs = nil
}
