// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1beta1/schema/trainingjob/definition/automl_time_series_forecasting.proto

package definition

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A TrainingJob that trains and uploads an AutoML Forecasting Model.
type AutoMlForecasting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input parameters of this TrainingJob.
	Inputs *AutoMlForecastingInputs `protobuf:"bytes,1,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// The metadata information.
	Metadata *AutoMlForecastingMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *AutoMlForecasting) Reset() {
	*x = AutoMlForecasting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecasting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecasting) ProtoMessage() {}

func (x *AutoMlForecasting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecasting.ProtoReflect.Descriptor instead.
func (*AutoMlForecasting) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{0}
}

func (x *AutoMlForecasting) GetInputs() *AutoMlForecastingInputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *AutoMlForecasting) GetMetadata() *AutoMlForecastingMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type AutoMlForecastingInputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the column that the model is to predict.
	TargetColumn string `protobuf:"bytes,1,opt,name=target_column,json=targetColumn,proto3" json:"target_column,omitempty"`
	// The name of the column that identifies the time series.
	TimeSeriesIdentifierColumn string `protobuf:"bytes,2,opt,name=time_series_identifier_column,json=timeSeriesIdentifierColumn,proto3" json:"time_series_identifier_column,omitempty"`
	// The name of the column that identifies time order in the time series.
	TimeColumn string `protobuf:"bytes,3,opt,name=time_column,json=timeColumn,proto3" json:"time_column,omitempty"`
	// Each transformation will apply transform function to given input column.
	// And the result will be used for training.
	// When creating transformation for BigQuery Struct column, the column should
	// be flattened using "." as the delimiter.
	Transformations []*AutoMlForecastingInputs_Transformation `protobuf:"bytes,4,rep,name=transformations,proto3" json:"transformations,omitempty"`
	// Objective function the model is optimizing towards. The training process
	// creates a model that optimizes the value of the objective
	// function over the validation set.
	//
	// The supported optimization objectives:
	//
	//   - "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE).
	//
	//   - "minimize-mae" - Minimize mean-absolute error (MAE).
	//
	//   - "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE).
	//
	//   - "minimize-rmspe" - Minimize root-mean-squared percentage error (RMSPE).
	//
	//   - "minimize-wape-mae" - Minimize the combination of weighted absolute
	//     percentage error (WAPE) and mean-absolute-error (MAE).
	//
	//   - "minimize-quantile-loss" - Minimize the quantile loss at the quantiles
	//     defined in `quantiles`.
	OptimizationObjective string `protobuf:"bytes,5,opt,name=optimization_objective,json=optimizationObjective,proto3" json:"optimization_objective,omitempty"`
	// Required. The train budget of creating this model, expressed in milli node
	// hours i.e. 1,000 value in this field means 1 node hour.
	//
	// The training cost of the model will not exceed this budget. The final cost
	// will be attempted to be close to the budget, though may end up being (even)
	// noticeably smaller - at the backend's discretion. This especially may
	// happen when further model training ceases to provide any improvements.
	//
	// If the budget is set to a value known to be insufficient to train a
	// model for the given dataset, the training won't be attempted and
	// will error.
	//
	// The train budget must be between 1,000 and 72,000 milli node hours,
	// inclusive.
	TrainBudgetMilliNodeHours int64 `protobuf:"varint,6,opt,name=train_budget_milli_node_hours,json=trainBudgetMilliNodeHours,proto3" json:"train_budget_milli_node_hours,omitempty"`
	// Column name that should be used as the weight column.
	// Higher values in this column give more importance to the row
	// during model training. The column must have numeric values between 0 and
	// 10000 inclusively; 0 means the row is ignored for training. If weight
	// column field is not set, then all rows are assumed to have equal weight
	// of 1.
	WeightColumn string `protobuf:"bytes,7,opt,name=weight_column,json=weightColumn,proto3" json:"weight_column,omitempty"`
	// Column names that should be used as attribute columns.
	// The value of these columns does not vary as a function of time.
	// For example, store ID or item color.
	TimeSeriesAttributeColumns []string `protobuf:"bytes,19,rep,name=time_series_attribute_columns,json=timeSeriesAttributeColumns,proto3" json:"time_series_attribute_columns,omitempty"`
	// Names of columns that are unavailable when a forecast is requested.
	// This column contains information for the given entity (identified
	// by the time_series_identifier_column) that is unknown before the forecast
	// For example, actual weather on a given day.
	UnavailableAtForecastColumns []string `protobuf:"bytes,20,rep,name=unavailable_at_forecast_columns,json=unavailableAtForecastColumns,proto3" json:"unavailable_at_forecast_columns,omitempty"`
	// Names of columns that are available and provided when a forecast
	// is requested. These columns
	// contain information for the given entity (identified by the
	// time_series_identifier_column column) that is known at forecast.
	// For example, predicted weather for a specific day.
	AvailableAtForecastColumns []string `protobuf:"bytes,21,rep,name=available_at_forecast_columns,json=availableAtForecastColumns,proto3" json:"available_at_forecast_columns,omitempty"`
	// Expected difference in time granularity between rows in the data.
	DataGranularity *AutoMlForecastingInputs_Granularity `protobuf:"bytes,22,opt,name=data_granularity,json=dataGranularity,proto3" json:"data_granularity,omitempty"`
	// The amount of time into the future for which forecasted values for the
	// target are returned. Expressed in number of units defined by the
	// `data_granularity` field.
	ForecastHorizon int64 `protobuf:"varint,23,opt,name=forecast_horizon,json=forecastHorizon,proto3" json:"forecast_horizon,omitempty"`
	// The amount of time into the past training and prediction data is used
	// for model training and prediction respectively. Expressed in number of
	// units defined by the `data_granularity` field.
	ContextWindow int64 `protobuf:"varint,24,opt,name=context_window,json=contextWindow,proto3" json:"context_window,omitempty"`
	// Configuration for exporting test set predictions to a BigQuery table. If
	// this configuration is absent, then the export is not performed.
	ExportEvaluatedDataItemsConfig *ExportEvaluatedDataItemsConfig `protobuf:"bytes,15,opt,name=export_evaluated_data_items_config,json=exportEvaluatedDataItemsConfig,proto3" json:"export_evaluated_data_items_config,omitempty"`
	// Quantiles to use for minimize-quantile-loss `optimization_objective`. Up to
	// 5 quantiles are allowed of values between 0 and 1, exclusive. Required if
	// the value of optimization_objective is minimize-quantile-loss. Represents
	// the percent quantiles to use for that objective. Quantiles must be unique.
	Quantiles []float64 `protobuf:"fixed64,16,rep,packed,name=quantiles,proto3" json:"quantiles,omitempty"`
	// Validation options for the data validation component. The available options
	// are:
	//
	//   - "fail-pipeline" - default, will validate against the validation and
	//     fail the pipeline if it fails.
	//
	//   - "ignore-validation" - ignore the results of the validation and continue
	ValidationOptions string `protobuf:"bytes,17,opt,name=validation_options,json=validationOptions,proto3" json:"validation_options,omitempty"`
	// Additional experiment flags for the time series forcasting training.
	AdditionalExperiments []string `protobuf:"bytes,25,rep,name=additional_experiments,json=additionalExperiments,proto3" json:"additional_experiments,omitempty"`
}

func (x *AutoMlForecastingInputs) Reset() {
	*x = AutoMlForecastingInputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs) ProtoMessage() {}

func (x *AutoMlForecastingInputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1}
}

func (x *AutoMlForecastingInputs) GetTargetColumn() string {
	if x != nil {
		return x.TargetColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTimeSeriesIdentifierColumn() string {
	if x != nil {
		return x.TimeSeriesIdentifierColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTimeColumn() string {
	if x != nil {
		return x.TimeColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTransformations() []*AutoMlForecastingInputs_Transformation {
	if x != nil {
		return x.Transformations
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetOptimizationObjective() string {
	if x != nil {
		return x.OptimizationObjective
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTrainBudgetMilliNodeHours() int64 {
	if x != nil {
		return x.TrainBudgetMilliNodeHours
	}
	return 0
}

func (x *AutoMlForecastingInputs) GetWeightColumn() string {
	if x != nil {
		return x.WeightColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTimeSeriesAttributeColumns() []string {
	if x != nil {
		return x.TimeSeriesAttributeColumns
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetUnavailableAtForecastColumns() []string {
	if x != nil {
		return x.UnavailableAtForecastColumns
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetAvailableAtForecastColumns() []string {
	if x != nil {
		return x.AvailableAtForecastColumns
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetDataGranularity() *AutoMlForecastingInputs_Granularity {
	if x != nil {
		return x.DataGranularity
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetForecastHorizon() int64 {
	if x != nil {
		return x.ForecastHorizon
	}
	return 0
}

func (x *AutoMlForecastingInputs) GetContextWindow() int64 {
	if x != nil {
		return x.ContextWindow
	}
	return 0
}

func (x *AutoMlForecastingInputs) GetExportEvaluatedDataItemsConfig() *ExportEvaluatedDataItemsConfig {
	if x != nil {
		return x.ExportEvaluatedDataItemsConfig
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetQuantiles() []float64 {
	if x != nil {
		return x.Quantiles
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetValidationOptions() string {
	if x != nil {
		return x.ValidationOptions
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetAdditionalExperiments() []string {
	if x != nil {
		return x.AdditionalExperiments
	}
	return nil
}

// Model metadata specific to AutoML Forecasting.
type AutoMlForecastingMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The actual training cost of the model, expressed in milli
	// node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed
	// to not exceed the train budget.
	TrainCostMilliNodeHours int64 `protobuf:"varint,1,opt,name=train_cost_milli_node_hours,json=trainCostMilliNodeHours,proto3" json:"train_cost_milli_node_hours,omitempty"`
}

func (x *AutoMlForecastingMetadata) Reset() {
	*x = AutoMlForecastingMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingMetadata) ProtoMessage() {}

func (x *AutoMlForecastingMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingMetadata.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{2}
}

func (x *AutoMlForecastingMetadata) GetTrainCostMilliNodeHours() int64 {
	if x != nil {
		return x.TrainCostMilliNodeHours
	}
	return 0
}

type AutoMlForecastingInputs_Transformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transformation that the training pipeline will apply to the input
	// columns.
	//
	// Types that are assignable to TransformationDetail:
	//
	//	*AutoMlForecastingInputs_Transformation_Auto
	//	*AutoMlForecastingInputs_Transformation_Numeric
	//	*AutoMlForecastingInputs_Transformation_Categorical
	//	*AutoMlForecastingInputs_Transformation_Timestamp
	//	*AutoMlForecastingInputs_Transformation_Text
	TransformationDetail isAutoMlForecastingInputs_Transformation_TransformationDetail `protobuf_oneof:"transformation_detail"`
}

func (x *AutoMlForecastingInputs_Transformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1, 0}
}

func (m *AutoMlForecastingInputs_Transformation) GetTransformationDetail() isAutoMlForecastingInputs_Transformation_TransformationDetail {
	if m != nil {
		return m.TransformationDetail
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetAuto() *AutoMlForecastingInputs_Transformation_AutoTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Auto); ok {
		return x.Auto
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetNumeric() *AutoMlForecastingInputs_Transformation_NumericTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Numeric); ok {
		return x.Numeric
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetCategorical() *AutoMlForecastingInputs_Transformation_CategoricalTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Categorical); ok {
		return x.Categorical
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetTimestamp() *AutoMlForecastingInputs_Transformation_TimestampTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetText() *AutoMlForecastingInputs_Transformation_TextTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Text); ok {
		return x.Text
	}
	return nil
}

type isAutoMlForecastingInputs_Transformation_TransformationDetail interface {
	isAutoMlForecastingInputs_Transformation_TransformationDetail()
}

type AutoMlForecastingInputs_Transformation_Auto struct {
	Auto *AutoMlForecastingInputs_Transformation_AutoTransformation `protobuf:"bytes,1,opt,name=auto,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Numeric struct {
	Numeric *AutoMlForecastingInputs_Transformation_NumericTransformation `protobuf:"bytes,2,opt,name=numeric,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Categorical struct {
	Categorical *AutoMlForecastingInputs_Transformation_CategoricalTransformation `protobuf:"bytes,3,opt,name=categorical,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Timestamp struct {
	Timestamp *AutoMlForecastingInputs_Transformation_TimestampTransformation `protobuf:"bytes,4,opt,name=timestamp,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Text struct {
	Text *AutoMlForecastingInputs_Transformation_TextTransformation `protobuf:"bytes,5,opt,name=text,proto3,oneof"`
}

func (*AutoMlForecastingInputs_Transformation_Auto) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Numeric) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Categorical) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Timestamp) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Text) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

// A duration of time expressed in time granularity units.
type AutoMlForecastingInputs_Granularity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time granularity unit of this time period.
	// The supported units are:
	//
	//   - "minute"
	//
	//   - "hour"
	//
	//   - "day"
	//
	//   - "week"
	//
	//   - "month"
	//
	//   - "year"
	Unit string `protobuf:"bytes,1,opt,name=unit,proto3" json:"unit,omitempty"`
	// The number of granularity_units between data points in the training
	// data. If `granularity_unit` is `minute`,
	// can be 1, 5, 10, 15, or 30. For all other values of `granularity_unit`,
	// must be 1.
	Quantity int64 `protobuf:"varint,2,opt,name=quantity,proto3" json:"quantity,omitempty"`
}

func (x *AutoMlForecastingInputs_Granularity) Reset() {
	*x = AutoMlForecastingInputs_Granularity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Granularity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Granularity) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Granularity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Granularity.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Granularity) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1, 1}
}

func (x *AutoMlForecastingInputs_Granularity) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (x *AutoMlForecastingInputs_Granularity) GetQuantity() int64 {
	if x != nil {
		return x.Quantity
	}
	return 0
}

// Training pipeline will infer the proper transformation based on the
// statistic of dataset.
type AutoMlForecastingInputs_Transformation_AutoTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_AutoTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_AutoTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_AutoTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_AutoTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Training pipeline will perform following transformation functions.
//
// *  The value converted to float32.
//
// *  The z_score of the value.
//
//   - log(value+1) when the value is greater than or equal to 0. Otherwise,
//     this transformation is not applied and the value is considered a
//     missing value.
//
//   - z_score of log(value+1) when the value is greater than or equal to 0.
//     Otherwise, this transformation is not applied and the value is
//     considered a missing value.
//
// *  A boolean value that indicates whether the value is valid.
type AutoMlForecastingInputs_Transformation_NumericTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_NumericTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_NumericTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_NumericTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_NumericTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1, 0, 1}
}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Training pipeline will perform following transformation functions.
//
//   - The categorical string as is--no change to case, punctuation,
//     spelling, tense, and so on.
//
//   - Convert the category name to a dictionary lookup index and generate an
//     embedding for each index.
//
//   - Categories that appear less than 5 times in the training dataset are
//     treated as the "unknown" category. The "unknown" category gets its own
//     special lookup index and resulting embedding.
type AutoMlForecastingInputs_Transformation_CategoricalTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_CategoricalTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_CategoricalTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_CategoricalTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_CategoricalTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1, 0, 2}
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Training pipeline will perform following transformation functions.
//
// *  Apply the transformation functions for Numerical columns.
//
//   - Determine the year, month, day,and weekday. Treat each value from the
//     timestamp as a Categorical column.
//
//   - Invalid numerical values (for example, values that fall outside of a
//     typical timestamp range, or are extreme values) receive no special
//     treatment and are not removed.
type AutoMlForecastingInputs_Transformation_TimestampTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// The format in which that time field is expressed. The time_format must
	// either be one of:
	//
	// * `unix-seconds`
	//
	// * `unix-milliseconds`
	//
	// * `unix-microseconds`
	//
	// * `unix-nanoseconds`
	//
	// (for respectively number of seconds, milliseconds, microseconds and
	// nanoseconds since start of the Unix epoch);
	//
	// or be written in `strftime` syntax.
	//
	// If time_format is not set, then the
	// default format is RFC 3339 `date-time` format, where
	// `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z)
	TimeFormat string `protobuf:"bytes,2,opt,name=time_format,json=timeFormat,proto3" json:"time_format,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_TimestampTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_TimestampTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_TimestampTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_TimestampTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1, 0, 3}
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) GetTimeFormat() string {
	if x != nil {
		return x.TimeFormat
	}
	return ""
}

// Training pipeline will perform following transformation functions.
//
//   - The text as is--no change to case, punctuation, spelling, tense, and
//     so on.
//
//   - Convert the category name to a dictionary lookup index and generate an
//     embedding for each index.
type AutoMlForecastingInputs_Transformation_TextTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_TextTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_TextTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_TextTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_TextTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP(), []int{1, 0, 4}
}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDesc = []byte{
	0x0a, 0x62, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x66, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x01, 0x0a, 0x11,
	0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0x6e, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x12, 0x74, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe1, 0x12, 0x0a, 0x17, 0x41, 0x75, 0x74, 0x6f,
	0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x41, 0x0a, 0x1d, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x1a, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x8f, 0x01, 0x0a,
	0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35,
	0x0a, 0x16, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x40, 0x0a, 0x1d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e, 0x6f,
	0x64, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x41, 0x0a, 0x1d,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x13, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x1a, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12,
	0x45, 0x0a, 0x1f, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61,
	0x74, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1c, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x74, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x61, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1a, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x74, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x10, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x47, 0x72, 0x61,
	0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x47, 0x72,
	0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x66, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x18, 0x17, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x48, 0x6f, 0x72,
	0x69, 0x7a, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x18, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0xa9, 0x01, 0x0a, 0x22,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x6e, 0x74,
	0x69, 0x6c, 0x65, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x01, 0x52, 0x09, 0x71, 0x75, 0x61, 0x6e,
	0x74, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x16, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x19,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xee, 0x08, 0x0a, 0x0e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e,
	0x01, 0x0a, 0x04, 0x61, 0x75, 0x74, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a,
	0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x04, 0x61, 0x75, 0x74, 0x6f, 0x12,
	0x97, 0x01, 0x0a, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x7b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x12, 0xa3, 0x01, 0x0a, 0x0b, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x7f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x12,
	0x9d, 0x01, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x7d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x8e, 0x01, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x1a, 0x35, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x38, 0x0a, 0x15, 0x4e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x1a, 0x3c, 0x0a, 0x19, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a,
	0x5b, 0x0a, 0x17, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0x35, 0x0a, 0x12,
	0x54, 0x65, 0x78, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x1a, 0x3d, 0x0a, 0x0b,
	0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x75,
	0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x59, 0x0a, 0x19, 0x41,
	0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3c, 0x0a, 0x1b, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e, 0x6f, 0x64,
	0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x42, 0x8c, 0x03, 0x0a, 0x41, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f,
	0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x16, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x4c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x67, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x3b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0xaa,
	0x02, 0x3d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x4a, 0x6f, 0x62, 0x2e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0xca,
	0x02, 0x3d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x5c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x4a, 0x6f, 0x62, 0x5c, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0xea,
	0x02, 0x43, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x3a, 0x3a, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x3a, 0x3a, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x3a, 0x3a, 0x44, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_goTypes = []interface{}{
	(*AutoMlForecasting)(nil),                                                // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecasting
	(*AutoMlForecastingInputs)(nil),                                          // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs
	(*AutoMlForecastingMetadata)(nil),                                        // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingMetadata
	(*AutoMlForecastingInputs_Transformation)(nil),                           // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation
	(*AutoMlForecastingInputs_Granularity)(nil),                              // 4: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Granularity
	(*AutoMlForecastingInputs_Transformation_AutoTransformation)(nil),        // 5: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.AutoTransformation
	(*AutoMlForecastingInputs_Transformation_NumericTransformation)(nil),     // 6: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.NumericTransformation
	(*AutoMlForecastingInputs_Transformation_CategoricalTransformation)(nil), // 7: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.CategoricalTransformation
	(*AutoMlForecastingInputs_Transformation_TimestampTransformation)(nil),   // 8: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TimestampTransformation
	(*AutoMlForecastingInputs_Transformation_TextTransformation)(nil),        // 9: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TextTransformation
	(*ExportEvaluatedDataItemsConfig)(nil),                                   // 10: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.ExportEvaluatedDataItemsConfig
}
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecasting.inputs:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs
	2,  // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecasting.metadata:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingMetadata
	3,  // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.transformations:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation
	4,  // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.data_granularity:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Granularity
	10, // 4: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.export_evaluated_data_items_config:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.ExportEvaluatedDataItemsConfig
	5,  // 5: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.auto:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.AutoTransformation
	6,  // 6: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.numeric:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.NumericTransformation
	7,  // 7: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.categorical:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.CategoricalTransformation
	8,  // 8: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.timestamp:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TimestampTransformation
	9,  // 9: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.text:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TextTransformation
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_init()
}
func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_export_evaluated_data_items_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecasting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Granularity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_AutoTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_NumericTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_CategoricalTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_TimestampTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_TextTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*AutoMlForecastingInputs_Transformation_Auto)(nil),
		(*AutoMlForecastingInputs_Transformation_Numeric)(nil),
		(*AutoMlForecastingInputs_Transformation_Categorical)(nil),
		(*AutoMlForecastingInputs_Transformation_Timestamp)(nil),
		(*AutoMlForecastingInputs_Transformation_Text)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_time_series_forecasting_proto_depIdxs = nil
}
