// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/timeseriesinsights/v1/timeseries_insights.proto

package timeseriesinsights

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// DataSet state.
type DataSet_State int32

const (
	// Unspecified / undefined state.
	DataSet_STATE_UNSPECIFIED DataSet_State = 0
	// Dataset is unknown to the system; we have never seen this dataset before
	// or we have seen this dataset but have fully GC-ed it.
	DataSet_UNKNOWN DataSet_State = 1
	// Dataset processing is pending.
	DataSet_PENDING DataSet_State = 2
	// Dataset is loading.
	DataSet_LOADING DataSet_State = 3
	// Dataset is loaded and can be queried.
	DataSet_LOADED DataSet_State = 4
	// Dataset is unloading.
	DataSet_UNLOADING DataSet_State = 5
	// Dataset is unloaded and is removed from the system.
	DataSet_UNLOADED DataSet_State = 6
	// Dataset processing failed.
	DataSet_FAILED DataSet_State = 7
)

// Enum value maps for DataSet_State.
var (
	DataSet_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "UNKNOWN",
		2: "PENDING",
		3: "LOADING",
		4: "LOADED",
		5: "UNLOADING",
		6: "UNLOADED",
		7: "FAILED",
	}
	DataSet_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"UNKNOWN":           1,
		"PENDING":           2,
		"LOADING":           3,
		"LOADED":            4,
		"UNLOADING":         5,
		"UNLOADED":          6,
		"FAILED":            7,
	}
)

func (x DataSet_State) Enum() *DataSet_State {
	p := new(DataSet_State)
	*p = x
	return p
}

func (x DataSet_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSet_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes[0].Descriptor()
}

func (DataSet_State) Type() protoreflect.EnumType {
	return &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes[0]
}

func (x DataSet_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSet_State.Descriptor instead.
func (DataSet_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{2, 0}
}

// A time period of a fixed interval.
type ForecastParams_Period int32

const (
	// Unknown or simply not given.
	ForecastParams_PERIOD_UNSPECIFIED ForecastParams_Period = 0
	// 1 hour
	ForecastParams_HOURLY ForecastParams_Period = 5
	// 24 hours
	ForecastParams_DAILY ForecastParams_Period = 1
	// 7 days
	ForecastParams_WEEKLY ForecastParams_Period = 2
	// 30 days
	ForecastParams_MONTHLY ForecastParams_Period = 3
	// 365 days
	ForecastParams_YEARLY ForecastParams_Period = 4
)

// Enum value maps for ForecastParams_Period.
var (
	ForecastParams_Period_name = map[int32]string{
		0: "PERIOD_UNSPECIFIED",
		5: "HOURLY",
		1: "DAILY",
		2: "WEEKLY",
		3: "MONTHLY",
		4: "YEARLY",
	}
	ForecastParams_Period_value = map[string]int32{
		"PERIOD_UNSPECIFIED": 0,
		"HOURLY":             5,
		"DAILY":              1,
		"WEEKLY":             2,
		"MONTHLY":            3,
		"YEARLY":             4,
	}
)

func (x ForecastParams_Period) Enum() *ForecastParams_Period {
	p := new(ForecastParams_Period)
	*p = x
	return p
}

func (x ForecastParams_Period) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForecastParams_Period) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes[1].Descriptor()
}

func (ForecastParams_Period) Type() protoreflect.EnumType {
	return &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes[1]
}

func (x ForecastParams_Period) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForecastParams_Period.Descriptor instead.
func (ForecastParams_Period) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{12, 0}
}

// Methods by which we can aggregate multiple events by a given
// [metric][google.cloud.timeseriesinsights.v1.TimeseriesParams.metric].
type TimeseriesParams_AggregationMethod int32

const (
	// Unspecified.
	TimeseriesParams_AGGREGATION_METHOD_UNSPECIFIED TimeseriesParams_AggregationMethod = 0
	// Aggregate multiple events by summing up the values found in the
	// [metric][google.cloud.timeseriesinsights.v1.TimeseriesParams.metric]
	// dimension.
	TimeseriesParams_SUM TimeseriesParams_AggregationMethod = 1
	// Aggregate multiple events by averaging out the values found in the
	// [metric][google.cloud.timeseriesinsights.v1.TimeseriesParams.metric]
	// dimension.
	TimeseriesParams_AVERAGE TimeseriesParams_AggregationMethod = 2
)

// Enum value maps for TimeseriesParams_AggregationMethod.
var (
	TimeseriesParams_AggregationMethod_name = map[int32]string{
		0: "AGGREGATION_METHOD_UNSPECIFIED",
		1: "SUM",
		2: "AVERAGE",
	}
	TimeseriesParams_AggregationMethod_value = map[string]int32{
		"AGGREGATION_METHOD_UNSPECIFIED": 0,
		"SUM":                            1,
		"AVERAGE":                        2,
	}
)

func (x TimeseriesParams_AggregationMethod) Enum() *TimeseriesParams_AggregationMethod {
	p := new(TimeseriesParams_AggregationMethod)
	*p = x
	return p
}

func (x TimeseriesParams_AggregationMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TimeseriesParams_AggregationMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes[2].Descriptor()
}

func (TimeseriesParams_AggregationMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes[2]
}

func (x TimeseriesParams_AggregationMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TimeseriesParams_AggregationMethod.Descriptor instead.
func (TimeseriesParams_AggregationMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{17, 0}
}

// Mapping of BigQuery columns to timestamp, group_id and dimensions.
type BigqueryMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The column which should be used as the event timestamps. If not specified
	// 'Timestamp' is used by default. The column may have TIMESTAMP or INT64
	// type (the latter is interpreted as microseconds since the Unix epoch).
	TimestampColumn string `protobuf:"bytes,1,opt,name=timestamp_column,json=timestampColumn,proto3" json:"timestamp_column,omitempty"`
	// The column which should be used as the group ID (grouping events into
	// sessions). If not specified 'GroupId' is used by default, if the input
	// table does not have such a column, random unique group IDs are
	// generated automatically (different group ID per input row).
	GroupIdColumn string `protobuf:"bytes,2,opt,name=group_id_column,json=groupIdColumn,proto3" json:"group_id_column,omitempty"`
	// The list of columns that should be translated to dimensions. If empty,
	// all columns are translated to dimensions. The timestamp and group_id
	// columns should not be listed here again. Columns are expected to have
	// primitive types (STRING, INT64, FLOAT64 or NUMERIC).
	DimensionColumn []string `protobuf:"bytes,3,rep,name=dimension_column,json=dimensionColumn,proto3" json:"dimension_column,omitempty"`
}

func (x *BigqueryMapping) Reset() {
	*x = BigqueryMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigqueryMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigqueryMapping) ProtoMessage() {}

func (x *BigqueryMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigqueryMapping.ProtoReflect.Descriptor instead.
func (*BigqueryMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{0}
}

func (x *BigqueryMapping) GetTimestampColumn() string {
	if x != nil {
		return x.TimestampColumn
	}
	return ""
}

func (x *BigqueryMapping) GetGroupIdColumn() string {
	if x != nil {
		return x.GroupIdColumn
	}
	return ""
}

func (x *BigqueryMapping) GetDimensionColumn() []string {
	if x != nil {
		return x.DimensionColumn
	}
	return nil
}

// A data source consists of multiple [Event] stored on
// Cloud Storage.  Each Event should be in JSON format, with one Event
// per line, also known as JSON Lines format.
type DataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data source URI.
	//
	// 1) Google Cloud Storage files (JSON) are defined in the following form.
	// `gs://bucket_name/object_name`. For more information on Cloud Storage URIs,
	// please see https://cloud.google.com/storage/docs/reference-uris.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// For BigQuery inputs defines the columns that should be used for dimensions
	// (including time and group ID).
	BqMapping *BigqueryMapping `protobuf:"bytes,2,opt,name=bq_mapping,json=bqMapping,proto3" json:"bq_mapping,omitempty"`
}

func (x *DataSource) Reset() {
	*x = DataSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSource) ProtoMessage() {}

func (x *DataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSource.ProtoReflect.Descriptor instead.
func (*DataSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{1}
}

func (x *DataSource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *DataSource) GetBqMapping() *BigqueryMapping {
	if x != nil {
		return x.BqMapping
	}
	return nil
}

// A collection of data sources sent for processing.
type DataSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dataset name, which will be used for querying, status and unload
	// requests. This must be unique within a project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// [Data dimension
	// names][google.cloud.timeseriesinsights.v1.EventDimension.name] allowed for
	// this DataSet.
	//
	// If left empty, all dimension names are included. This field works as a
	// filter to avoid regenerating the data.
	DataNames []string `protobuf:"bytes,2,rep,name=data_names,json=dataNames,proto3" json:"data_names,omitempty"`
	// Input data.
	DataSources []*DataSource `protobuf:"bytes,3,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	// Dataset state in the system.
	State DataSet_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.timeseriesinsights.v1.DataSet_State" json:"state,omitempty"`
	// Dataset processing status.
	Status *status.Status `protobuf:"bytes,5,opt,name=status,proto3" json:"status,omitempty"`
	// Periodically we discard dataset [Event] that have timestamps older than
	// 'ttl'.  Omitting this field or a zero value means no events are discarded.
	Ttl *durationpb.Duration `protobuf:"bytes,6,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *DataSet) Reset() {
	*x = DataSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSet) ProtoMessage() {}

func (x *DataSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSet.ProtoReflect.Descriptor instead.
func (*DataSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{2}
}

func (x *DataSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSet) GetDataNames() []string {
	if x != nil {
		return x.DataNames
	}
	return nil
}

func (x *DataSet) GetDataSources() []*DataSource {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *DataSet) GetState() DataSet_State {
	if x != nil {
		return x.State
	}
	return DataSet_STATE_UNSPECIFIED
}

func (x *DataSet) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *DataSet) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// Represents an event dimension.
type EventDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dimension name.
	//
	// **NOTE**: EventDimension names must be composed of alphanumeric characters
	// only, and are case insensitive. Unicode characters are *not* supported. The
	// underscore '_' is also allowed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Dimension value.
	//
	// **NOTE**: All entries of the dimension `name` must have the same `value`
	// type.
	//
	// Types that are assignable to Value:
	//
	//	*EventDimension_StringVal
	//	*EventDimension_LongVal
	//	*EventDimension_BoolVal
	//	*EventDimension_DoubleVal
	Value isEventDimension_Value `protobuf_oneof:"value"`
}

func (x *EventDimension) Reset() {
	*x = EventDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventDimension) ProtoMessage() {}

func (x *EventDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventDimension.ProtoReflect.Descriptor instead.
func (*EventDimension) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{3}
}

func (x *EventDimension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *EventDimension) GetValue() isEventDimension_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *EventDimension) GetStringVal() string {
	if x, ok := x.GetValue().(*EventDimension_StringVal); ok {
		return x.StringVal
	}
	return ""
}

func (x *EventDimension) GetLongVal() int64 {
	if x, ok := x.GetValue().(*EventDimension_LongVal); ok {
		return x.LongVal
	}
	return 0
}

func (x *EventDimension) GetBoolVal() bool {
	if x, ok := x.GetValue().(*EventDimension_BoolVal); ok {
		return x.BoolVal
	}
	return false
}

func (x *EventDimension) GetDoubleVal() float64 {
	if x, ok := x.GetValue().(*EventDimension_DoubleVal); ok {
		return x.DoubleVal
	}
	return 0
}

type isEventDimension_Value interface {
	isEventDimension_Value()
}

type EventDimension_StringVal struct {
	// String representation.
	//
	// **NOTE**: String values are case insensitive. Unicode characters are
	// supported.
	StringVal string `protobuf:"bytes,2,opt,name=string_val,json=stringVal,proto3,oneof"`
}

type EventDimension_LongVal struct {
	// Long representation.
	LongVal int64 `protobuf:"varint,3,opt,name=long_val,json=longVal,proto3,oneof"`
}

type EventDimension_BoolVal struct {
	// Bool representation.
	BoolVal bool `protobuf:"varint,4,opt,name=bool_val,json=boolVal,proto3,oneof"`
}

type EventDimension_DoubleVal struct {
	// Double representation.
	DoubleVal float64 `protobuf:"fixed64,5,opt,name=double_val,json=doubleVal,proto3,oneof"`
}

func (*EventDimension_StringVal) isEventDimension_Value() {}

func (*EventDimension_LongVal) isEventDimension_Value() {}

func (*EventDimension_BoolVal) isEventDimension_Value() {}

func (*EventDimension_DoubleVal) isEventDimension_Value() {}

// Represents an entry in a data source.
//
// Each Event has:
//
//   - A timestamp at which the event occurs.
//   - One or multiple dimensions.
//   - Optionally, a group ID that allows clients to group logically related
//     events (for example, all events representing payments transactions done by
//     a user in a day have the same group ID).  If a group ID is not provided, an
//     internal one will be generated based on the content and `eventTime`.
//
// **NOTE**:
//
//   - Internally, we discretize time in equal-sized chunks and we assume an
//     event has a 0
//     [TimeseriesPoint.value][google.cloud.timeseriesinsights.v1.TimeseriesPoint.value]
//     in a chunk that does not contain any occurrences of an event in the input.
//   - The number of Events with the same group ID should be limited.
//   - Group ID *cannot* be queried.
//   - Group ID does *not* correspond to a user ID or the like. If a user ID is of
//     interest to be queried, use a user ID `dimension` instead.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Event dimensions.
	Dimensions []*EventDimension `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// Event group ID.
	//
	// **NOTE**: JSON encoding should use a string to hold a 64-bit integer value,
	// because a native JSON number holds only 53 binary bits for an integer.
	GroupId int64 `protobuf:"varint,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Event timestamp.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{4}
}

func (x *Event) GetDimensions() []*EventDimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *Event) GetGroupId() int64 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *Event) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

// Appends events to an existing DataSet.
type AppendEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Events to be appended.
	//
	// **NOTE**:
	//
	//  0. The [DataSet] must be shown in a `LOADED` state
	//     in the results of [list method][ListDataSet]; otherwise, all events from
	//     the append request will be dropped, and a `NOT_FOUND` status will be
	//     returned.
	//  0. All events in a single request must have the same
	//     [groupId][google.cloud.timeseriesinsights.v1.Event.group_id] if set;
	//     otherwise, an `INVALID_ARGUMENT` status will be returned.
	//  0. If [groupId][google.cloud.timeseriesinsights.v1.Event.group_id] is not
	//
	// set (or 0), there
	//
	//	should be only 1 event; otherwise, an `INVALID_ARGUMENT` status will be
	//	returned.
	//  0. The events must be newer than the current time minus
	//     [DataSet TTL][google.cloud.timeseriesinsights.v1.DataSet.ttl] or they
	//     will be dropped.
	Events []*Event `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	// Required. The DataSet to which we want to append to in the format of
	// "projects/{project}/datasets/{dataset}"
	Dataset string `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
}

func (x *AppendEventsRequest) Reset() {
	*x = AppendEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendEventsRequest) ProtoMessage() {}

func (x *AppendEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendEventsRequest.ProtoReflect.Descriptor instead.
func (*AppendEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{5}
}

func (x *AppendEventsRequest) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *AppendEventsRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

// Response for an AppendEvents RPC.
type AppendEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dropped events; empty if all events are successfully added.
	DroppedEvents []*Event `protobuf:"bytes,1,rep,name=dropped_events,json=droppedEvents,proto3" json:"dropped_events,omitempty"`
}

func (x *AppendEventsResponse) Reset() {
	*x = AppendEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendEventsResponse) ProtoMessage() {}

func (x *AppendEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendEventsResponse.ProtoReflect.Descriptor instead.
func (*AppendEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{6}
}

func (x *AppendEventsResponse) GetDroppedEvents() []*Event {
	if x != nil {
		return x.DroppedEvents
	}
	return nil
}

// Create a DataSet request.
type CreateDataSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Client project name which will own this DataSet in the format of
	// 'projects/{project}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Data set to be loaded.
	Dataset *DataSet `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
}

func (x *CreateDataSetRequest) Reset() {
	*x = CreateDataSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataSetRequest) ProtoMessage() {}

func (x *CreateDataSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataSetRequest.ProtoReflect.Descriptor instead.
func (*CreateDataSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{7}
}

func (x *CreateDataSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataSetRequest) GetDataset() *DataSet {
	if x != nil {
		return x.Dataset
	}
	return nil
}

// Unload DataSet request from the serving system.
type DeleteDataSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Data set name in the format of
	// "projects/{project}/datasets/{dataset}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataSetRequest) Reset() {
	*x = DeleteDataSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataSetRequest) ProtoMessage() {}

func (x *DeleteDataSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteDataSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List the DataSets created by the current project.
type ListDataSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project owning the DataSet in the format of "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataSetsRequest) Reset() {
	*x = ListDataSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSetsRequest) ProtoMessage() {}

func (x *ListDataSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSetsRequest.ProtoReflect.Descriptor instead.
func (*ListDataSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{9}
}

func (x *ListDataSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Created DataSets list response.
type ListDataSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of created DataSets.
	Datasets []*DataSet `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// Token to receive the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataSetsResponse) Reset() {
	*x = ListDataSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSetsResponse) ProtoMessage() {}

func (x *ListDataSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSetsResponse.ProtoReflect.Descriptor instead.
func (*ListDataSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{10}
}

func (x *ListDataSetsResponse) GetDatasets() []*DataSet {
	if x != nil {
		return x.Datasets
	}
	return nil
}

func (x *ListDataSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A categorical dimension fixed to a certain value.
type PinnedDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the dimension for which we are fixing its value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Dimension value.
	//
	// **NOTE**: The `value` type must match that in the data with the same
	// `dimension` as name.
	//
	// Types that are assignable to Value:
	//
	//	*PinnedDimension_StringVal
	//	*PinnedDimension_BoolVal
	Value isPinnedDimension_Value `protobuf_oneof:"value"`
}

func (x *PinnedDimension) Reset() {
	*x = PinnedDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PinnedDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PinnedDimension) ProtoMessage() {}

func (x *PinnedDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PinnedDimension.ProtoReflect.Descriptor instead.
func (*PinnedDimension) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{11}
}

func (x *PinnedDimension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *PinnedDimension) GetValue() isPinnedDimension_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *PinnedDimension) GetStringVal() string {
	if x, ok := x.GetValue().(*PinnedDimension_StringVal); ok {
		return x.StringVal
	}
	return ""
}

func (x *PinnedDimension) GetBoolVal() bool {
	if x, ok := x.GetValue().(*PinnedDimension_BoolVal); ok {
		return x.BoolVal
	}
	return false
}

type isPinnedDimension_Value interface {
	isPinnedDimension_Value()
}

type PinnedDimension_StringVal struct {
	// A string value. This can be used for
	// [dimensions][google.cloud.timeseriesinsights.v1.EventDimension] which
	// have their value field set to
	// [string_val][google.cloud.timeseriesinsights.v1.EventDimension.string_val].
	StringVal string `protobuf:"bytes,2,opt,name=string_val,json=stringVal,proto3,oneof"`
}

type PinnedDimension_BoolVal struct {
	// A bool value. This can be used for
	// [dimensions][google.cloud.timeseriesinsights.v1.EventDimension] which
	// have their value field set to
	// [bool_val][google.cloud.timeseriesinsights.v1.EventDimension.bool_val].
	BoolVal bool `protobuf:"varint,3,opt,name=bool_val,json=boolVal,proto3,oneof"`
}

func (*PinnedDimension_StringVal) isPinnedDimension_Value() {}

func (*PinnedDimension_BoolVal) isPinnedDimension_Value() {}

// Parameters that control the sensitivity and other options for the time series
// forecast.
type ForecastParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Penalize variations between the actual and forecasted values
	// smaller than this. See the [anomalyScore](EvaluatedSlice.anomaly_score)
	// formula for details on how this parameter impacts the score.
	//
	// Intuitively, anomaly scores summarize how statistically significant the
	// change between the actual and forecasted value is compared with what we
	// expect the change to be (see
	// [expectedDeviation](EvaluatedSlice.expected_deviation)). However, in
	// practice, depending on the application, changes smaller than certain
	// absolute values, while statistically significant, may not be important.
	//
	// This parameter allows us to penalize such low absolute value changes.
	//
	// Must be in the (0.0, inf) range.
	//
	// If unspecified, it defaults to 0.000001.
	NoiseThreshold *float64 `protobuf:"fixed64,12,opt,name=noise_threshold,json=noiseThreshold,proto3,oneof" json:"noise_threshold,omitempty"`
	// Optional. Specifying any known seasonality/periodicity in the time series
	// for the slices we will analyze can improve the quality of the results.
	//
	// If unsure, simply leave it unspecified by not setting a value for this
	// field.
	//
	// If your time series has multiple seasonal patterns, then set it to the most
	// granular one (e.g. if it has daily and weekly patterns, set this to DAILY).
	SeasonalityHint ForecastParams_Period `protobuf:"varint,10,opt,name=seasonality_hint,json=seasonalityHint,proto3,enum=google.cloud.timeseriesinsights.v1.ForecastParams_Period" json:"seasonality_hint,omitempty"`
	// Optional. The length of the returned [forecasted
	// timeseries][EvaluatedSlice.forecast].
	//
	// This duration is currently capped at 100 x
	// [granularity][google.cloud.timeseriesinsights.v1.TimeseriesParams.granularity].
	//
	// Example: If the detection point is set to "2020-12-27T00:00:00Z", the
	// [granularity][google.cloud.timeseriesinsights.v1.TimeseriesParams.granularity]
	// to "3600s" and the horizon_duration to "10800s", then we will generate 3
	// time series points (from "2020-12-27T01:00:00Z" to "2020-12-27T04:00:00Z"),
	// for which we will return their forecasted values.
	//
	// **NOTE**: The horizon time is only used for forecasting not for anormaly
	// detection. To detect anomalies for multiple points of time,
	// simply send multiple queries with those as
	// [detectionTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time].
	HorizonDuration *durationpb.Duration `protobuf:"bytes,13,opt,name=horizon_duration,json=horizonDuration,proto3" json:"horizon_duration,omitempty"`
}

func (x *ForecastParams) Reset() {
	*x = ForecastParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForecastParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForecastParams) ProtoMessage() {}

func (x *ForecastParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForecastParams.ProtoReflect.Descriptor instead.
func (*ForecastParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{12}
}

func (x *ForecastParams) GetNoiseThreshold() float64 {
	if x != nil && x.NoiseThreshold != nil {
		return *x.NoiseThreshold
	}
	return 0
}

func (x *ForecastParams) GetSeasonalityHint() ForecastParams_Period {
	if x != nil {
		return x.SeasonalityHint
	}
	return ForecastParams_PERIOD_UNSPECIFIED
}

func (x *ForecastParams) GetHorizonDuration() *durationpb.Duration {
	if x != nil {
		return x.HorizonDuration
	}
	return nil
}

// A point in a time series.
type TimeseriesPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp of this point.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// The value for this point.
	//
	// It is computed by aggregating all events in the associated slice that are
	// in the [time, time + granularity] range (see
	// [granularity][google.cloud.timeseriesinsights.v1.TimeseriesParams.granularity])
	// using the specified
	// [metric][google.cloud.timeseriesinsights.v1.TimeseriesParams.metric].
	Value *float64 `protobuf:"fixed64,2,opt,name=value,proto3,oneof" json:"value,omitempty"`
}

func (x *TimeseriesPoint) Reset() {
	*x = TimeseriesPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeseriesPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeseriesPoint) ProtoMessage() {}

func (x *TimeseriesPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeseriesPoint.ProtoReflect.Descriptor instead.
func (*TimeseriesPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{13}
}

func (x *TimeseriesPoint) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *TimeseriesPoint) GetValue() float64 {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return 0
}

// A time series.
type Timeseries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The points in this time series, ordered by their timestamp.
	Point []*TimeseriesPoint `protobuf:"bytes,1,rep,name=point,proto3" json:"point,omitempty"`
}

func (x *Timeseries) Reset() {
	*x = Timeseries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Timeseries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Timeseries) ProtoMessage() {}

func (x *Timeseries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Timeseries.ProtoReflect.Descriptor instead.
func (*Timeseries) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{14}
}

func (x *Timeseries) GetPoint() []*TimeseriesPoint {
	if x != nil {
		return x.Point
	}
	return nil
}

// Forecast result for a given slice.
type EvaluatedSlice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Values for all categorical dimensions that uniquely identify this slice.
	Dimensions []*PinnedDimension `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The actual value at the detection time (see
	// [detectionTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time]).
	//
	// **NOTE**: This value can be an estimate, so it should not be used as a
	// source of truth.
	DetectionPointActual *float64 `protobuf:"fixed64,11,opt,name=detection_point_actual,json=detectionPointActual,proto3,oneof" json:"detection_point_actual,omitempty"`
	// The expected value at the detection time, which is obtained by forecasting
	// on the historical time series.
	DetectionPointForecast *float64 `protobuf:"fixed64,12,opt,name=detection_point_forecast,json=detectionPointForecast,proto3,oneof" json:"detection_point_forecast,omitempty"`
	// How much our forecast model expects the detection point actual will
	// deviate from its forecasted value based on how well it fit the input time
	// series.
	//
	// In general, we expect the `detectionPointActual` to
	// be in the `[detectionPointForecast - expectedDeviation,
	// detectionPointForecast + expectedDeviation]` range. The more the actual
	// value is outside this range, the more statistically significant the
	// anomaly is.
	//
	// The expected deviation is always positive.
	ExpectedDeviation *float64 `protobuf:"fixed64,16,opt,name=expected_deviation,json=expectedDeviation,proto3,oneof" json:"expected_deviation,omitempty"`
	// Summarizes how significant the change between the actual and forecasted
	// detection points are compared with the historical patterns observed on the
	// [history][google.cloud.timeseriesinsights.v1.EvaluatedSlice.history] time
	// series.
	//
	// Defined as `|a - f| / (e + nt)`, where:
	//
	// - `a` is the
	// [detectionPointActual][google.cloud.timeseriesinsights.v1.EvaluatedSlice.detection_point_actual].
	// - `f` is the
	// [detectionPointForecast][google.cloud.timeseriesinsights.v1.EvaluatedSlice.detection_point_forecast].
	// - `e` is the
	// [expectedDeviation][google.cloud.timeseriesinsights.v1.EvaluatedSlice.expected_deviation].
	// - `nt` is the
	// [noiseThreshold][google.cloud.timeseriesinsights.v1.ForecastParams.noise_threshold].
	//
	// Anomaly scores between different requests and data sets are comparable. As
	// a guideline, the risk of a slice being an anomaly based on the anomaly
	// score is:
	//
	// - **Very High** if anomaly_score > 5.
	// - **High** if the anomaly_score is in the [2, 5] range.
	// - **Medium** if the anomaly_score is in the [1, 2) range.
	// - **Low** if the anomaly_score is < 1.
	//
	// If there were issues evaluating this slice, then the anomaly score will be
	// set to -1.0 and the
	// [status][google.cloud.timeseriesinsights.v1.EvaluatedSlice.status] field
	// will contain details on what went wrong.
	AnomalyScore *float64 `protobuf:"fixed64,17,opt,name=anomaly_score,json=anomalyScore,proto3,oneof" json:"anomaly_score,omitempty"`
	// The actual values in the `[`
	// [detectionTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time]
	// `-`
	// [forecastHistory][google.cloud.timeseriesinsights.v1.TimeseriesParams.forecast_history]`,`
	// [detectionTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time]
	// `]` time range.
	//
	// **NOTE**: This field is only populated
	// https://old.reddit.com/r/nba?utm_source=reddit&utm_medium=usertext&utm_name=nba&utm_content=t5_2qo4sif
	// [returnTimeseries][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.return_timeseries]
	// is true.
	History *Timeseries `protobuf:"bytes,5,opt,name=history,proto3" json:"history,omitempty"`
	// The forecasted values in the `[`
	// [detectionTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time]
	// `+`
	// [granularity][google.cloud.timeseriesinsights.v1.TimeseriesParams.granularity]`,`
	// [forecastParams.horizonTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.forecast_params]
	// `]` time range.
	//
	// **NOTE**: This field is only populated if
	// [returnTimeseries][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.return_timeseries]
	// is true.
	Forecast *Timeseries `protobuf:"bytes,10,opt,name=forecast,proto3" json:"forecast,omitempty"`
	// Evaluation status. Contains an error message if the anomaly_score is < 0.
	//
	// Possible error messages:
	// - "Time series too sparse": The returned time series for this slice did not
	// contain enough data points (we require a minimum of 10).
	// - "Not enough recent time series points": The time series contains the
	// minimum of 10 points, but there are not enough close in time to the
	// detection point.
	// - "Missing detection point data": There were not events to be aggregated
	// within the [detectionTime + granularity] time interval, so we don't have an
	// actual value with which we can compare our prediction.
	// - "Data retrieval error": We failed to retrieve the time series data for
	// this slice and could not evaluate it successfully. Should be a transient
	// error.
	// - "Internal server error": Internal unexpected error.
	Status *status.Status `protobuf:"bytes,18,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *EvaluatedSlice) Reset() {
	*x = EvaluatedSlice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluatedSlice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluatedSlice) ProtoMessage() {}

func (x *EvaluatedSlice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluatedSlice.ProtoReflect.Descriptor instead.
func (*EvaluatedSlice) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{15}
}

func (x *EvaluatedSlice) GetDimensions() []*PinnedDimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *EvaluatedSlice) GetDetectionPointActual() float64 {
	if x != nil && x.DetectionPointActual != nil {
		return *x.DetectionPointActual
	}
	return 0
}

func (x *EvaluatedSlice) GetDetectionPointForecast() float64 {
	if x != nil && x.DetectionPointForecast != nil {
		return *x.DetectionPointForecast
	}
	return 0
}

func (x *EvaluatedSlice) GetExpectedDeviation() float64 {
	if x != nil && x.ExpectedDeviation != nil {
		return *x.ExpectedDeviation
	}
	return 0
}

func (x *EvaluatedSlice) GetAnomalyScore() float64 {
	if x != nil && x.AnomalyScore != nil {
		return *x.AnomalyScore
	}
	return 0
}

func (x *EvaluatedSlice) GetHistory() *Timeseries {
	if x != nil {
		return x.History
	}
	return nil
}

func (x *EvaluatedSlice) GetForecast() *Timeseries {
	if x != nil {
		return x.Forecast
	}
	return nil
}

func (x *EvaluatedSlice) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// Parameters that control how we slice the data set and, optionally, filter
// slices that have some specific values on some dimensions (pinned dimensions).
type SlicingParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Dimensions over which we will group the events in slices. The
	// names specified here come from the
	// [EventDimension.name][google.cloud.timeseriesinsights.v1.EventDimension.name]
	// field. At least one dimension name must be specified. All dimension names
	// that do not exist in the queried DataSet will be ignored.
	//
	// Currently only dimensions that hold string values can be specified here.
	DimensionNames []string `protobuf:"bytes,1,rep,name=dimension_names,json=dimensionNames,proto3" json:"dimension_names,omitempty"`
	// Optional. We will only analyze slices for which
	// [ForecastSlice.dimensions][ForecastSlice.dimensions] contain all of the
	// following pinned dimensions. A query with a pinned dimension `{ name: "d3"
	// stringVal: "v3" }` will only analyze events which contain the dimension `{
	// name: "d3" stringVal: "v3" }`.
	// The
	// [pinnedDimensions][google.cloud.timeseriesinsights.v1.SlicingParams.pinned_dimensions]
	// and
	// [dimensionNames][google.cloud.timeseriesinsights.v1.SlicingParams.dimension_names]
	// fields can **not** share the same dimension names.
	//
	// Example a valid specification:
	//
	// ```json
	//
	//	{
	//	  dimensionNames: ["d1", "d2"],
	//	  pinnedDimensions: [
	//	    { name: "d3" stringVal: "v3" },
	//	    { name: "d4" stringVal: "v4" }
	//	  ]
	//	}
	//
	// ```
	//
	// In the previous example we will slice the data set by dimensions "d1",
	// "d2", "d3" and "d4", but we will only analyze slices for which "d3=v3" and
	// "d4=v4".
	//
	// The following example is **invalid** as "d2" is present in both
	// dimensionNames and pinnedDimensions:
	//
	// ```json
	//
	//	{
	//	  dimensionNames: ["d1", "d2"],
	//	  pinnedDimensions: [
	//	    { name: "d2" stringVal: "v2" },
	//	    { name: "d4" stringVal: "v4" }
	//	  ]
	//	}
	//
	// ```
	PinnedDimensions []*PinnedDimension `protobuf:"bytes,2,rep,name=pinned_dimensions,json=pinnedDimensions,proto3" json:"pinned_dimensions,omitempty"`
}

func (x *SlicingParams) Reset() {
	*x = SlicingParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SlicingParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlicingParams) ProtoMessage() {}

func (x *SlicingParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlicingParams.ProtoReflect.Descriptor instead.
func (*SlicingParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{16}
}

func (x *SlicingParams) GetDimensionNames() []string {
	if x != nil {
		return x.DimensionNames
	}
	return nil
}

func (x *SlicingParams) GetPinnedDimensions() []*PinnedDimension {
	if x != nil {
		return x.PinnedDimensions
	}
	return nil
}

// Parameters that control how we construct the time series for each slice.
type TimeseriesParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. How long should we go in the past when fetching the timeline used
	// for forecasting each slice.
	//
	// This is used in combination with the
	// [detectionTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time]
	// parameter. The time series we construct will have the following time range:
	// [detectionTime - forecastHistory, detectionTime + granularity].
	//
	// The forecast history might be rounded up, so that a multiple of
	// `granularity` is used to process the query.
	//
	// **NOTE**: Make sure there are enough events in the data set to cover the
	// time interval: if the `detectionTime` is set to T, the data set should
	// have enough events from "T - forecastHistory" to allow forecasting and
	// anomaly detection.  If too few events are found in this range, no anomaly
	// will be reported.  Users can use [EvaluateSlice][EvaluateSlice] to
	// check the (approximate) count of events for each point of time in the
	// range, by not setting `metric`.
	ForecastHistory *durationpb.Duration `protobuf:"bytes,1,opt,name=forecast_history,json=forecastHistory,proto3" json:"forecast_history,omitempty"`
	// Required. The time granularity of the time series (on the x-axis). Each
	// time series point starting at time T will aggregate all events for a
	// particular slice in [T, T + granularity) time windows.
	//
	// **NOTE**: The aggregation is decided based on the
	// [metric][google.cloud.timeseriesinsights.v1.TimeseriesParams.metric]
	// parameter.
	//
	// This granularity defines the query-time aggregation windows and is not
	// necessarily related to any event time granularity in the raw data (though
	// we do recommend that the query-time granularity is not finer than the
	// ingestion-time one).
	//
	// Currently, the minimal supported granularity is 10 seconds.
	Granularity *durationpb.Duration `protobuf:"bytes,2,opt,name=granularity,proto3" json:"granularity,omitempty"`
	// Optional. Denotes the
	// [name][google.cloud.timeseriesinsights.v1.EventDimension.name] of a
	// numerical dimension that will have its values aggregated to compute the
	// y-axis of the time series.
	//
	// The aggregation method must also be specified by setting the
	// [metricAggregationMethod][TimeseriesParams.metricAggregationMethod] field.
	//
	// **Note**: Currently, if the aggregation method is unspecified, we will
	// default to SUM for backwards compatibility reasons, but new implementations
	// should set the
	// [metricAggregationMethod][TimeseriesParams.metricAggregationMethod]
	// explicitly.
	//
	// If the metric is unspecified, we will use the number of events that each
	// time series point contains as the point value.
	//
	// Example: Let's assume we have the following three events in our data set:
	// ```json
	//
	//	{
	//	  eventTime: "2020-12-27T00:00:00Z",
	//	  dimensions: [
	//	    { name: "d1" stringVal: "v1" },
	//	    { name: "d2" stringVal: "v2" }
	//	    { name: "m1" longVal: 100 }
	//	    { name: "m2" longVal: 11 }
	//	  ]
	//	},
	//
	//	{
	//	  eventTime: "2020-12-27T00:10:00Z",
	//	  dimensions: [
	//	    { name: "d1" stringVal: "v1" },
	//	    { name: "d2" stringVal: "v2" }
	//	    { name: "m1" longVal: 200 }
	//	    { name: "m2" longVal: 22 }
	//	  ]
	//	},
	//
	//	{
	//	  eventTime: "2020-12-27T00:20:00Z",
	//	  dimensions: [
	//	    { name: "d1" stringVal: "v1" },
	//	    { name: "d2" stringVal: "v2" }
	//	    { name: "m1" longVal: 300 }
	//	    { name: "m2" longVal: 33 }
	//	  ]
	//	}
	//
	// ```
	//
	// These events are all within the same hour, spaced 10 minutes between each
	// of them. Assuming our
	// [QueryDataSetRequest][google.cloud.timeseriesinsights.v1.QueryDataSetRequest]
	// had set
	// [slicingParams.dimensionNames][google.cloud.timeseriesinsights.v1.SlicingParams.dimension_names]
	// to ["d1", "d2"] and
	// [timeseries_params.granularity][google.cloud.timeseriesinsights.v1.TimeseriesParams.granularity]
	// to "3600s", then all the previous events will be aggregated into the same
	// [timeseries point][google.cloud.timeseriesinsights.v1.TimeseriesPoint].
	//
	// The time series point which they are all part of will have the
	// [time][google.cloud.timeseriesinsights.v1.TimeseriesPoint.time] set to
	// "2020-12-27T00:00:00Z" and the
	// [value][google.cloud.timeseriesinsights.v1.TimeseriesPoint.value] populated
	// based on this metric field:
	//
	// - If the metric is set to "m1" and metric_aggregation_method to SUM, then
	// the value of the point will be 600.
	// - If the metric is set to "m2" and metric_aggregation_method to SUM, then
	// the value of the point will be 66.
	// - If the metric is set to "m1" and metric_aggregation_method to AVERAGE,
	// then the value of the point will be 200.
	// - If the metric is set to "m2" and metric_aggregation_method to AVERAGE,
	// then the value of the point will be 22.
	// - If the metric field is "" or unspecified, then the value of the point
	// will be 3, as we will simply count the events.
	Metric *string `protobuf:"bytes,4,opt,name=metric,proto3,oneof" json:"metric,omitempty"`
	// Optional. Together with the
	// [metric][google.cloud.timeseriesinsights.v1.TimeseriesParams.metric] field,
	// specifies how we will aggregate multiple events to obtain the value of a
	// time series point. See the
	// [metric][google.cloud.timeseriesinsights.v1.TimeseriesParams.metric]
	// documentation for more details.
	//
	// If the metric is not specified or "", then this field will be ignored.
	MetricAggregationMethod TimeseriesParams_AggregationMethod `protobuf:"varint,5,opt,name=metric_aggregation_method,json=metricAggregationMethod,proto3,enum=google.cloud.timeseriesinsights.v1.TimeseriesParams_AggregationMethod" json:"metric_aggregation_method,omitempty"`
}

func (x *TimeseriesParams) Reset() {
	*x = TimeseriesParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeseriesParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeseriesParams) ProtoMessage() {}

func (x *TimeseriesParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeseriesParams.ProtoReflect.Descriptor instead.
func (*TimeseriesParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{17}
}

func (x *TimeseriesParams) GetForecastHistory() *durationpb.Duration {
	if x != nil {
		return x.ForecastHistory
	}
	return nil
}

func (x *TimeseriesParams) GetGranularity() *durationpb.Duration {
	if x != nil {
		return x.Granularity
	}
	return nil
}

func (x *TimeseriesParams) GetMetric() string {
	if x != nil && x.Metric != nil {
		return *x.Metric
	}
	return ""
}

func (x *TimeseriesParams) GetMetricAggregationMethod() TimeseriesParams_AggregationMethod {
	if x != nil {
		return x.MetricAggregationMethod
	}
	return TimeseriesParams_AGGREGATION_METHOD_UNSPECIFIED
}

// Request for performing a query against a loaded DataSet.
type QueryDataSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Loaded DataSet to be queried in the format of
	// "projects/{project}/datasets/{dataset}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. This is the point in time which we want to probe for anomalies.
	//
	// The corresponding
	// [TimeseriesPoint][google.cloud.timeseriesinsights.v1.TimeseriesPoint] is
	// referred to as the detection point.
	//
	// **NOTE**: As with any other time series point, the value is given by
	// aggregating all events in the slice that are in the
	// [detectionTime, detectionTime + granularity) time interval, where
	// the granularity is specified in the
	// [timeseriesParams.granularity][google.cloud.timeseriesinsights.v1.TimeseriesParams.granularity]
	// field.
	DetectionTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=detection_time,json=detectionTime,proto3" json:"detection_time,omitempty"`
	// How many slices are returned in
	// [QueryDataSetResponse.slices][google.cloud.timeseriesinsights.v1.QueryDataSetResponse.slices].
	//
	// The returned slices are tentatively the ones with the highest [anomaly
	// scores][EvaluatedSlice.anomaly_score] in the data set that match the query,
	// but it is not guaranteed.
	//
	// Reducing this number will improve query performance, both in terms of
	// latency and resource usage.
	//
	// Defaults to 50.
	NumReturnedSlices *int32 `protobuf:"varint,13,opt,name=num_returned_slices,json=numReturnedSlices,proto3,oneof" json:"num_returned_slices,omitempty"`
	// Parameters controlling how we will split the data set into the slices that
	// we will analyze.
	SlicingParams *SlicingParams `protobuf:"bytes,9,opt,name=slicing_params,json=slicingParams,proto3" json:"slicing_params,omitempty"`
	// Parameters controlling how we will build the time series used to predict
	// the
	// [detectionTime][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time]
	// value for each slice.
	TimeseriesParams *TimeseriesParams `protobuf:"bytes,10,opt,name=timeseries_params,json=timeseriesParams,proto3" json:"timeseries_params,omitempty"`
	// Parameters that control the time series forecasting models, such as the
	// sensitivity of the anomaly detection.
	ForecastParams *ForecastParams `protobuf:"bytes,5,opt,name=forecast_params,json=forecastParams,proto3" json:"forecast_params,omitempty"`
	// If specified, we will return the actual and forecasted time for all
	// returned slices.
	//
	// The time series are returned in the
	// [EvaluatedSlice.history][google.cloud.timeseriesinsights.v1.EvaluatedSlice.history]
	// and
	// [EvaluatedSlice.forecast][google.cloud.timeseriesinsights.v1.EvaluatedSlice.forecast]
	// fields.
	ReturnTimeseries bool `protobuf:"varint,8,opt,name=return_timeseries,json=returnTimeseries,proto3" json:"return_timeseries,omitempty"`
}

func (x *QueryDataSetRequest) Reset() {
	*x = QueryDataSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryDataSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDataSetRequest) ProtoMessage() {}

func (x *QueryDataSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDataSetRequest.ProtoReflect.Descriptor instead.
func (*QueryDataSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{18}
}

func (x *QueryDataSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryDataSetRequest) GetDetectionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DetectionTime
	}
	return nil
}

func (x *QueryDataSetRequest) GetNumReturnedSlices() int32 {
	if x != nil && x.NumReturnedSlices != nil {
		return *x.NumReturnedSlices
	}
	return 0
}

func (x *QueryDataSetRequest) GetSlicingParams() *SlicingParams {
	if x != nil {
		return x.SlicingParams
	}
	return nil
}

func (x *QueryDataSetRequest) GetTimeseriesParams() *TimeseriesParams {
	if x != nil {
		return x.TimeseriesParams
	}
	return nil
}

func (x *QueryDataSetRequest) GetForecastParams() *ForecastParams {
	if x != nil {
		return x.ForecastParams
	}
	return nil
}

func (x *QueryDataSetRequest) GetReturnTimeseries() bool {
	if x != nil {
		return x.ReturnTimeseries
	}
	return false
}

// Response for a query executed by the system.
type QueryDataSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Loaded DataSet that was queried.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Slices sorted in descending order by their
	// [anomalyScore][google.cloud.timeseriesinsights.v1.EvaluatedSlice.anomaly_score].
	//
	// At most
	// [numReturnedSlices][google.cloud.timeseriesinsights.v1.QueryDataSetRequest.num_returned_slices]
	// slices are present in this field.
	Slices []*EvaluatedSlice `protobuf:"bytes,3,rep,name=slices,proto3" json:"slices,omitempty"`
}

func (x *QueryDataSetResponse) Reset() {
	*x = QueryDataSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryDataSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDataSetResponse) ProtoMessage() {}

func (x *QueryDataSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDataSetResponse.ProtoReflect.Descriptor instead.
func (*QueryDataSetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{19}
}

func (x *QueryDataSetResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryDataSetResponse) GetSlices() []*EvaluatedSlice {
	if x != nil {
		return x.Slices
	}
	return nil
}

// Request for evaluateSlice.
type EvaluateSliceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Loaded DataSet to be queried in the format of
	// "projects/{project}/datasets/{dataset}"
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. Dimensions with pinned values that specify the slice for which we
	// will fetch the time series.
	PinnedDimensions []*PinnedDimension `protobuf:"bytes,2,rep,name=pinned_dimensions,json=pinnedDimensions,proto3" json:"pinned_dimensions,omitempty"`
	// Required. This is the point in time which we want to probe for anomalies.
	//
	// See documentation for
	// [QueryDataSetRequest.detectionPoint][QueryDataSetRequest.detection_point].
	DetectionTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=detection_time,json=detectionTime,proto3" json:"detection_time,omitempty"`
	// Parameters controlling how we will build the time series used to predict
	// the
	// [detectionTime][google.cloud.timeseriesinsights.v1.EvaluateSliceRequest.detection_time]
	// value for this slice.
	TimeseriesParams *TimeseriesParams `protobuf:"bytes,4,opt,name=timeseries_params,json=timeseriesParams,proto3" json:"timeseries_params,omitempty"`
	// Parameters that control the time series forecasting models, such as the
	// sensitivity of the anomaly detection.
	ForecastParams *ForecastParams `protobuf:"bytes,5,opt,name=forecast_params,json=forecastParams,proto3" json:"forecast_params,omitempty"`
}

func (x *EvaluateSliceRequest) Reset() {
	*x = EvaluateSliceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluateSliceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluateSliceRequest) ProtoMessage() {}

func (x *EvaluateSliceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluateSliceRequest.ProtoReflect.Descriptor instead.
func (*EvaluateSliceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP(), []int{20}
}

func (x *EvaluateSliceRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *EvaluateSliceRequest) GetPinnedDimensions() []*PinnedDimension {
	if x != nil {
		return x.PinnedDimensions
	}
	return nil
}

func (x *EvaluateSliceRequest) GetDetectionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DetectionTime
	}
	return nil
}

func (x *EvaluateSliceRequest) GetTimeseriesParams() *TimeseriesParams {
	if x != nil {
		return x.TimeseriesParams
	}
	return nil
}

func (x *EvaluateSliceRequest) GetForecastParams() *ForecastParams {
	if x != nil {
		return x.ForecastParams
	}
	return nil
}

var File_google_cloud_timeseriesinsights_v1_timeseries_insights_proto protoreflect.FileDescriptor

var file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8f, 0x01, 0x0a,
	0x0f, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x12, 0x29, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x22, 0x72,
	0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x52,
	0x0a, 0x0a, 0x62, 0x71, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x09, 0x62, 0x71, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x22, 0xc2, 0x04, 0x0a, 0x07, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x12, 0x51, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2b, 0x0a, 0x03, 0x74, 0x74, 0x6c,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0x7a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a,
	0x06, 0x4c, 0x4f, 0x41, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x4c,
	0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x4e, 0x4c, 0x4f,
	0x41, 0x44, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x07, 0x3a, 0x92, 0x01, 0xea, 0x41, 0x8e, 0x01, 0x0a, 0x29, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x12, 0x25, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x12, 0x3a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x22, 0xa9, 0x01, 0x0a, 0x0e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x12,
	0x1b, 0x0a, 0x08, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x07, 0x6c, 0x6f, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x12, 0x1b, 0x0a, 0x08,
	0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x07, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x12, 0x1f, 0x0a, 0x0a, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52,
	0x09, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a,
	0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x65,
	0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x4b, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22,
	0x68, 0x0a, 0x14, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0e, 0x64, 0x72, 0x6f, 0x70, 0x70,
	0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x64, 0x72, 0x6f, 0x70,
	0x70, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xaf, 0x01, 0x0a, 0x14, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x4a, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x5d, 0x0a, 0x14, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9e, 0x01, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x65, 0x74, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6c, 0x0a, 0x0f, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0a,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x12, 0x1b, 0x0a,
	0x08, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x07, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0xeb, 0x02, 0x0a, 0x0e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x31, 0x0a, 0x0f, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x12, 0x69, 0x0a, 0x10, 0x73, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x48, 0x69, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x10, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x5c, 0x0a, 0x06, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x52,
	0x49, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x4f, 0x55, 0x52, 0x4c, 0x59, 0x10, 0x05, 0x12, 0x09, 0x0a,
	0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x45, 0x4b,
	0x4c, 0x59, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x59, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x04, 0x42, 0x12, 0x0a,
	0x10, 0x5f, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x22, 0x66, 0x0a, 0x0f, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x57, 0x0a, 0x0a, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x05, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x22, 0xe0, 0x04, 0x0a, 0x0e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x69, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39, 0x0a, 0x16, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x63,
	0x74, 0x75, 0x61, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x14, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x75,
	0x61, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x16, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x02, 0x52, 0x11, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6e, 0x6f, 0x6d,
	0x61, 0x6c, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x03, 0x52, 0x0c, 0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x48, 0x0a, 0x07, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x07, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x4a, 0x0a, 0x08,
	0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x08,
	0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x42,
	0x1b, 0x0a, 0x19, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x0d, 0x53, 0x6c, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x11, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x5f,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x70, 0x69, 0x6e, 0x6e,
	0x65, 0x64, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa5, 0x03, 0x0a,
	0x10, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x49, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x68, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b,
	0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x20,
	0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x88, 0x01, 0x01,
	0x12, 0x87, 0x01, 0x0a, 0x19, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x17, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x4d, 0x0a, 0x11, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12,
	0x22, 0x0a, 0x1e, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x55, 0x4d, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x41, 0x56, 0x45, 0x52, 0x41, 0x47, 0x45, 0x10, 0x02, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x22, 0xb8, 0x04, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x13, 0x6e,
	0x75, 0x6d, 0x5f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x5f, 0x73, 0x6c, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x11, 0x6e, 0x75, 0x6d, 0x52,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x58, 0x0a, 0x0e, 0x73, 0x6c, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x0d, 0x73, 0x6c, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x61, 0x0a, 0x11, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x10, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5b, 0x0a,
	0x0f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65,
	0x74, 0x75, 0x72, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6e, 0x75, 0x6d, 0x5f,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x22,
	0x76, 0x0a, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x73,
	0x6c, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x52,
	0x06, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x22, 0xd2, 0x03, 0x0a, 0x14, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x65, 0x0a,
	0x11, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69,
	0x6e, 0x6e, 0x65, 0x64, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x0e, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x11,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x10, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x5b, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x0e, 0x66, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x32, 0xa0, 0x0c, 0x0a,
	0x1c, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x12, 0xe4, 0x01,
	0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x5a, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xf3, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x22, 0x7b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x64, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x3a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5a, 0x2b, 0x22, 0x20,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x3a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0xc2, 0x01, 0x0a, 0x0d, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5f,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x22, 0x2a, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x93, 0x02, 0x0a, 0x0c, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x8f, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x78, 0x22, 0x3c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x35, 0x22,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2c, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xed, 0x01, 0x0a, 0x0c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x64, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x2b, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x3a, 0x01, 0x2a, 0x12, 0x80, 0x02, 0x0a, 0x0d, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x22, 0x80, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7a, 0x22, 0x3d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x3a, 0x01, 0x2a,
	0x5a, 0x36, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x3a, 0x01, 0x2a, 0x1a, 0x55, 0xca, 0x41, 0x21, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x9c, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x54, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0xf8, 0x01, 0x01, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescOnce sync.Once
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescData = file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDesc
)

func file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescGZIP() []byte {
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescOnce.Do(func() {
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescData)
	})
	return file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDescData
}

var file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_goTypes = []interface{}{
	(DataSet_State)(0),                      // 0: google.cloud.timeseriesinsights.v1.DataSet.State
	(ForecastParams_Period)(0),              // 1: google.cloud.timeseriesinsights.v1.ForecastParams.Period
	(TimeseriesParams_AggregationMethod)(0), // 2: google.cloud.timeseriesinsights.v1.TimeseriesParams.AggregationMethod
	(*BigqueryMapping)(nil),                 // 3: google.cloud.timeseriesinsights.v1.BigqueryMapping
	(*DataSource)(nil),                      // 4: google.cloud.timeseriesinsights.v1.DataSource
	(*DataSet)(nil),                         // 5: google.cloud.timeseriesinsights.v1.DataSet
	(*EventDimension)(nil),                  // 6: google.cloud.timeseriesinsights.v1.EventDimension
	(*Event)(nil),                           // 7: google.cloud.timeseriesinsights.v1.Event
	(*AppendEventsRequest)(nil),             // 8: google.cloud.timeseriesinsights.v1.AppendEventsRequest
	(*AppendEventsResponse)(nil),            // 9: google.cloud.timeseriesinsights.v1.AppendEventsResponse
	(*CreateDataSetRequest)(nil),            // 10: google.cloud.timeseriesinsights.v1.CreateDataSetRequest
	(*DeleteDataSetRequest)(nil),            // 11: google.cloud.timeseriesinsights.v1.DeleteDataSetRequest
	(*ListDataSetsRequest)(nil),             // 12: google.cloud.timeseriesinsights.v1.ListDataSetsRequest
	(*ListDataSetsResponse)(nil),            // 13: google.cloud.timeseriesinsights.v1.ListDataSetsResponse
	(*PinnedDimension)(nil),                 // 14: google.cloud.timeseriesinsights.v1.PinnedDimension
	(*ForecastParams)(nil),                  // 15: google.cloud.timeseriesinsights.v1.ForecastParams
	(*TimeseriesPoint)(nil),                 // 16: google.cloud.timeseriesinsights.v1.TimeseriesPoint
	(*Timeseries)(nil),                      // 17: google.cloud.timeseriesinsights.v1.Timeseries
	(*EvaluatedSlice)(nil),                  // 18: google.cloud.timeseriesinsights.v1.EvaluatedSlice
	(*SlicingParams)(nil),                   // 19: google.cloud.timeseriesinsights.v1.SlicingParams
	(*TimeseriesParams)(nil),                // 20: google.cloud.timeseriesinsights.v1.TimeseriesParams
	(*QueryDataSetRequest)(nil),             // 21: google.cloud.timeseriesinsights.v1.QueryDataSetRequest
	(*QueryDataSetResponse)(nil),            // 22: google.cloud.timeseriesinsights.v1.QueryDataSetResponse
	(*EvaluateSliceRequest)(nil),            // 23: google.cloud.timeseriesinsights.v1.EvaluateSliceRequest
	(*status.Status)(nil),                   // 24: google.rpc.Status
	(*durationpb.Duration)(nil),             // 25: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),           // 26: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                   // 27: google.protobuf.Empty
}
var file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_depIdxs = []int32{
	3,  // 0: google.cloud.timeseriesinsights.v1.DataSource.bq_mapping:type_name -> google.cloud.timeseriesinsights.v1.BigqueryMapping
	4,  // 1: google.cloud.timeseriesinsights.v1.DataSet.data_sources:type_name -> google.cloud.timeseriesinsights.v1.DataSource
	0,  // 2: google.cloud.timeseriesinsights.v1.DataSet.state:type_name -> google.cloud.timeseriesinsights.v1.DataSet.State
	24, // 3: google.cloud.timeseriesinsights.v1.DataSet.status:type_name -> google.rpc.Status
	25, // 4: google.cloud.timeseriesinsights.v1.DataSet.ttl:type_name -> google.protobuf.Duration
	6,  // 5: google.cloud.timeseriesinsights.v1.Event.dimensions:type_name -> google.cloud.timeseriesinsights.v1.EventDimension
	26, // 6: google.cloud.timeseriesinsights.v1.Event.event_time:type_name -> google.protobuf.Timestamp
	7,  // 7: google.cloud.timeseriesinsights.v1.AppendEventsRequest.events:type_name -> google.cloud.timeseriesinsights.v1.Event
	7,  // 8: google.cloud.timeseriesinsights.v1.AppendEventsResponse.dropped_events:type_name -> google.cloud.timeseriesinsights.v1.Event
	5,  // 9: google.cloud.timeseriesinsights.v1.CreateDataSetRequest.dataset:type_name -> google.cloud.timeseriesinsights.v1.DataSet
	5,  // 10: google.cloud.timeseriesinsights.v1.ListDataSetsResponse.datasets:type_name -> google.cloud.timeseriesinsights.v1.DataSet
	1,  // 11: google.cloud.timeseriesinsights.v1.ForecastParams.seasonality_hint:type_name -> google.cloud.timeseriesinsights.v1.ForecastParams.Period
	25, // 12: google.cloud.timeseriesinsights.v1.ForecastParams.horizon_duration:type_name -> google.protobuf.Duration
	26, // 13: google.cloud.timeseriesinsights.v1.TimeseriesPoint.time:type_name -> google.protobuf.Timestamp
	16, // 14: google.cloud.timeseriesinsights.v1.Timeseries.point:type_name -> google.cloud.timeseriesinsights.v1.TimeseriesPoint
	14, // 15: google.cloud.timeseriesinsights.v1.EvaluatedSlice.dimensions:type_name -> google.cloud.timeseriesinsights.v1.PinnedDimension
	17, // 16: google.cloud.timeseriesinsights.v1.EvaluatedSlice.history:type_name -> google.cloud.timeseriesinsights.v1.Timeseries
	17, // 17: google.cloud.timeseriesinsights.v1.EvaluatedSlice.forecast:type_name -> google.cloud.timeseriesinsights.v1.Timeseries
	24, // 18: google.cloud.timeseriesinsights.v1.EvaluatedSlice.status:type_name -> google.rpc.Status
	14, // 19: google.cloud.timeseriesinsights.v1.SlicingParams.pinned_dimensions:type_name -> google.cloud.timeseriesinsights.v1.PinnedDimension
	25, // 20: google.cloud.timeseriesinsights.v1.TimeseriesParams.forecast_history:type_name -> google.protobuf.Duration
	25, // 21: google.cloud.timeseriesinsights.v1.TimeseriesParams.granularity:type_name -> google.protobuf.Duration
	2,  // 22: google.cloud.timeseriesinsights.v1.TimeseriesParams.metric_aggregation_method:type_name -> google.cloud.timeseriesinsights.v1.TimeseriesParams.AggregationMethod
	26, // 23: google.cloud.timeseriesinsights.v1.QueryDataSetRequest.detection_time:type_name -> google.protobuf.Timestamp
	19, // 24: google.cloud.timeseriesinsights.v1.QueryDataSetRequest.slicing_params:type_name -> google.cloud.timeseriesinsights.v1.SlicingParams
	20, // 25: google.cloud.timeseriesinsights.v1.QueryDataSetRequest.timeseries_params:type_name -> google.cloud.timeseriesinsights.v1.TimeseriesParams
	15, // 26: google.cloud.timeseriesinsights.v1.QueryDataSetRequest.forecast_params:type_name -> google.cloud.timeseriesinsights.v1.ForecastParams
	18, // 27: google.cloud.timeseriesinsights.v1.QueryDataSetResponse.slices:type_name -> google.cloud.timeseriesinsights.v1.EvaluatedSlice
	14, // 28: google.cloud.timeseriesinsights.v1.EvaluateSliceRequest.pinned_dimensions:type_name -> google.cloud.timeseriesinsights.v1.PinnedDimension
	26, // 29: google.cloud.timeseriesinsights.v1.EvaluateSliceRequest.detection_time:type_name -> google.protobuf.Timestamp
	20, // 30: google.cloud.timeseriesinsights.v1.EvaluateSliceRequest.timeseries_params:type_name -> google.cloud.timeseriesinsights.v1.TimeseriesParams
	15, // 31: google.cloud.timeseriesinsights.v1.EvaluateSliceRequest.forecast_params:type_name -> google.cloud.timeseriesinsights.v1.ForecastParams
	12, // 32: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.ListDataSets:input_type -> google.cloud.timeseriesinsights.v1.ListDataSetsRequest
	10, // 33: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.CreateDataSet:input_type -> google.cloud.timeseriesinsights.v1.CreateDataSetRequest
	11, // 34: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.DeleteDataSet:input_type -> google.cloud.timeseriesinsights.v1.DeleteDataSetRequest
	8,  // 35: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.AppendEvents:input_type -> google.cloud.timeseriesinsights.v1.AppendEventsRequest
	21, // 36: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.QueryDataSet:input_type -> google.cloud.timeseriesinsights.v1.QueryDataSetRequest
	23, // 37: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.EvaluateSlice:input_type -> google.cloud.timeseriesinsights.v1.EvaluateSliceRequest
	13, // 38: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.ListDataSets:output_type -> google.cloud.timeseriesinsights.v1.ListDataSetsResponse
	5,  // 39: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.CreateDataSet:output_type -> google.cloud.timeseriesinsights.v1.DataSet
	27, // 40: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.DeleteDataSet:output_type -> google.protobuf.Empty
	9,  // 41: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.AppendEvents:output_type -> google.cloud.timeseriesinsights.v1.AppendEventsResponse
	22, // 42: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.QueryDataSet:output_type -> google.cloud.timeseriesinsights.v1.QueryDataSetResponse
	18, // 43: google.cloud.timeseriesinsights.v1.TimeseriesInsightsController.EvaluateSlice:output_type -> google.cloud.timeseriesinsights.v1.EvaluatedSlice
	38, // [38:44] is the sub-list for method output_type
	32, // [32:38] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_init() }
func file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_init() {
	if File_google_cloud_timeseriesinsights_v1_timeseries_insights_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigqueryMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PinnedDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForecastParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeseriesPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Timeseries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluatedSlice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SlicingParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeseriesParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryDataSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryDataSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluateSliceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*EventDimension_StringVal)(nil),
		(*EventDimension_LongVal)(nil),
		(*EventDimension_BoolVal)(nil),
		(*EventDimension_DoubleVal)(nil),
	}
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*PinnedDimension_StringVal)(nil),
		(*PinnedDimension_BoolVal)(nil),
	}
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[13].OneofWrappers = []interface{}{}
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[15].OneofWrappers = []interface{}{}
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[17].OneofWrappers = []interface{}{}
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes[18].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_goTypes,
		DependencyIndexes: file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_depIdxs,
		EnumInfos:         file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_enumTypes,
		MessageInfos:      file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_msgTypes,
	}.Build()
	File_google_cloud_timeseriesinsights_v1_timeseries_insights_proto = out.File
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_rawDesc = nil
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_goTypes = nil
	file_google_cloud_timeseriesinsights_v1_timeseries_insights_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TimeseriesInsightsControllerClient is the client API for TimeseriesInsightsController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TimeseriesInsightsControllerClient interface {
	// Lists [DataSets][google.cloud.timeseriesinsights.v1.DataSet] under the
	// project.
	//
	// The order of the results is unspecified but deterministic. Newly created
	// [DataSets][google.cloud.timeseriesinsights.v1.DataSet] will not necessarily
	// be added to the end of this list.
	ListDataSets(ctx context.Context, in *ListDataSetsRequest, opts ...grpc.CallOption) (*ListDataSetsResponse, error)
	// Create a [DataSet][google.cloud.timeseriesinsights.v1.DataSet] from data
	// stored on Cloud Storage.
	//
	// The data must stay immutable while we process the
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet] creation; otherwise,
	// undefined outcomes might result.  For more information, see
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	CreateDataSet(ctx context.Context, in *CreateDataSetRequest, opts ...grpc.CallOption) (*DataSet, error)
	// Delete a [DataSet][google.cloud.timeseriesinsights.v1.DataSet] from the
	// system.
	//
	// **NOTE**: If the [DataSet][google.cloud.timeseriesinsights.v1.DataSet] is
	// still being processed, it will be aborted and deleted.
	DeleteDataSet(ctx context.Context, in *DeleteDataSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Append events to a `LOADED`
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	AppendEvents(ctx context.Context, in *AppendEventsRequest, opts ...grpc.CallOption) (*AppendEventsResponse, error)
	// Execute a Timeseries Insights query over a loaded
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	QueryDataSet(ctx context.Context, in *QueryDataSetRequest, opts ...grpc.CallOption) (*QueryDataSetResponse, error)
	// Evaluate an explicit slice from a loaded
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	EvaluateSlice(ctx context.Context, in *EvaluateSliceRequest, opts ...grpc.CallOption) (*EvaluatedSlice, error)
}

type timeseriesInsightsControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewTimeseriesInsightsControllerClient(cc grpc.ClientConnInterface) TimeseriesInsightsControllerClient {
	return &timeseriesInsightsControllerClient{cc}
}

func (c *timeseriesInsightsControllerClient) ListDataSets(ctx context.Context, in *ListDataSetsRequest, opts ...grpc.CallOption) (*ListDataSetsResponse, error) {
	out := new(ListDataSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/ListDataSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *timeseriesInsightsControllerClient) CreateDataSet(ctx context.Context, in *CreateDataSetRequest, opts ...grpc.CallOption) (*DataSet, error) {
	out := new(DataSet)
	err := c.cc.Invoke(ctx, "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/CreateDataSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *timeseriesInsightsControllerClient) DeleteDataSet(ctx context.Context, in *DeleteDataSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/DeleteDataSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *timeseriesInsightsControllerClient) AppendEvents(ctx context.Context, in *AppendEventsRequest, opts ...grpc.CallOption) (*AppendEventsResponse, error) {
	out := new(AppendEventsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/AppendEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *timeseriesInsightsControllerClient) QueryDataSet(ctx context.Context, in *QueryDataSetRequest, opts ...grpc.CallOption) (*QueryDataSetResponse, error) {
	out := new(QueryDataSetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/QueryDataSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *timeseriesInsightsControllerClient) EvaluateSlice(ctx context.Context, in *EvaluateSliceRequest, opts ...grpc.CallOption) (*EvaluatedSlice, error) {
	out := new(EvaluatedSlice)
	err := c.cc.Invoke(ctx, "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/EvaluateSlice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TimeseriesInsightsControllerServer is the server API for TimeseriesInsightsController service.
type TimeseriesInsightsControllerServer interface {
	// Lists [DataSets][google.cloud.timeseriesinsights.v1.DataSet] under the
	// project.
	//
	// The order of the results is unspecified but deterministic. Newly created
	// [DataSets][google.cloud.timeseriesinsights.v1.DataSet] will not necessarily
	// be added to the end of this list.
	ListDataSets(context.Context, *ListDataSetsRequest) (*ListDataSetsResponse, error)
	// Create a [DataSet][google.cloud.timeseriesinsights.v1.DataSet] from data
	// stored on Cloud Storage.
	//
	// The data must stay immutable while we process the
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet] creation; otherwise,
	// undefined outcomes might result.  For more information, see
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	CreateDataSet(context.Context, *CreateDataSetRequest) (*DataSet, error)
	// Delete a [DataSet][google.cloud.timeseriesinsights.v1.DataSet] from the
	// system.
	//
	// **NOTE**: If the [DataSet][google.cloud.timeseriesinsights.v1.DataSet] is
	// still being processed, it will be aborted and deleted.
	DeleteDataSet(context.Context, *DeleteDataSetRequest) (*emptypb.Empty, error)
	// Append events to a `LOADED`
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	AppendEvents(context.Context, *AppendEventsRequest) (*AppendEventsResponse, error)
	// Execute a Timeseries Insights query over a loaded
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	QueryDataSet(context.Context, *QueryDataSetRequest) (*QueryDataSetResponse, error)
	// Evaluate an explicit slice from a loaded
	// [DataSet][google.cloud.timeseriesinsights.v1.DataSet].
	EvaluateSlice(context.Context, *EvaluateSliceRequest) (*EvaluatedSlice, error)
}

// UnimplementedTimeseriesInsightsControllerServer can be embedded to have forward compatible implementations.
type UnimplementedTimeseriesInsightsControllerServer struct {
}

func (*UnimplementedTimeseriesInsightsControllerServer) ListDataSets(context.Context, *ListDataSetsRequest) (*ListDataSetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDataSets not implemented")
}
func (*UnimplementedTimeseriesInsightsControllerServer) CreateDataSet(context.Context, *CreateDataSetRequest) (*DataSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDataSet not implemented")
}
func (*UnimplementedTimeseriesInsightsControllerServer) DeleteDataSet(context.Context, *DeleteDataSetRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDataSet not implemented")
}
func (*UnimplementedTimeseriesInsightsControllerServer) AppendEvents(context.Context, *AppendEventsRequest) (*AppendEventsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AppendEvents not implemented")
}
func (*UnimplementedTimeseriesInsightsControllerServer) QueryDataSet(context.Context, *QueryDataSetRequest) (*QueryDataSetResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueryDataSet not implemented")
}
func (*UnimplementedTimeseriesInsightsControllerServer) EvaluateSlice(context.Context, *EvaluateSliceRequest) (*EvaluatedSlice, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method EvaluateSlice not implemented")
}

func RegisterTimeseriesInsightsControllerServer(s *grpc.Server, srv TimeseriesInsightsControllerServer) {
	s.RegisterService(&_TimeseriesInsightsController_serviceDesc, srv)
}

func _TimeseriesInsightsController_ListDataSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TimeseriesInsightsControllerServer).ListDataSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/ListDataSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TimeseriesInsightsControllerServer).ListDataSets(ctx, req.(*ListDataSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TimeseriesInsightsController_CreateDataSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TimeseriesInsightsControllerServer).CreateDataSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/CreateDataSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TimeseriesInsightsControllerServer).CreateDataSet(ctx, req.(*CreateDataSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TimeseriesInsightsController_DeleteDataSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TimeseriesInsightsControllerServer).DeleteDataSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/DeleteDataSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TimeseriesInsightsControllerServer).DeleteDataSet(ctx, req.(*DeleteDataSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TimeseriesInsightsController_AppendEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AppendEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TimeseriesInsightsControllerServer).AppendEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/AppendEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TimeseriesInsightsControllerServer).AppendEvents(ctx, req.(*AppendEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TimeseriesInsightsController_QueryDataSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryDataSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TimeseriesInsightsControllerServer).QueryDataSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/QueryDataSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TimeseriesInsightsControllerServer).QueryDataSet(ctx, req.(*QueryDataSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TimeseriesInsightsController_EvaluateSlice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvaluateSliceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TimeseriesInsightsControllerServer).EvaluateSlice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.timeseriesinsights.v1.TimeseriesInsightsController/EvaluateSlice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TimeseriesInsightsControllerServer).EvaluateSlice(ctx, req.(*EvaluateSliceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TimeseriesInsightsController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
	HandlerType: (*TimeseriesInsightsControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDataSets",
			Handler:    _TimeseriesInsightsController_ListDataSets_Handler,
		},
		{
			MethodName: "CreateDataSet",
			Handler:    _TimeseriesInsightsController_CreateDataSet_Handler,
		},
		{
			MethodName: "DeleteDataSet",
			Handler:    _TimeseriesInsightsController_DeleteDataSet_Handler,
		},
		{
			MethodName: "AppendEvents",
			Handler:    _TimeseriesInsightsController_AppendEvents_Handler,
		},
		{
			MethodName: "QueryDataSet",
			Handler:    _TimeseriesInsightsController_QueryDataSet_Handler,
		},
		{
			MethodName: "EvaluateSlice",
			Handler:    _TimeseriesInsightsController_EvaluateSlice_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/timeseriesinsights/v1/timeseries_insights.proto",
}
