// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/bigtable/v2/request_stats.proto

package bigtable

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ReadIteratorStats captures information about the iteration of rows or cells
// over the course of a read, e.g. how many results were scanned in a read
// operation versus the results returned.
type ReadIteratorStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rows seen (scanned) as part of the request. This includes the count of
	// rows returned, as captured below.
	RowsSeenCount int64 `protobuf:"varint,1,opt,name=rows_seen_count,json=rowsSeenCount,proto3" json:"rows_seen_count,omitempty"`
	// The rows returned as part of the request.
	RowsReturnedCount int64 `protobuf:"varint,2,opt,name=rows_returned_count,json=rowsReturnedCount,proto3" json:"rows_returned_count,omitempty"`
	// The cells seen (scanned) as part of the request. This includes the count of
	// cells returned, as captured below.
	CellsSeenCount int64 `protobuf:"varint,3,opt,name=cells_seen_count,json=cellsSeenCount,proto3" json:"cells_seen_count,omitempty"`
	// The cells returned as part of the request.
	CellsReturnedCount int64 `protobuf:"varint,4,opt,name=cells_returned_count,json=cellsReturnedCount,proto3" json:"cells_returned_count,omitempty"`
	// The deletes seen as part of the request.
	DeletesSeenCount int64 `protobuf:"varint,5,opt,name=deletes_seen_count,json=deletesSeenCount,proto3" json:"deletes_seen_count,omitempty"`
}

func (x *ReadIteratorStats) Reset() {
	*x = ReadIteratorStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadIteratorStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadIteratorStats) ProtoMessage() {}

func (x *ReadIteratorStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadIteratorStats.ProtoReflect.Descriptor instead.
func (*ReadIteratorStats) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_request_stats_proto_rawDescGZIP(), []int{0}
}

func (x *ReadIteratorStats) GetRowsSeenCount() int64 {
	if x != nil {
		return x.RowsSeenCount
	}
	return 0
}

func (x *ReadIteratorStats) GetRowsReturnedCount() int64 {
	if x != nil {
		return x.RowsReturnedCount
	}
	return 0
}

func (x *ReadIteratorStats) GetCellsSeenCount() int64 {
	if x != nil {
		return x.CellsSeenCount
	}
	return 0
}

func (x *ReadIteratorStats) GetCellsReturnedCount() int64 {
	if x != nil {
		return x.CellsReturnedCount
	}
	return 0
}

func (x *ReadIteratorStats) GetDeletesSeenCount() int64 {
	if x != nil {
		return x.DeletesSeenCount
	}
	return 0
}

// RequestLatencyStats provides a measurement of the latency of the request as
// it interacts with different systems over its lifetime, e.g. how long the
// request took to execute within a frontend server.
type RequestLatencyStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The latency measured by the frontend server handling this request, from
	// when the request was received, to when this value is sent back in the
	// response. For more context on the component that is measuring this latency,
	// see: https://cloud.google.com/bigtable/docs/overview
	//
	// Note: This value may be slightly shorter than the value reported into
	// aggregate latency metrics in Monitoring for this request
	// (https://cloud.google.com/bigtable/docs/monitoring-instance) as this value
	// needs to be sent in the response before the latency measurement including
	// that transmission is finalized.
	FrontendServerLatency *durationpb.Duration `protobuf:"bytes,1,opt,name=frontend_server_latency,json=frontendServerLatency,proto3" json:"frontend_server_latency,omitempty"`
}

func (x *RequestLatencyStats) Reset() {
	*x = RequestLatencyStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestLatencyStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestLatencyStats) ProtoMessage() {}

func (x *RequestLatencyStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestLatencyStats.ProtoReflect.Descriptor instead.
func (*RequestLatencyStats) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_request_stats_proto_rawDescGZIP(), []int{1}
}

func (x *RequestLatencyStats) GetFrontendServerLatency() *durationpb.Duration {
	if x != nil {
		return x.FrontendServerLatency
	}
	return nil
}

// ReadEfficiencyStats captures information about the efficiency of a read.
type ReadEfficiencyStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Iteration stats describe how efficient the read is, e.g. comparing
	// rows seen vs. rows returned or cells seen vs cells returned can provide an
	// indication of read efficiency (the higher the ratio of seen to retuned the
	// better).
	ReadIteratorStats *ReadIteratorStats `protobuf:"bytes,1,opt,name=read_iterator_stats,json=readIteratorStats,proto3" json:"read_iterator_stats,omitempty"`
	// Request latency stats describe the time taken to complete a request, from
	// the server side.
	RequestLatencyStats *RequestLatencyStats `protobuf:"bytes,2,opt,name=request_latency_stats,json=requestLatencyStats,proto3" json:"request_latency_stats,omitempty"`
}

func (x *ReadEfficiencyStats) Reset() {
	*x = ReadEfficiencyStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadEfficiencyStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadEfficiencyStats) ProtoMessage() {}

func (x *ReadEfficiencyStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadEfficiencyStats.ProtoReflect.Descriptor instead.
func (*ReadEfficiencyStats) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_request_stats_proto_rawDescGZIP(), []int{2}
}

func (x *ReadEfficiencyStats) GetReadIteratorStats() *ReadIteratorStats {
	if x != nil {
		return x.ReadIteratorStats
	}
	return nil
}

func (x *ReadEfficiencyStats) GetRequestLatencyStats() *RequestLatencyStats {
	if x != nil {
		return x.RequestLatencyStats
	}
	return nil
}

// AllReadStats captures all known information about a read.
type AllReadStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Iteration stats describe how efficient the read is, e.g. comparing
	// rows seen vs. rows returned or cells seen vs cells returned can provide an
	// indication of read efficiency (the higher the ratio of seen to retuned the
	// better).
	ReadIteratorStats *ReadIteratorStats `protobuf:"bytes,1,opt,name=read_iterator_stats,json=readIteratorStats,proto3" json:"read_iterator_stats,omitempty"`
	// Request latency stats describe the time taken to complete a request, from
	// the server side.
	RequestLatencyStats *RequestLatencyStats `protobuf:"bytes,2,opt,name=request_latency_stats,json=requestLatencyStats,proto3" json:"request_latency_stats,omitempty"`
}

func (x *AllReadStats) Reset() {
	*x = AllReadStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllReadStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllReadStats) ProtoMessage() {}

func (x *AllReadStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllReadStats.ProtoReflect.Descriptor instead.
func (*AllReadStats) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_request_stats_proto_rawDescGZIP(), []int{3}
}

func (x *AllReadStats) GetReadIteratorStats() *ReadIteratorStats {
	if x != nil {
		return x.ReadIteratorStats
	}
	return nil
}

func (x *AllReadStats) GetRequestLatencyStats() *RequestLatencyStats {
	if x != nil {
		return x.RequestLatencyStats
	}
	return nil
}

// RequestStats is the container for additional information pertaining to a
// single request, helpful for evaluating the performance of the sent request.
// Currently, there are the following supported methods:
//   - google.bigtable.v2.ReadRows
type RequestStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information pertaining to each request type received. The type is chosen
	// based on the requested view.
	//
	// See the messages above for additional context.
	//
	// Types that are assignable to Stats:
	//
	//	*RequestStats_ReadEfficiencyStats
	//	*RequestStats_AllReadStats
	Stats isRequestStats_Stats `protobuf_oneof:"stats"`
}

func (x *RequestStats) Reset() {
	*x = RequestStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestStats) ProtoMessage() {}

func (x *RequestStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_request_stats_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestStats.ProtoReflect.Descriptor instead.
func (*RequestStats) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_request_stats_proto_rawDescGZIP(), []int{4}
}

func (m *RequestStats) GetStats() isRequestStats_Stats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (x *RequestStats) GetReadEfficiencyStats() *ReadEfficiencyStats {
	if x, ok := x.GetStats().(*RequestStats_ReadEfficiencyStats); ok {
		return x.ReadEfficiencyStats
	}
	return nil
}

func (x *RequestStats) GetAllReadStats() *AllReadStats {
	if x, ok := x.GetStats().(*RequestStats_AllReadStats); ok {
		return x.AllReadStats
	}
	return nil
}

type isRequestStats_Stats interface {
	isRequestStats_Stats()
}

type RequestStats_ReadEfficiencyStats struct {
	// Available with the
	// ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
	// package google.bigtable.v2.
	ReadEfficiencyStats *ReadEfficiencyStats `protobuf:"bytes,1,opt,name=read_efficiency_stats,json=readEfficiencyStats,proto3,oneof"`
}

type RequestStats_AllReadStats struct {
	// Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
	// view, see package google.bigtable.v2.
	AllReadStats *AllReadStats `protobuf:"bytes,2,opt,name=all_read_stats,json=allReadStats,proto3,oneof"`
}

func (*RequestStats_ReadEfficiencyStats) isRequestStats_Stats() {}

func (*RequestStats_AllReadStats) isRequestStats_Stats() {}

var File_google_bigtable_v2_request_stats_proto protoreflect.FileDescriptor

var file_google_bigtable_v2_request_stats_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf5, 0x01, 0x0a,
	0x11, 0x52, 0x65, 0x61, 0x64, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x72, 0x6f, 0x77,
	0x73, 0x53, 0x65, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x6f,
	0x77, 0x73, 0x5f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x72, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x74,
	0x75, 0x72, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x65,
	0x6c, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x53, 0x65, 0x65, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x5f, 0x72, 0x65,
	0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x12, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65,
	0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x73, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x10, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x73, 0x53, 0x65, 0x65, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0x68, 0x0a, 0x13, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c,
	0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x17, 0x66,
	0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6c,
	0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x22, 0xc9,
	0x01, 0x0a, 0x13, 0x52, 0x65, 0x61, 0x64, 0x45, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63,
	0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x55, 0x0a, 0x13, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x49, 0x74, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x11, 0x72, 0x65, 0x61, 0x64,
	0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x5b, 0x0a,
	0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x61,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0xc2, 0x01, 0x0a, 0x0c, 0x41,
	0x6c, 0x6c, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x55, 0x0a, 0x13, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x11, 0x72, 0x65, 0x61, 0x64, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x5b, 0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x61,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x61,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x13, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x22,
	0xc0, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x5d, 0x0a, 0x15, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x45, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65,
	0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52, 0x13, 0x72, 0x65, 0x61, 0x64,
	0x45, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12,
	0x48, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6c, 0x6c,
	0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x42, 0xbd, 0x01, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x42, 0x11, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2f, 0x76, 0x32, 0x3b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0xaa, 0x02,
	0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x3a,
	0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_v2_request_stats_proto_rawDescOnce sync.Once
	file_google_bigtable_v2_request_stats_proto_rawDescData = file_google_bigtable_v2_request_stats_proto_rawDesc
)

func file_google_bigtable_v2_request_stats_proto_rawDescGZIP() []byte {
	file_google_bigtable_v2_request_stats_proto_rawDescOnce.Do(func() {
		file_google_bigtable_v2_request_stats_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_v2_request_stats_proto_rawDescData)
	})
	return file_google_bigtable_v2_request_stats_proto_rawDescData
}

var file_google_bigtable_v2_request_stats_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_bigtable_v2_request_stats_proto_goTypes = []interface{}{
	(*ReadIteratorStats)(nil),   // 0: google.bigtable.v2.ReadIteratorStats
	(*RequestLatencyStats)(nil), // 1: google.bigtable.v2.RequestLatencyStats
	(*ReadEfficiencyStats)(nil), // 2: google.bigtable.v2.ReadEfficiencyStats
	(*AllReadStats)(nil),        // 3: google.bigtable.v2.AllReadStats
	(*RequestStats)(nil),        // 4: google.bigtable.v2.RequestStats
	(*durationpb.Duration)(nil), // 5: google.protobuf.Duration
}
var file_google_bigtable_v2_request_stats_proto_depIdxs = []int32{
	5, // 0: google.bigtable.v2.RequestLatencyStats.frontend_server_latency:type_name -> google.protobuf.Duration
	0, // 1: google.bigtable.v2.ReadEfficiencyStats.read_iterator_stats:type_name -> google.bigtable.v2.ReadIteratorStats
	1, // 2: google.bigtable.v2.ReadEfficiencyStats.request_latency_stats:type_name -> google.bigtable.v2.RequestLatencyStats
	0, // 3: google.bigtable.v2.AllReadStats.read_iterator_stats:type_name -> google.bigtable.v2.ReadIteratorStats
	1, // 4: google.bigtable.v2.AllReadStats.request_latency_stats:type_name -> google.bigtable.v2.RequestLatencyStats
	2, // 5: google.bigtable.v2.RequestStats.read_efficiency_stats:type_name -> google.bigtable.v2.ReadEfficiencyStats
	3, // 6: google.bigtable.v2.RequestStats.all_read_stats:type_name -> google.bigtable.v2.AllReadStats
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_bigtable_v2_request_stats_proto_init() }
func file_google_bigtable_v2_request_stats_proto_init() {
	if File_google_bigtable_v2_request_stats_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_bigtable_v2_request_stats_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadIteratorStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v2_request_stats_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestLatencyStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v2_request_stats_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadEfficiencyStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v2_request_stats_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllReadStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v2_request_stats_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_bigtable_v2_request_stats_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*RequestStats_ReadEfficiencyStats)(nil),
		(*RequestStats_AllReadStats)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_v2_request_stats_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_v2_request_stats_proto_goTypes,
		DependencyIndexes: file_google_bigtable_v2_request_stats_proto_depIdxs,
		MessageInfos:      file_google_bigtable_v2_request_stats_proto_msgTypes,
	}.Build()
	File_google_bigtable_v2_request_stats_proto = out.File
	file_google_bigtable_v2_request_stats_proto_rawDesc = nil
	file_google_bigtable_v2_request_stats_proto_goTypes = nil
	file_google_bigtable_v2_request_stats_proto_depIdxs = nil
}
