// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostEndpointProtectionScanResultSortByEnum Enum with underlying type: string
type HostEndpointProtectionScanResultSortByEnum string

// Set of constants representing the allowable values for HostEndpointProtectionScanResultSortByEnum
const (
	HostEndpointProtectionScanResultSortByTimeStarted     HostEndpointProtectionScanResultSortByEnum = "timeStarted"
	HostEndpointProtectionScanResultSortByTimeFinished    HostEndpointProtectionScanResultSortByEnum = "timeFinished"
	HostEndpointProtectionScanResultSortByProblemSeverity HostEndpointProtectionScanResultSortByEnum = "problemSeverity"
)

var mappingHostEndpointProtectionScanResultSortByEnum = map[string]HostEndpointProtectionScanResultSortByEnum{
	"timeStarted":     HostEndpointProtectionScanResultSortByTimeStarted,
	"timeFinished":    HostEndpointProtectionScanResultSortByTimeFinished,
	"problemSeverity": HostEndpointProtectionScanResultSortByProblemSeverity,
}

var mappingHostEndpointProtectionScanResultSortByEnumLowerCase = map[string]HostEndpointProtectionScanResultSortByEnum{
	"timestarted":     HostEndpointProtectionScanResultSortByTimeStarted,
	"timefinished":    HostEndpointProtectionScanResultSortByTimeFinished,
	"problemseverity": HostEndpointProtectionScanResultSortByProblemSeverity,
}

// GetHostEndpointProtectionScanResultSortByEnumValues Enumerates the set of values for HostEndpointProtectionScanResultSortByEnum
func GetHostEndpointProtectionScanResultSortByEnumValues() []HostEndpointProtectionScanResultSortByEnum {
	values := make([]HostEndpointProtectionScanResultSortByEnum, 0)
	for _, v := range mappingHostEndpointProtectionScanResultSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetHostEndpointProtectionScanResultSortByEnumStringValues Enumerates the set of values in String for HostEndpointProtectionScanResultSortByEnum
func GetHostEndpointProtectionScanResultSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"problemSeverity",
	}
}

// GetMappingHostEndpointProtectionScanResultSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostEndpointProtectionScanResultSortByEnum(val string) (HostEndpointProtectionScanResultSortByEnum, bool) {
	enum, ok := mappingHostEndpointProtectionScanResultSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
