// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Oracle Database MultiCloud Data plane Integration
//
// 1. Oracle Azure Connector Resource: This is for installing Azure Arc Server in ExaCS VM Cluster.
//   There are two way to install Azure Arc Server (Azure Identity) in ExaCS VMCluster.
//     a. Using Bearer Access Token or
//     b. By providing Authentication token
// 2. Oracle Azure Blob Container Resource: This is for to capture Azure Container details
//    and same will be used in multiple ExaCS VMCluster to mount the Azure Container.
// 3. Oracle Azure Blob Mount Resource: This is for to mount Azure Container in ExaCS VMCluster
//    using Oracle Azure Connector and Oracle Azure Blob Container Resource.
//

package dbmulticloud

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// OracleDbAzureVault Oracle DB Azure Vault Resource Object.
type OracleDbAzureVault struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Azure Vault Resource.
	Id *string `mandatory:"true" json:"id"`

	// Display name of DB Azure Vault.
	DisplayName *string `mandatory:"true" json:"displayName"`

	// Display name of Azure Resource Group.
	OracleDbAzureResourceGroup *string `mandatory:"true" json:"oracleDbAzureResourceGroup"`

	// The Compartment OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that has this DB Azure Vault Resource.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
	OracleDbConnectorId *string `mandatory:"false" json:"oracleDbConnectorId"`

	// Azure Vault Id.
	AzureVaultId *string `mandatory:"false" json:"azureVaultId"`

	// Vault Resource Type.
	Type *string `mandatory:"false" json:"type"`

	// Vault Resource Location.
	Location *string `mandatory:"false" json:"location"`

	// Resource's properties.
	Properties map[string]string `mandatory:"false" json:"properties"`

	// The lifecycle state of the DB Azure Vault Resource.
	LifecycleState OracleDbAzureVaultLifecycleStateEnum `mandatory:"false" json:"lifecycleState,omitempty"`

	// Description of the current lifecycle state in more detail.
	LifecycleStateDetails *string `mandatory:"false" json:"lifecycleStateDetails"`

	// Time when the DB Azure Vault was created in RFC 3339 (https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
	TimeCreated *common.SDKTime `mandatory:"false" json:"timeCreated"`

	// Time when the DB Azure Vault was last modified, expressed in RFC 3339 (https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
	TimeUpdated *common.SDKTime `mandatory:"false" json:"timeUpdated"`

	// Description of the latest modification of the DB Azure Vault Resource.
	LastModification *string `mandatory:"false" json:"lastModification"`

	// Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
	// For more information, see Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Department": "Finance"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// For more information, see Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Operations": {"CostCenter": "42"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m OracleDbAzureVault) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m OracleDbAzureVault) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingOracleDbAzureVaultLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetOracleDbAzureVaultLifecycleStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// OracleDbAzureVaultLifecycleStateEnum Enum with underlying type: string
type OracleDbAzureVaultLifecycleStateEnum string

// Set of constants representing the allowable values for OracleDbAzureVaultLifecycleStateEnum
const (
	OracleDbAzureVaultLifecycleStateCreating OracleDbAzureVaultLifecycleStateEnum = "CREATING"
	OracleDbAzureVaultLifecycleStateActive   OracleDbAzureVaultLifecycleStateEnum = "ACTIVE"
	OracleDbAzureVaultLifecycleStateUpdating OracleDbAzureVaultLifecycleStateEnum = "UPDATING"
	OracleDbAzureVaultLifecycleStateDeleting OracleDbAzureVaultLifecycleStateEnum = "DELETING"
	OracleDbAzureVaultLifecycleStateDeleted  OracleDbAzureVaultLifecycleStateEnum = "DELETED"
	OracleDbAzureVaultLifecycleStateFailed   OracleDbAzureVaultLifecycleStateEnum = "FAILED"
)

var mappingOracleDbAzureVaultLifecycleStateEnum = map[string]OracleDbAzureVaultLifecycleStateEnum{
	"CREATING": OracleDbAzureVaultLifecycleStateCreating,
	"ACTIVE":   OracleDbAzureVaultLifecycleStateActive,
	"UPDATING": OracleDbAzureVaultLifecycleStateUpdating,
	"DELETING": OracleDbAzureVaultLifecycleStateDeleting,
	"DELETED":  OracleDbAzureVaultLifecycleStateDeleted,
	"FAILED":   OracleDbAzureVaultLifecycleStateFailed,
}

var mappingOracleDbAzureVaultLifecycleStateEnumLowerCase = map[string]OracleDbAzureVaultLifecycleStateEnum{
	"creating": OracleDbAzureVaultLifecycleStateCreating,
	"active":   OracleDbAzureVaultLifecycleStateActive,
	"updating": OracleDbAzureVaultLifecycleStateUpdating,
	"deleting": OracleDbAzureVaultLifecycleStateDeleting,
	"deleted":  OracleDbAzureVaultLifecycleStateDeleted,
	"failed":   OracleDbAzureVaultLifecycleStateFailed,
}

// GetOracleDbAzureVaultLifecycleStateEnumValues Enumerates the set of values for OracleDbAzureVaultLifecycleStateEnum
func GetOracleDbAzureVaultLifecycleStateEnumValues() []OracleDbAzureVaultLifecycleStateEnum {
	values := make([]OracleDbAzureVaultLifecycleStateEnum, 0)
	for _, v := range mappingOracleDbAzureVaultLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetOracleDbAzureVaultLifecycleStateEnumStringValues Enumerates the set of values in String for OracleDbAzureVaultLifecycleStateEnum
func GetOracleDbAzureVaultLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"ACTIVE",
		"UPDATING",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingOracleDbAzureVaultLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingOracleDbAzureVaultLifecycleStateEnum(val string) (OracleDbAzureVaultLifecycleStateEnum, bool) {
	enum, ok := mappingOracleDbAzureVaultLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
