// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Java Management Service Java Download API
//
// The APIs for the Java Download (https://docs.oracle.com/en-us/iaas/jms/doc/java-download.html) feature of Java Management Service.
//

package jmsjavadownloads

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// UpdateJavaDownloadTokenDetails The attributes of the JavaDownloadToken to be updated.
type UpdateJavaDownloadTokenDetails struct {

	// User provided display name of the JavaDownloadToken.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// User provided description of the JavaDownloadToken.
	Description *string `mandatory:"false" json:"description"`

	// Update the token default status.
	IsDefault *bool `mandatory:"false" json:"isDefault"`

	// Expiry time of the token.
	TimeExpires *common.SDKTime `mandatory:"false" json:"timeExpires"`

	// The license type(s) associated with the JavaDownloadToken.
	LicenseType []LicenseTypeEnum `mandatory:"false" json:"licenseType"`

	// Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`. (See Managing Tags and Tag Namespaces (https://docs.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`. (See Understanding Free-form Tags (https://docs.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`
}

func (m UpdateJavaDownloadTokenDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m UpdateJavaDownloadTokenDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
