// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Secure Desktops API
//
// Create and manage cloud-hosted desktops which can be accessed from a web browser or installed client.
//

package desktops

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// UpdateDesktopPoolDesktopSessionLifecycleActions The update details of action to be triggered in case of inactivity or disconnect
type UpdateDesktopPoolDesktopSessionLifecycleActions struct {
	Inactivity *InactivityConfig `mandatory:"false" json:"inactivity"`

	Disconnect *DisconnectConfig `mandatory:"false" json:"disconnect"`
}

func (m UpdateDesktopPoolDesktopSessionLifecycleActions) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m UpdateDesktopPoolDesktopSessionLifecycleActions) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
